/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.models.Feature;
import io.github.isagroup.models.UsageLimit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Plan {
    private String name;
    private String description;
    private Object price;
    private String unit;
    private Boolean isPrivate;
    private Map<String, Feature> features;
    private Map<String, UsageLimit> usageLimits;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getPrice() {
        return this.price;
    }

    public void setPrice(Object price) {
        this.price = price;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Boolean getPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(Boolean aPrivate) {
        this.isPrivate = aPrivate;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }

    public Map<String, UsageLimit> getUsageLimits() {
        return this.usageLimits;
    }

    public void setUsageLimits(Map<String, UsageLimit> usageLimits) {
        this.usageLimits = usageLimits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plan plan = (Plan)o;
        return Objects.equals(this.name, plan.name) && Objects.equals(this.description, plan.description) && Objects.equals(this.price, plan.price) && Objects.equals(this.unit, plan.unit) && Objects.equals(this.isPrivate, plan.isPrivate) && Objects.equals(this.features, plan.features) && Objects.equals(this.usageLimits, plan.usageLimits);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.price, this.unit, this.isPrivate, this.features, this.usageLimits);
    }

    public String toString() {
        return "Plan [name=" + this.name + ", description=" + this.description + ", price=" + String.valueOf(this.price) + ", unit=" + this.unit + ", isPrivate=" + this.isPrivate + ", features=" + String.valueOf(this.features) + ", usageLimits=" + String.valueOf(this.usageLimits) + "]";
    }

    public Map<String, Object> parseToMap() {
        LinkedHashMap<String, Object> planMap = new LinkedHashMap<String, Object>();
        planMap.put("name", this.name);
        planMap.put("description", this.description);
        planMap.put("price", this.price);
        planMap.put("unit", this.unit);
        planMap.put("isPrivate", this.isPrivate);
        planMap.put("features", this.features);
        planMap.put("usageLimits", this.usageLimits);
        return planMap;
    }

    public Map<String, Object> serializePlan() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (this.description != null) {
            attributes.put("description", this.description);
        }
        attributes.put("price", this.price);
        if (this.unit != null) {
            attributes.put("unit", this.unit);
        }
        if (this.isPrivate != null && this.isPrivate.booleanValue()) {
            attributes.put("private", this.isPrivate);
        }
        attributes.put("features", this.serializeFeatures().orElse(null));
        attributes.put("usageLimits", this.serializeUsageLimits().orElse(null));
        return attributes;
    }

    private <V> Optional<Map<String, V>> serializeValue(V value) {
        if (value == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, V> attributes = new LinkedHashMap<String, V>();
        attributes.put("value", value);
        return Optional.of(attributes);
    }

    private Optional<Map<String, Object>> serializeFeatures() {
        boolean featureMapIsEmpty;
        if (this.features == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedFeatures = new LinkedHashMap<String, Map<String, Object>>();
        for (Feature feature : this.features.values()) {
            Optional<Map<String, Object>> serializedFeature = this.serializeValue(feature.getValue());
            if (!serializedFeature.isPresent()) continue;
            serializedFeatures.put(feature.getName(), serializedFeature.get());
        }
        boolean bl = featureMapIsEmpty = serializedFeatures.size() == 0;
        if (featureMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedFeatures);
    }

    private Optional<Map<String, Object>> serializeUsageLimits() {
        boolean usageLimitMapIsEmpty;
        if (this.usageLimits == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedUsageLimits = new LinkedHashMap<String, Map<String, Object>>();
        for (UsageLimit usageLimit : this.usageLimits.values()) {
            Optional<Map<String, Object>> serializedUsageLimit = this.serializeValue(usageLimit.getValue());
            if (!serializedUsageLimit.isPresent()) continue;
            serializedUsageLimits.put(usageLimit.getName(), serializedUsageLimit.get());
        }
        boolean bl = usageLimitMapIsEmpty = serializedUsageLimits.size() == 0;
        if (usageLimitMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedUsageLimits);
    }
}

