/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.services.updaters.Version;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public class PricingManager {
    private Version syntaxVersion;
    private String saasName;
    private String url;
    private LocalDate createdAt;
    private String version;
    private String currency;
    private List<String> tags;
    private Map<String, Double> billing;
    private Map<String, Object> variables;
    private Map<String, Feature> features;
    private Map<String, UsageLimit> usageLimits;
    private Map<String, Plan> plans;
    private Map<String, AddOn> addOns;

    public Version getSyntaxVersion() {
        return this.syntaxVersion;
    }

    public void setSyntaxVersion(Version syntaxVersion) {
        this.syntaxVersion = syntaxVersion;
    }

    public String getSaasName() {
        return this.saasName;
    }

    public void setSaasName(String saasName) {
        this.saasName = saasName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public LocalDate getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDate createdAt) {
        this.createdAt = createdAt;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Map<String, Double> getBilling() {
        return this.billing;
    }

    public void setBilling(Map<String, Double> billing) {
        this.billing = billing;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }

    public Map<String, UsageLimit> getUsageLimits() {
        return this.usageLimits;
    }

    public void setUsageLimits(Map<String, UsageLimit> usageLimits) {
        this.usageLimits = usageLimits;
    }

    public Map<String, Plan> getPlans() {
        return this.plans;
    }

    public void setPlans(Map<String, Plan> plans) {
        this.plans = plans;
    }

    public Map<String, AddOn> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(Map<String, AddOn> addOns) {
        this.addOns = addOns;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.syntaxVersion == null ? 0 : this.syntaxVersion.hashCode());
        result = 31 * result + (this.saasName == null ? 0 : this.saasName.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.billing == null ? 0 : this.billing.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.usageLimits == null ? 0 : this.usageLimits.hashCode());
        result = 31 * result + (this.plans == null ? 0 : this.plans.hashCode());
        result = 31 * result + (this.addOns == null ? 0 : this.addOns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PricingManager other = (PricingManager)obj;
        if (this.syntaxVersion != other.syntaxVersion) {
            return false;
        }
        if (this.saasName == null ? other.saasName != null : !this.saasName.equals(other.saasName)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.createdAt == null ? other.createdAt != null : !this.createdAt.equals(other.createdAt)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        if (this.billing == null ? other.billing != null : !this.billing.equals(other.billing)) {
            return false;
        }
        if (this.variables == null ? other.variables != null : !this.variables.equals(other.variables)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.usageLimits == null ? other.usageLimits != null : !this.usageLimits.equals(other.usageLimits)) {
            return false;
        }
        if (this.plans == null ? other.plans != null : !this.plans.equals(other.plans)) {
            return false;
        }
        return !(this.addOns == null ? other.addOns != null : !this.addOns.equals(other.addOns));
    }

    public String toString() {
        return "PricingManager [syntaxVersion=" + String.valueOf((Object)this.syntaxVersion) + ", saasName=" + this.saasName + ", url=" + this.url + ", createdAt=" + String.valueOf(this.createdAt) + ", version=" + this.version + ", currency=" + this.currency + ", tags=" + String.valueOf(this.tags) + ", billing=" + String.valueOf(this.billing) + ", variables=" + String.valueOf(this.variables) + ", features=" + String.valueOf(this.features) + ", usageLimits=" + String.valueOf(this.usageLimits) + ", plans=" + String.valueOf(this.plans) + ", addOns=" + String.valueOf(this.addOns) + "]";
    }

    public void validateFeatureTags() {
        for (Feature feature : this.features.values()) {
            if (feature.getTag() == null || this.tags.contains(feature.getTag())) continue;
            throw new IllegalArgumentException("Tag " + feature.getTag() + " not found in pricing configuration");
        }
    }
}

