/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.serializer;

import io.github.isagroup.exceptions.SerializerException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.services.updaters.Version;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class PricingManagerSerializer {
    private Map<String, Object> serializedPricingManager = new LinkedHashMap<String, Object>();

    public Map<String, Object> serialize(PricingManager pricingManager) throws SerializerException {
        this.serializedPricingManager.put("syntaxVersion", Version.LATEST.toString());
        this.serializedPricingManager.put("saasName", pricingManager.getSaasName());
        this.serializedPricingManager.put("createdAt", pricingManager.getCreatedAt().toString());
        if (pricingManager.getVersion() != null) {
            this.serializedPricingManager.put("version", pricingManager.getVersion());
        }
        if (pricingManager.getUrl() != null) {
            this.serializedPricingManager.put("url", pricingManager.getUrl());
        }
        if (pricingManager.getVariables() != null) {
            this.serializedPricingManager.put("variables", pricingManager.getVariables());
        }
        if (pricingManager.getTags() != null) {
            this.serializedPricingManager.put("tags", pricingManager.getTags());
        }
        this.serializedPricingManager.put("billing", pricingManager.getBilling());
        this.serializedPricingManager.put("currency", pricingManager.getCurrency());
        if (pricingManager.getFeatures() == null) {
            throw new SerializerException("Features are null. Filling the pricing with features is mandatory.");
        }
        if (pricingManager.getPlans() == null && pricingManager.getAddOns() == null) {
            throw new SerializerException("Plans and AddOns are null. You have to set at least one of them.");
        }
        this.serializedPricingManager.put("features", this.serializeFeatures(pricingManager));
        this.serializedPricingManager.put("usageLimits", this.serializeUsageLimits(pricingManager));
        this.serializedPricingManager.put("plans", this.serializePlans(pricingManager));
        this.serializedPricingManager.put("addOns", this.serializeAddOns(pricingManager).orElse(null));
        return this.serializedPricingManager;
    }

    private Map<String, Object> serializeFeatures(PricingManager pricingManager) {
        LinkedHashMap<String, Object> serializedFeatures = new LinkedHashMap<String, Object>();
        for (Feature feature : pricingManager.getFeatures().values()) {
            serializedFeatures.put(feature.getName(), feature.serializeFeature());
        }
        return serializedFeatures;
    }

    private Map<String, Object> serializeUsageLimits(PricingManager pricingManager) {
        LinkedHashMap<String, Object> serializedUsageLimits = new LinkedHashMap<String, Object>();
        if (pricingManager.getUsageLimits() == null) {
            return null;
        }
        for (UsageLimit usageLimit : pricingManager.getUsageLimits().values()) {
            serializedUsageLimits.put(usageLimit.getName(), usageLimit.serialize());
        }
        return serializedUsageLimits;
    }

    private Map<String, Object> serializePlans(PricingManager pricingManager) {
        LinkedHashMap<String, Object> serializedPlans = new LinkedHashMap<String, Object>();
        for (Plan plan : pricingManager.getPlans().values()) {
            serializedPlans.put(plan.getName(), plan.serializePlan());
        }
        return serializedPlans;
    }

    public Optional<Map<String, Object>> serializeAddOns(PricingManager pricingManager) {
        if (pricingManager.getAddOns() == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedAddOns = new LinkedHashMap<String, Map<String, Object>>();
        for (AddOn addOn : pricingManager.getAddOns().values()) {
            serializedAddOns.put(addOn.getName(), addOn.serializeAddOn());
        }
        return Optional.of(serializedAddOns);
    }
}

