/*
 * Decompiled with CFR 0.152.
 */
package org.ncgroup.kscan;

import android.graphics.Rect;
import android.media.Image;
import android.util.Log;
import androidx.annotation.OptIn;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ZoomState;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.ZoomSuggestionOptions;
import com.google.mlkit.vision.common.InputImage;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ncgroup.kscan.Barcode;
import org.ncgroup.kscan.BarcodeFormat;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001Bg\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0004\u0012\u00020\f0\n\u0012\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\f0\n\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0017J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/ncgroup/kscan/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "camera", "Landroidx/camera/core/Camera;", "frame", "", "codeTypes", "", "Lorg/ncgroup/kscan/BarcodeFormat;", "onSuccess", "Lkotlin/Function1;", "Lorg/ncgroup/kscan/Barcode;", "", "onFailed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onCanceled", "Lkotlin/Function0;", "<init>", "(Landroidx/camera/core/Camera;FLjava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "options", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "barcodesDetected", "", "", "", "barcodesConfirmed", "", "getFormatFlags", "analyze", "imageProxy", "Landroidx/camera/core/ImageProxy;", "isRequestedFormat", "", "barcode", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "getBarcodeFormat", "lib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBarcodeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1797#2,3:190\n1755#2,3:193\n*S KotlinDebug\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n*L\n53#1:190,3\n107#1:193,3\n*E\n"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    @Nullable
    private final Camera camera;
    private final float frame;
    @NotNull
    private final List<BarcodeFormat> codeTypes;
    @NotNull
    private final Function1<List<Barcode>, Unit> onSuccess;
    @NotNull
    private final Function1<Exception, Unit> onFailed;
    @NotNull
    private final Function0<Unit> onCanceled;
    @NotNull
    private final BarcodeScannerOptions options;
    @NotNull
    private final BarcodeScanner scanner;
    @NotNull
    private final Map<String, Integer> barcodesDetected;
    @NotNull
    private final Set<Barcode> barcodesConfirmed;
    public static final int $stable = 8;

    public BarcodeAnalyzer(@Nullable Camera camera, float frame, @NotNull List<? extends BarcodeFormat> codeTypes, @NotNull Function1<? super List<Barcode>, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailed, @NotNull Function0<Unit> onCanceled) {
        Intrinsics.checkNotNullParameter(codeTypes, (String)"codeTypes");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailed, (String)"onFailed");
        Intrinsics.checkNotNullParameter(onCanceled, (String)"onCanceled");
        this.camera = camera;
        this.frame = frame;
        this.codeTypes = codeTypes;
        this.onSuccess = onSuccess;
        this.onFailed = onFailed;
        this.onCanceled = onCanceled;
        BarcodeScannerOptions barcodeScannerOptions = new BarcodeScannerOptions.Builder().setBarcodeFormats(this.getFormatFlags(), new int[0]).setZoomSuggestionOptions(new ZoomSuggestionOptions.Builder(new ZoomSuggestionOptions.ZoomCallback(this){
            final /* synthetic */ BarcodeAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean setZoom(float zoomRatio) {
                float maxZoomRatio;
                Camera camera = BarcodeAnalyzer.access$getCamera$p(this.this$0);
                CameraControl cameraControl = camera != null ? camera.getCameraControl() : null;
                Camera camera2 = BarcodeAnalyzer.access$getCamera$p(this.this$0);
                float f = camera2 != null && (camera2 = camera2.getCameraInfo()) != null && (camera2 = camera2.getZoomState()) != null && (camera2 = (ZoomState)camera2.getValue()) != null ? camera2.getMaxZoomRatio() : (maxZoomRatio = 1.0f);
                if (zoomRatio <= maxZoomRatio) {
                    CameraControl cameraControl2 = cameraControl;
                    if (cameraControl2 != null) {
                        cameraControl2.setZoomRatio(zoomRatio);
                    }
                    return true;
                }
                return false;
            }
        }).setMaxSupportedZoomRatio(5.0f).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScannerOptions, (String)"build(...)");
        this.options = barcodeScannerOptions;
        BarcodeScanner barcodeScanner = BarcodeScanning.getClient((BarcodeScannerOptions)this.options);
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner, (String)"getClient(...)");
        this.scanner = barcodeScanner;
        this.barcodesDetected = new LinkedHashMap();
        this.barcodesConfirmed = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    private final int getFormatFlags() {
        void $this$fold$iv;
        if (this.codeTypes.isEmpty() || this.codeTypes.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS)) {
            return 0;
        }
        Iterable iterable = this.codeTypes;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void format;
            BarcodeFormat barcodeFormat = (BarcodeFormat)((Object)element$iv);
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc | (switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1 -> 256;
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 4;
                case 5 -> 8;
                case 6 -> 16;
                case 7 -> 32;
                case 8 -> 64;
                case 9 -> 128;
                case 10 -> 512;
                case 11 -> 1024;
                case 12 -> 2048;
                case 13 -> 4096;
                case 14 -> 0;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        return accumulator$iv;
    }

    @OptIn(markerClass={ExperimentalGetImage.class})
    public void analyze(@NotNull ImageProxy imageProxy) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        Image mediaImage = imageProxy.getImage();
        if (mediaImage != null) {
            InputImage inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)imageProxy.getImageInfo().getRotationDegrees());
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(...)");
            InputImage image = inputImage;
            this.scanner.process(image).addOnSuccessListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$3(arg_0 -> BarcodeAnalyzer.analyze$lambda$2(imageProxy, this, arg_0), arg_0)).addOnFailureListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$4(this, arg_0)).addOnCanceledListener(() -> BarcodeAnalyzer.analyze$lambda$5(this, imageProxy)).addOnCompleteListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$6(imageProxy, arg_0));
        }
    }

    private final boolean isRequestedFormat(com.google.mlkit.vision.barcode.common.Barcode barcode) {
        BarcodeFormat barcodeFormat;
        if (this.codeTypes.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS)) {
            return true;
        }
        switch (barcode.getFormat()) {
            case 256: {
                barcodeFormat = BarcodeFormat.FORMAT_QR_CODE;
                break;
            }
            case 1: {
                barcodeFormat = BarcodeFormat.FORMAT_CODE_128;
                break;
            }
            case 2: {
                barcodeFormat = BarcodeFormat.FORMAT_CODE_39;
                break;
            }
            case 4: {
                barcodeFormat = BarcodeFormat.FORMAT_CODE_93;
                break;
            }
            case 8: {
                barcodeFormat = BarcodeFormat.FORMAT_CODABAR;
                break;
            }
            case 16: {
                barcodeFormat = BarcodeFormat.FORMAT_DATA_MATRIX;
                break;
            }
            case 32: {
                barcodeFormat = BarcodeFormat.FORMAT_EAN_13;
                break;
            }
            case 64: {
                barcodeFormat = BarcodeFormat.FORMAT_EAN_8;
                break;
            }
            case 128: {
                barcodeFormat = BarcodeFormat.FORMAT_ITF;
                break;
            }
            case 512: {
                barcodeFormat = BarcodeFormat.FORMAT_UPC_A;
                break;
            }
            case 1024: {
                barcodeFormat = BarcodeFormat.FORMAT_UPC_E;
                break;
            }
            case 2048: {
                barcodeFormat = BarcodeFormat.FORMAT_PDF417;
                break;
            }
            case 4096: {
                barcodeFormat = BarcodeFormat.FORMAT_AZTEC;
                break;
            }
            default: {
                return false;
            }
        }
        BarcodeFormat format = barcodeFormat;
        return this.codeTypes.contains((Object)format);
    }

    private final String getBarcodeFormat(com.google.mlkit.vision.barcode.common.Barcode barcode) {
        return switch (barcode.getFormat()) {
            case 256 -> "QR_CODE";
            case 1 -> "CODE_128";
            case 2 -> "CODE_39";
            case 4 -> "CODE_93";
            case 8 -> "CODABAR";
            case 16 -> "DATA_MATRIX";
            case 32 -> "EAN_13";
            case 64 -> "EAN_8";
            case 128 -> "ITF";
            case 512 -> "UPC_A";
            case 1024 -> "UPC_E";
            case 2048 -> "PDF417";
            case 4096 -> "AZTEC";
            default -> "UNKNOWN";
        };
    }

    private static final Unit analyze$lambda$2(ImageProxy $imageProxy, BarcodeAnalyzer this$0, List barcodes) {
        float previewWidth = $imageProxy.getWidth();
        float previewHeight = $imageProxy.getHeight();
        float frameLeft = (previewWidth - this$0.frame) / (float)2;
        float frameTop = (previewHeight - this$0.frame) / (float)2;
        float frameRight = frameLeft + this$0.frame;
        float frameBottom = frameTop + this$0.frame;
        for (com.google.mlkit.vision.barcode.common.Barcode barcode : barcodes) {
            Rect boundingBox = barcode.getBoundingBox();
            Intrinsics.checkNotNull((Object)barcode);
            if (!this$0.isRequestedFormat(barcode) || boundingBox == null) continue;
            if ((float)boundingBox.left >= frameLeft && (float)boundingBox.top >= frameTop && (float)boundingBox.right <= frameRight && (float)boundingBox.bottom <= frameBottom) {
                boolean bl;
                String displayValue;
                block7: {
                    displayValue = barcode.getDisplayValue();
                    if (displayValue == null) continue;
                    Map<String, Integer> map = this$0.barcodesDetected;
                    Integer n = this$0.barcodesDetected.get(displayValue);
                    Object object = (n != null ? n : 0) + 1;
                    map.put(displayValue, (Integer)object);
                    Integer n2 = this$0.barcodesDetected.get(displayValue);
                    if (n2 == null) {
                        object = "Required value was null.";
                        throw new IllegalArgumentException(object.toString());
                    }
                    if (((Number)n2).intValue() < 2) continue;
                    Iterable $this$any$iv = this$0.barcodesConfirmed;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Barcode it = (Barcode)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getData(), (Object)displayValue)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                this$0.barcodesConfirmed.add(new Barcode(displayValue, this$0.getBarcodeFormat(barcode)));
                continue;
            }
            Log.d((String)"barcode", (String)"barcode is outside the frame.");
        }
        List confirmedBarcodes = CollectionsKt.toList((Iterable)this$0.barcodesConfirmed);
        if (!((Collection)confirmedBarcodes).isEmpty()) {
            this$0.onSuccess.invoke((Object)confirmedBarcodes);
            this$0.barcodesDetected.clear();
            this$0.barcodesConfirmed.clear();
        }
        $imageProxy.close();
        return Unit.INSTANCE;
    }

    private static final void analyze$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void analyze$lambda$4(BarcodeAnalyzer this$0, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onFailed.invoke((Object)it);
    }

    private static final void analyze$lambda$5(BarcodeAnalyzer this$0, ImageProxy $imageProxy) {
        this$0.onCanceled.invoke();
        $imageProxy.close();
    }

    private static final void analyze$lambda$6(ImageProxy $imageProxy, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $imageProxy.close();
    }

    public static final /* synthetic */ Camera access$getCamera$p(BarcodeAnalyzer $this) {
        return $this.camera;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BarcodeFormat.values().length];
            try {
                nArray[BarcodeFormat.FORMAT_QR_CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_CODE_128.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_CODE_39.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_CODE_93.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_CODABAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_DATA_MATRIX.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_EAN_13.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_EAN_8.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_ITF.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_UPC_A.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_UPC_E.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_PDF417.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_AZTEC.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BarcodeFormat.FORMAT_ALL_FORMATS.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

