/*
 * Decompiled with CFR 0.152.
 */
package org.ncgroup.kscan;

import android.graphics.Rect;
import android.media.Image;
import android.util.Log;
import androidx.annotation.OptIn;
import androidx.camera.core.Camera;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ZoomState;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.ZoomSuggestionOptions;
import com.google.mlkit.vision.common.InputImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ncgroup.kscan.Barcode;
import org.ncgroup.kscan.BarcodeAnalyzerKt;
import org.ncgroup.kscan.BarcodeFormat;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001Bu\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0004\u0012\u00020\f0\n\u0012\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\f0\n\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0017J\u001e\u0010\"\u001a\u00020\f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020$H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/ncgroup/kscan/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "camera", "Landroidx/camera/core/Camera;", "frame", "", "codeTypes", "", "Lorg/ncgroup/kscan/BarcodeFormat;", "onSuccess", "Lkotlin/Function1;", "Lorg/ncgroup/kscan/Barcode;", "", "onFailed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onCanceled", "Lkotlin/Function0;", "onFrameOutside", "<init>", "(Landroidx/camera/core/Camera;FLjava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "options", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "barcodesDetected", "", "", "", "barcodesConfirmed", "", "analyze", "imageProxy", "Landroidx/camera/core/ImageProxy;", "processBarcodes", "barcodes", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "processDetectedBarcode", "displayValue", "barcode", "isRequestedFormat", "", "lib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBarcodeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n774#2:199\n865#2,2:200\n1557#2:202\n1628#2,3:203\n1797#2,3:206\n1863#2,2:209\n1755#2,3:211\n*S KotlinDebug\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n*L\n29#1:199\n29#1:200,2\n30#1:202\n30#1:203,3\n31#1:206,3\n89#1:209,2\n132#1:211,3\n*E\n"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    @Nullable
    private final Camera camera;
    private final float frame;
    @NotNull
    private final List<BarcodeFormat> codeTypes;
    @NotNull
    private final Function1<List<Barcode>, Unit> onSuccess;
    @NotNull
    private final Function1<Exception, Unit> onFailed;
    @NotNull
    private final Function0<Unit> onCanceled;
    @NotNull
    private final Function0<Unit> onFrameOutside;
    @NotNull
    private final BarcodeScannerOptions options;
    @NotNull
    private final BarcodeScanner scanner;
    @NotNull
    private final Map<String, Integer> barcodesDetected;
    @NotNull
    private final Set<Barcode> barcodesConfirmed;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BarcodeAnalyzer(@Nullable Camera camera, float frame, @NotNull List<? extends BarcodeFormat> codeTypes, @NotNull Function1<? super List<Barcode>, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailed, @NotNull Function0<Unit> onCanceled, @NotNull Function0<Unit> onFrameOutside) {
        int n;
        Intrinsics.checkNotNullParameter(codeTypes, (String)"codeTypes");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailed, (String)"onFailed");
        Intrinsics.checkNotNullParameter(onCanceled, (String)"onCanceled");
        Intrinsics.checkNotNullParameter(onFrameOutside, (String)"onFrameOutside");
        this.camera = camera;
        this.frame = frame;
        this.codeTypes = codeTypes;
        this.onSuccess = onSuccess;
        this.onFailed = onFailed;
        this.onCanceled = onCanceled;
        this.onFrameOutside = onFrameOutside;
        BarcodeAnalyzer barcodeAnalyzer = this;
        BarcodeScannerOptions.Builder builder = new BarcodeScannerOptions.Builder();
        if (this.codeTypes.isEmpty() || this.codeTypes.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS)) {
            n = 0;
        } else {
            void $this$fold$iv;
            void initial$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            BarcodeFormat it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = this.codeTypes;
            BarcodeScannerOptions.Builder builder2 = builder;
            BarcodeAnalyzer barcodeAnalyzer2 = barcodeAnalyzer;
            boolean $i$f$filter = false;
            void var10_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BarcodeFormat)((Object)element$iv$iv);
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it.toString(), (String)"FORMAT_", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Integer> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BarcodeFormat)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BarcodeAnalyzerKt.access$toMLKitFormat(it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            $i$f$map = false;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void format;
                int item$iv$iv = ((Number)element$iv).intValue();
                void acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc | format;
            }
            void var19_25 = accumulator$iv;
            barcodeAnalyzer = barcodeAnalyzer2;
            builder = builder2;
            n = var19_25;
        }
        BarcodeScannerOptions barcodeScannerOptions = builder.setBarcodeFormats(n, new int[0]).setZoomSuggestionOptions(new ZoomSuggestionOptions.Builder(new ZoomSuggestionOptions.ZoomCallback(this){
            final /* synthetic */ BarcodeAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean setZoom(float zoomRatio) {
                boolean bl;
                float maxZoomRatio;
                Camera camera = BarcodeAnalyzer.access$getCamera$p(this.this$0);
                float f = camera != null && (camera = camera.getCameraInfo()) != null && (camera = camera.getZoomState()) != null && (camera = (ZoomState)camera.getValue()) != null ? camera.getMaxZoomRatio() : (maxZoomRatio = 1.0f);
                if (zoomRatio <= maxZoomRatio) {
                    Camera camera2 = BarcodeAnalyzer.access$getCamera$p(this.this$0);
                    if (camera2 != null && (camera2 = camera2.getCameraControl()) != null) {
                        camera2.setZoomRatio(zoomRatio);
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }).setMaxSupportedZoomRatio(5.0f).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScannerOptions, (String)"build(...)");
        barcodeAnalyzer.options = barcodeScannerOptions;
        BarcodeScanner barcodeScanner = BarcodeScanning.getClient((BarcodeScannerOptions)this.options);
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner, (String)"getClient(...)");
        this.scanner = barcodeScanner;
        this.barcodesDetected = new LinkedHashMap();
        this.barcodesConfirmed = new LinkedHashSet();
    }

    @OptIn(markerClass={ExperimentalGetImage.class})
    public void analyze(@NotNull ImageProxy imageProxy) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        Image image = imageProxy.getImage();
        if (image == null) {
            BarcodeAnalyzer $this$analyze_u24lambda_u243 = this;
            boolean bl = false;
            imageProxy.close();
            return;
        }
        Image mediaImage = image;
        InputImage inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)imageProxy.getImageInfo().getRotationDegrees());
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(...)");
        InputImage image2 = inputImage;
        this.scanner.process(image2).addOnSuccessListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$5(arg_0 -> BarcodeAnalyzer.analyze$lambda$4(this, imageProxy, arg_0), arg_0)).addOnFailureListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$6(this, imageProxy, arg_0)).addOnCanceledListener(() -> BarcodeAnalyzer.analyze$lambda$7(this, imageProxy)).addOnCompleteListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$8(imageProxy, arg_0));
    }

    private final void processBarcodes(List<? extends com.google.mlkit.vision.barcode.common.Barcode> barcodes, ImageProxy imageProxy) {
        float tolerance = this.frame * 0.1f;
        float frameLeft = ((float)imageProxy.getWidth() - this.frame) / (float)2 - tolerance;
        float frameTop = ((float)imageProxy.getHeight() - this.frame) / (float)2 - tolerance;
        float frameRight = frameLeft + this.frame + tolerance * (float)2;
        float frameBottom = frameTop + this.frame + tolerance * (float)2;
        Iterable $this$forEach$iv = barcodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rect boundingBox;
            com.google.mlkit.vision.barcode.common.Barcode barcode = (com.google.mlkit.vision.barcode.common.Barcode)element$iv;
            boolean bl = false;
            if (!this.isRequestedFormat(barcode)) {
                Log.d((String)"barcode_flow", (String)"Format check failed");
                continue;
            }
            Log.d((String)"barcode_flow", (String)"Format check passed");
            if (barcode.getBoundingBox() == null) {
                BarcodeAnalyzer $this$processBarcodes_u24lambda_u2411_u24lambda_u249 = this;
                boolean bl2 = false;
                Log.d((String)"barcode_flow", (String)"No bounding box found");
                continue;
            }
            if (barcode.getDisplayValue() == null) {
                BarcodeAnalyzer $this$processBarcodes_u24lambda_u2411_u24lambda_u2410 = this;
                boolean bl3 = false;
                Log.d((String)"barcode_flow", (String)"No display value found");
                continue;
            }
            if ((float)boundingBox.left >= frameLeft && (float)boundingBox.top >= frameTop && (float)boundingBox.right <= frameRight && (float)boundingBox.bottom <= frameBottom) {
                String displayValue;
                this.processDetectedBarcode(displayValue, barcode);
                continue;
            }
            this.onFrameOutside.invoke();
        }
        List confirmedBarcodes = CollectionsKt.toList((Iterable)this.barcodesConfirmed);
        if (!((Collection)confirmedBarcodes).isEmpty()) {
            this.onSuccess.invoke((Object)confirmedBarcodes);
            this.barcodesDetected.clear();
            this.barcodesConfirmed.clear();
        }
    }

    private final void processDetectedBarcode(String displayValue, com.google.mlkit.vision.barcode.common.Barcode barcode) {
        Map<String, Integer> map = this.barcodesDetected;
        Integer n = this.barcodesDetected.get(displayValue);
        Object object = (n != null ? n : 0) + 1;
        map.put(displayValue, (Integer)object);
        Integer n2 = this.barcodesDetected.get(displayValue);
        if (n2 == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        if (((Number)n2).intValue() >= 2) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = this.barcodesConfirmed;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Barcode it = (Barcode)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getData(), (Object)displayValue)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                this.barcodesConfirmed.add(new Barcode(displayValue, BarcodeAnalyzerKt.access$toFormat(barcode).toString()));
            }
        }
    }

    private final boolean isRequestedFormat(com.google.mlkit.vision.barcode.common.Barcode barcode) {
        return this.codeTypes.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS) || this.codeTypes.contains((Object)BarcodeAnalyzerKt.access$toFormat(barcode)) || this.codeTypes.contains((Object)BarcodeAnalyzerKt.access$toType(barcode));
    }

    private static final Unit analyze$lambda$4(BarcodeAnalyzer this$0, ImageProxy $imageProxy, List barcodes) {
        Intrinsics.checkNotNull((Object)barcodes);
        this$0.processBarcodes(barcodes, $imageProxy);
        return Unit.INSTANCE;
    }

    private static final void analyze$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void analyze$lambda$6(BarcodeAnalyzer this$0, ImageProxy $imageProxy, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onFailed.invoke((Object)it);
        $imageProxy.close();
    }

    private static final void analyze$lambda$7(BarcodeAnalyzer this$0, ImageProxy $imageProxy) {
        this$0.onCanceled.invoke();
        $imageProxy.close();
    }

    private static final void analyze$lambda$8(ImageProxy $imageProxy, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $imageProxy.close();
    }

    public static final /* synthetic */ Camera access$getCamera$p(BarcodeAnalyzer $this) {
        return $this.camera;
    }
}

