/*
 * Decompiled with CFR 0.152.
 */
package org.ncgroup.kscan;

import android.media.Image;
import android.util.Log;
import androidx.annotation.OptIn;
import androidx.camera.core.Camera;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ZoomState;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.ZoomSuggestionOptions;
import com.google.mlkit.vision.common.InputImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ncgroup.kscan.Barcode;
import org.ncgroup.kscan.BarcodeAnalyzerKt;
import org.ncgroup.kscan.BarcodeFormat;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B_\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0004\u0012\u00020\n0\b\u0012\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\n0\b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0016\u0010\u001f\u001a\u00020\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0005H\u0002J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020!H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/ncgroup/kscan/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "camera", "Landroidx/camera/core/Camera;", "codeTypes", "", "Lorg/ncgroup/kscan/BarcodeFormat;", "onSuccess", "Lkotlin/Function1;", "Lorg/ncgroup/kscan/Barcode;", "", "onFailed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onCanceled", "Lkotlin/Function0;", "<init>", "(Landroidx/camera/core/Camera;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "options", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "barcodesDetected", "", "", "", "barcodesConfirmed", "", "analyze", "imageProxy", "Landroidx/camera/core/ImageProxy;", "processBarcodes", "barcodes", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "processDetectedBarcode", "displayValue", "barcode", "isRequestedFormat", "", "kscan_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBarcodeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n774#2:176\n865#2,2:177\n1557#2:179\n1628#2,3:180\n1797#2,3:183\n1863#2,2:186\n1755#2,3:188\n*S KotlinDebug\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n*L\n27#1:176\n27#1:177,2\n28#1:179\n28#1:180,3\n29#1:183,3\n82#1:186,2\n103#1:188,3\n*E\n"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    @Nullable
    private final Camera camera;
    @NotNull
    private final List<BarcodeFormat> codeTypes;
    @NotNull
    private final Function1<List<Barcode>, Unit> onSuccess;
    @NotNull
    private final Function1<Exception, Unit> onFailed;
    @NotNull
    private final Function0<Unit> onCanceled;
    @NotNull
    private final BarcodeScannerOptions options;
    @NotNull
    private final BarcodeScanner scanner;
    @NotNull
    private final Map<String, Integer> barcodesDetected;
    @NotNull
    private final Set<Barcode> barcodesConfirmed;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BarcodeAnalyzer(@Nullable Camera camera, @NotNull List<? extends BarcodeFormat> codeTypes, @NotNull Function1<? super List<Barcode>, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailed, @NotNull Function0<Unit> onCanceled) {
        int n;
        Intrinsics.checkNotNullParameter(codeTypes, (String)"codeTypes");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailed, (String)"onFailed");
        Intrinsics.checkNotNullParameter(onCanceled, (String)"onCanceled");
        this.camera = camera;
        this.codeTypes = codeTypes;
        this.onSuccess = onSuccess;
        this.onFailed = onFailed;
        this.onCanceled = onCanceled;
        BarcodeAnalyzer barcodeAnalyzer = this;
        BarcodeScannerOptions.Builder builder = new BarcodeScannerOptions.Builder();
        if (this.codeTypes.isEmpty() || this.codeTypes.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS)) {
            n = 0;
        } else {
            void $this$fold$iv;
            void initial$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            BarcodeFormat it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = this.codeTypes;
            BarcodeScannerOptions.Builder builder2 = builder;
            BarcodeAnalyzer barcodeAnalyzer2 = barcodeAnalyzer;
            boolean $i$f$filter = false;
            void var8_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BarcodeFormat)((Object)element$iv$iv);
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it.toString(), (String)"FORMAT_", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Integer> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BarcodeFormat)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BarcodeAnalyzerKt.access$toMLKitFormat(it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            $i$f$map = false;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void format;
                int item$iv$iv = ((Number)element$iv).intValue();
                void acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc | format;
            }
            void var17_23 = accumulator$iv;
            barcodeAnalyzer = barcodeAnalyzer2;
            builder = builder2;
            n = var17_23;
        }
        BarcodeScannerOptions barcodeScannerOptions = builder.setBarcodeFormats(n, new int[0]).setZoomSuggestionOptions(new ZoomSuggestionOptions.Builder(new ZoomSuggestionOptions.ZoomCallback(this){
            final /* synthetic */ BarcodeAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean setZoom(float zoomRatio) {
                boolean bl;
                Camera camera = BarcodeAnalyzer.access$getCamera$p(this.this$0);
                float maxZoomRatio = RangesKt.coerceAtMost((float)(camera != null && (camera = camera.getCameraInfo()) != null && (camera = camera.getZoomState()) != null && (camera = (ZoomState)camera.getValue()) != null ? camera.getMaxZoomRatio() : 1.0f), (float)5.0f);
                if (zoomRatio <= maxZoomRatio) {
                    Camera camera2 = BarcodeAnalyzer.access$getCamera$p(this.this$0);
                    if (camera2 != null && (camera2 = camera2.getCameraControl()) != null) {
                        camera2.setZoomRatio(zoomRatio);
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }).setMaxSupportedZoomRatio(5.0f).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScannerOptions, (String)"build(...)");
        barcodeAnalyzer.options = barcodeScannerOptions;
        BarcodeScanner barcodeScanner = BarcodeScanning.getClient((BarcodeScannerOptions)this.options);
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner, (String)"getClient(...)");
        this.scanner = barcodeScanner;
        this.barcodesDetected = new LinkedHashMap();
        this.barcodesConfirmed = new LinkedHashSet();
    }

    @OptIn(markerClass={ExperimentalGetImage.class})
    public void analyze(@NotNull ImageProxy imageProxy) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        Image image = imageProxy.getImage();
        if (image == null) {
            BarcodeAnalyzer $this$analyze_u24lambda_u243 = this;
            boolean bl = false;
            imageProxy.close();
            return;
        }
        Image mediaImage = image;
        InputImage inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)imageProxy.getImageInfo().getRotationDegrees());
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(...)");
        InputImage image2 = inputImage;
        this.scanner.process(image2).addOnSuccessListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$5(arg_0 -> BarcodeAnalyzer.analyze$lambda$4(this, arg_0), arg_0)).addOnFailureListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$6(this, imageProxy, arg_0)).addOnCanceledListener(() -> BarcodeAnalyzer.analyze$lambda$7(this, imageProxy)).addOnCompleteListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$8(imageProxy, arg_0));
    }

    private final void processBarcodes(List<? extends com.google.mlkit.vision.barcode.common.Barcode> barcodes) {
        Iterable $this$forEach$iv = barcodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.google.mlkit.vision.barcode.common.Barcode barcode = (com.google.mlkit.vision.barcode.common.Barcode)element$iv;
            boolean bl = false;
            if (!this.isRequestedFormat(barcode)) {
                Log.d((String)"barcode_flow", (String)"Format check failed");
                continue;
            }
            String string = barcode.getDisplayValue();
            if (string == null) {
                string = "";
            }
            this.processDetectedBarcode(string, barcode);
        }
        List confirmedBarcodes = CollectionsKt.toList((Iterable)this.barcodesConfirmed);
        if (!((Collection)confirmedBarcodes).isEmpty()) {
            this.onSuccess.invoke((Object)confirmedBarcodes);
            this.barcodesDetected.clear();
            this.barcodesConfirmed.clear();
        }
    }

    private final void processDetectedBarcode(String displayValue, com.google.mlkit.vision.barcode.common.Barcode barcode) {
        Map<String, Integer> map = this.barcodesDetected;
        Integer n = this.barcodesDetected.get(displayValue);
        Object object = (n != null ? n : 0) + 1;
        map.put(displayValue, (Integer)object);
        Integer n2 = this.barcodesDetected.get(displayValue);
        if (n2 == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        if (((Number)n2).intValue() >= 2) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = this.barcodesConfirmed;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Barcode it = (Barcode)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getData(), (Object)displayValue)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                this.barcodesConfirmed.add(new Barcode(displayValue, BarcodeAnalyzerKt.access$toFormat(barcode).toString()));
            }
        }
    }

    private final boolean isRequestedFormat(com.google.mlkit.vision.barcode.common.Barcode barcode) {
        return this.codeTypes.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS) || this.codeTypes.contains((Object)BarcodeAnalyzerKt.access$toFormat(barcode)) || this.codeTypes.contains((Object)BarcodeAnalyzerKt.access$toType(barcode));
    }

    private static final Unit analyze$lambda$4(BarcodeAnalyzer this$0, List barcodes) {
        Intrinsics.checkNotNull((Object)barcodes);
        this$0.processBarcodes(barcodes);
        return Unit.INSTANCE;
    }

    private static final void analyze$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void analyze$lambda$6(BarcodeAnalyzer this$0, ImageProxy $imageProxy, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onFailed.invoke((Object)it);
        $imageProxy.close();
    }

    private static final void analyze$lambda$7(BarcodeAnalyzer this$0, ImageProxy $imageProxy) {
        this$0.onCanceled.invoke();
        $imageProxy.close();
    }

    private static final void analyze$lambda$8(ImageProxy $imageProxy, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $imageProxy.close();
    }

    public static final /* synthetic */ Camera access$getCamera$p(BarcodeAnalyzer $this) {
        return $this.camera;
    }
}

