/*
 * Decompiled with CFR 0.152.
 */
package org.ncgroup.kscan;

import android.media.Image;
import androidx.annotation.OptIn;
import androidx.camera.core.Camera;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ZoomState;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.ZoomSuggestionOptions;
import com.google.mlkit.vision.common.InputImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ncgroup.kscan.Barcode;
import org.ncgroup.kscan.BarcodeFormat;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B_\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0004\u0012\u00020\n0\b\u0012\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\n0\b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0016\u0010\u001f\u001a\u00020\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020!H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/ncgroup/kscan/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "camera", "Landroidx/camera/core/Camera;", "codeTypes", "", "Lorg/ncgroup/kscan/BarcodeFormat;", "onSuccess", "Lkotlin/Function1;", "Lorg/ncgroup/kscan/Barcode;", "", "onFailed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onCanceled", "Lkotlin/Function0;", "<init>", "(Landroidx/camera/core/Camera;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "scannerOptions", "Lcom/google/mlkit/vision/barcode/BarcodeScannerOptions;", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "barcodesDetected", "", "", "", "hasSuccessfullyProcessedBarcode", "", "analyze", "imageProxy", "Landroidx/camera/core/ImageProxy;", "processFoundBarcodes", "mlKitBarcodes", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "isRequestedFormat", "mlKitBarcode", "Companion", "kscan_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBarcodeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n774#2:161\n865#2,2:162\n1222#2,2:164\n1252#2,4:166\n*S KotlinDebug\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer\n*L\n73#1:161\n73#1:162,2\n140#1:164,2\n140#1:166,4\n*E\n"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final Camera camera;
    @NotNull
    private final List<BarcodeFormat> codeTypes;
    @NotNull
    private final Function1<List<Barcode>, Unit> onSuccess;
    @NotNull
    private final Function1<Exception, Unit> onFailed;
    @NotNull
    private final Function0<Unit> onCanceled;
    @NotNull
    private final BarcodeScannerOptions scannerOptions;
    @NotNull
    private final BarcodeScanner scanner;
    @NotNull
    private final Map<String, Integer> barcodesDetected;
    private boolean hasSuccessfullyProcessedBarcode;
    public static final int $stable;
    @NotNull
    private static final Map<BarcodeFormat, Integer> APP_TO_MLKIT_FORMAT_MAP;
    @NotNull
    private static final Map<Integer, BarcodeFormat> MLKIT_TO_APP_FORMAT_MAP;

    public BarcodeAnalyzer(@Nullable Camera camera, @NotNull List<? extends BarcodeFormat> codeTypes, @NotNull Function1<? super List<Barcode>, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailed, @NotNull Function0<Unit> onCanceled) {
        Intrinsics.checkNotNullParameter(codeTypes, (String)"codeTypes");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailed, (String)"onFailed");
        Intrinsics.checkNotNullParameter(onCanceled, (String)"onCanceled");
        this.camera = camera;
        this.codeTypes = codeTypes;
        this.onSuccess = onSuccess;
        this.onFailed = onFailed;
        this.onCanceled = onCanceled;
        BarcodeScannerOptions barcodeScannerOptions = new BarcodeScannerOptions.Builder().setBarcodeFormats(Companion.getMLKitBarcodeFormats(this.codeTypes), new int[0]).setZoomSuggestionOptions(new ZoomSuggestionOptions.Builder(arg_0 -> BarcodeAnalyzer.scannerOptions$lambda$0(this, arg_0)).setMaxSupportedZoomRatio(5.0f).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScannerOptions, (String)"build(...)");
        this.scannerOptions = barcodeScannerOptions;
        BarcodeScanner barcodeScanner = BarcodeScanning.getClient((BarcodeScannerOptions)this.scannerOptions);
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner, (String)"getClient(...)");
        this.scanner = barcodeScanner;
        this.barcodesDetected = new LinkedHashMap();
    }

    @OptIn(markerClass={ExperimentalGetImage.class})
    public void analyze(@NotNull ImageProxy imageProxy) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        if (this.hasSuccessfullyProcessedBarcode) {
            imageProxy.close();
            return;
        }
        Image image = imageProxy.getImage();
        if (image == null) {
            BarcodeAnalyzer $this$analyze_u24lambda_u241 = this;
            boolean bl = false;
            imageProxy.close();
            return;
        }
        Image mediaImage = image;
        InputImage inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)imageProxy.getImageInfo().getRotationDegrees());
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(...)");
        InputImage image2 = inputImage;
        this.scanner.process(image2).addOnSuccessListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$4(arg_0 -> BarcodeAnalyzer.analyze$lambda$3(this, arg_0), arg_0)).addOnFailureListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$5(this, imageProxy, arg_0)).addOnCanceledListener(() -> BarcodeAnalyzer.analyze$lambda$6(this, imageProxy)).addOnCompleteListener(arg_0 -> BarcodeAnalyzer.analyze$lambda$7(imageProxy, arg_0));
    }

    private final void processFoundBarcodes(List<? extends com.google.mlkit.vision.barcode.common.Barcode> mlKitBarcodes) {
        if (this.hasSuccessfullyProcessedBarcode) {
            return;
        }
        for (com.google.mlkit.vision.barcode.common.Barcode barcode : mlKitBarcodes) {
            String displayValue;
            if (barcode.getDisplayValue() == null) continue;
            Map<String, Integer> map = this.barcodesDetected;
            Integer n = this.barcodesDetected.get(displayValue);
            Integer n2 = (n != null ? n : 0) + 1;
            map.put(displayValue, n2);
            Integer n3 = this.barcodesDetected.get(displayValue);
            if ((n3 != null ? n3 : 0) < 2) continue;
            BarcodeFormat appSpecificFormat = Companion.mlKitFormatToAppFormat(barcode.getFormat());
            Barcode detectedAppBarcode = new Barcode(displayValue, appSpecificFormat.toString());
            this.onSuccess.invoke((Object)CollectionsKt.listOf((Object)detectedAppBarcode));
            this.barcodesDetected.clear();
            this.hasSuccessfullyProcessedBarcode = true;
            break;
        }
    }

    private final boolean isRequestedFormat(com.google.mlkit.vision.barcode.common.Barcode mlKitBarcode) {
        if (this.codeTypes.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS)) {
            return MLKIT_TO_APP_FORMAT_MAP.containsKey(mlKitBarcode.getFormat());
        }
        BarcodeFormat appFormat = Companion.mlKitFormatToAppFormat(mlKitBarcode.getFormat());
        return this.codeTypes.contains((Object)appFormat);
    }

    private static final boolean scannerOptions$lambda$0(BarcodeAnalyzer this$0, float zoomRatio) {
        boolean bl;
        Camera camera = this$0.camera;
        float maxZoomRatio = RangesKt.coerceAtMost((float)(camera != null && (camera = camera.getCameraInfo()) != null && (camera = camera.getZoomState()) != null && (camera = (ZoomState)camera.getValue()) != null ? camera.getMaxZoomRatio() : 1.0f), (float)5.0f);
        if (zoomRatio <= maxZoomRatio) {
            Camera camera2 = this$0.camera;
            if (camera2 != null && (camera2 = camera2.getCameraControl()) != null) {
                camera2.setZoomRatio(zoomRatio);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit analyze$lambda$3(BarcodeAnalyzer this$0, List barcodes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNull((Object)barcodes);
        Iterable $this$filter$iv = barcodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            com.google.mlkit.vision.barcode.common.Barcode it = (com.google.mlkit.vision.barcode.common.Barcode)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this$0.isRequestedFormat(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantBarcodes = (List)destination$iv$iv;
        if (!((Collection)relevantBarcodes).isEmpty()) {
            this$0.processFoundBarcodes(relevantBarcodes);
        }
        return Unit.INSTANCE;
    }

    private static final void analyze$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void analyze$lambda$5(BarcodeAnalyzer this$0, ImageProxy $imageProxy, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onFailed.invoke((Object)it);
        $imageProxy.close();
    }

    private static final void analyze$lambda$6(BarcodeAnalyzer this$0, ImageProxy $imageProxy) {
        this$0.onCanceled.invoke();
        $imageProxy.close();
    }

    private static final void analyze$lambda$7(ImageProxy $imageProxy, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $imageProxy.close();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        $stable = 8;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_QR_CODE), (Object)256), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_CODE_128), (Object)1), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_CODE_39), (Object)2), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_CODE_93), (Object)4), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_CODABAR), (Object)8), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_DATA_MATRIX), (Object)16), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_EAN_13), (Object)32), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_EAN_8), (Object)64), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_ITF), (Object)128), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_UPC_A), (Object)512), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_UPC_E), (Object)1024), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_PDF417), (Object)2048), TuplesKt.to((Object)((Object)BarcodeFormat.FORMAT_AZTEC), (Object)4096)};
        APP_TO_MLKIT_FORMAT_MAP = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$associateBy$iv = APP_TO_MLKIT_FORMAT_MAP.entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            Integer n = ((Number)it.getValue()).intValue();
            boolean bl2 = false;
            BarcodeFormat barcodeFormat = (BarcodeFormat)((Object)it.getKey());
            map.put(n, barcodeFormat);
        }
        MLKIT_TO_APP_FORMAT_MAP = MapsKt.plus((Map)destination$iv$iv, (Pair)TuplesKt.to((Object)-1, (Object)((Object)BarcodeFormat.TYPE_UNKNOWN)));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/ncgroup/kscan/BarcodeAnalyzer$Companion;", "", "<init>", "()V", "APP_TO_MLKIT_FORMAT_MAP", "", "Lorg/ncgroup/kscan/BarcodeFormat;", "", "MLKIT_TO_APP_FORMAT_MAP", "getMLKitBarcodeFormats", "appFormats", "", "mlKitFormatToAppFormat", "mlKitFormat", "kscan_release"})
    @SourceDebugExtension(value={"SMAP\nBarcodeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1617#2,9:161\n1869#2:170\n1870#2:172\n1626#2:173\n1803#2,3:174\n1#3:171\n1#3:177\n*S KotlinDebug\n*F\n+ 1 BarcodeAnalyzer.kt\norg/ncgroup/kscan/BarcodeAnalyzer$Companion\n*L\n149#1:161,9\n149#1:170\n149#1:172\n149#1:173\n151#1:174,3\n149#1:171\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final int getMLKitBarcodeFormats(@NotNull List<? extends BarcodeFormat> appFormats) {
            void var3_3;
            void $this$fold$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(appFormats, (String)"appFormats");
            if (appFormats.isEmpty() || appFormats.contains((Object)BarcodeFormat.FORMAT_ALL_FORMATS)) {
                return 0;
            }
            Iterable $this$mapNotNull$iv = appFormats;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            int $i$f$forEach = 0;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                BarcodeFormat it = (BarcodeFormat)((Object)element$iv$iv);
                boolean bl2 = false;
                if ((Integer)APP_TO_MLKIT_FORMAT_MAP.get((Object)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void formatInt;
                $i$f$forEach = ((Number)element$iv).intValue();
                int acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc | formatInt;
            }
            int it = accumulator$iv;
            boolean bl = false;
            return it == 0 ? 0 : var3_3;
        }

        @NotNull
        public final BarcodeFormat mlKitFormatToAppFormat(int mlKitFormat) {
            BarcodeFormat barcodeFormat = (BarcodeFormat)((Object)MLKIT_TO_APP_FORMAT_MAP.get(mlKitFormat));
            if (barcodeFormat == null) {
                barcodeFormat = BarcodeFormat.TYPE_UNKNOWN;
            }
            return barcodeFormat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

