/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu;

import io.jmix.core.MetadataTools;
import io.jmix.core.UuidProvider;
import io.jmix.ui.ScreenBuilders;
import io.jmix.ui.action.Action;
import io.jmix.ui.component.Table;
import io.jmix.ui.navigation.Route;
import io.jmix.ui.screen.LookupComponent;
import io.jmix.ui.screen.StandardLookup;
import io.jmix.ui.screen.Subscribe;
import io.jmix.ui.screen.UiController;
import io.jmix.ui.screen.UiDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import ru.itsyn.jmix.menu_editor.entity.MenuEntity;
import ru.itsyn.jmix.menu_editor.screen.menu.AppMenuManager;

@Route(value="MenuEntity")
@UiController(value="menu_MenuEntity.browse")
@UiDescriptor(value="menu-entity-browser.xml")
@LookupComponent(value="table")
public class MenuEntityBrowser
extends StandardLookup<MenuEntity> {
    @Autowired
    MetadataTools metadataTools;
    @Autowired
    ScreenBuilders screenBuilders;
    @Autowired
    AppMenuManager appMenuManager;
    @Autowired
    Table<MenuEntity> table;

    @Subscribe(value="table.copy")
    public void onMenuCopy(Action.ActionPerformedEvent event) {
        MenuEntity entity = (MenuEntity)this.table.getSingleSelected();
        if (entity == null) {
            return;
        }
        MenuEntity ce = (MenuEntity)this.metadataTools.copy((Object)entity);
        ce.setId(UuidProvider.createUuid());
        ce.setName(entity.getName() + " - Copy");
        this.screenBuilders.editor(this.table).newEntity((Object)ce).show();
    }

    @Subscribe(value="table.apply")
    public void onMenuApply(Action.ActionPerformedEvent event) {
        this.appMenuManager.reloadAppMenu();
    }
}

