/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu;

import com.vaadin.shared.ui.dnd.EffectAllowed;
import com.vaadin.shared.ui.grid.DropLocation;
import com.vaadin.shared.ui.grid.DropMode;
import com.vaadin.ui.TreeGrid;
import com.vaadin.ui.components.grid.TreeGridDragSource;
import com.vaadin.ui.components.grid.TreeGridDropEvent;
import com.vaadin.ui.components.grid.TreeGridDropTarget;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.common.util.Dom4j;
import io.jmix.security.model.BaseRole;
import io.jmix.security.role.ResourceRoleRepository;
import io.jmix.ui.Notifications;
import io.jmix.ui.RemoveOperation;
import io.jmix.ui.ScreenBuilders;
import io.jmix.ui.action.Action;
import io.jmix.ui.action.list.RemoveAction;
import io.jmix.ui.component.ComboBox;
import io.jmix.ui.component.DataGrid;
import io.jmix.ui.component.TabSheet;
import io.jmix.ui.component.TreeDataGrid;
import io.jmix.ui.model.CollectionContainer;
import io.jmix.ui.model.CollectionLoader;
import io.jmix.ui.model.DataContext;
import io.jmix.ui.model.InstanceContainer;
import io.jmix.ui.navigation.Route;
import io.jmix.ui.screen.EditedEntityContainer;
import io.jmix.ui.screen.Install;
import io.jmix.ui.screen.OpenMode;
import io.jmix.ui.screen.Screen;
import io.jmix.ui.screen.StandardEditor;
import io.jmix.ui.screen.Subscribe;
import io.jmix.ui.screen.Target;
import io.jmix.ui.screen.UiController;
import io.jmix.ui.screen.UiDescriptor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;
import ru.itsyn.jmix.menu_editor.entity.MenuEntity;
import ru.itsyn.jmix.menu_editor.entity.MenuItemEntity;
import ru.itsyn.jmix.menu_editor.screen.menu_item.MenuConfigBuilder;
import ru.itsyn.jmix.menu_editor.screen.menu_item.MenuItemFilterHelper;
import ru.itsyn.jmix.menu_editor.screen.menu_item.MenuItemLoader;
import ru.itsyn.jmix.menu_editor.util.DialogHelper;
import ru.itsyn.jmix.menu_editor.util.MenuItemHelper;

@Route(path="MenuEntity/edit", parentPrefix="MenuEntity")
@UiController(value="menu_MenuEntity.edit")
@UiDescriptor(value="menu-entity-editor.xml")
@EditedEntityContainer(value="editDc")
public class MenuEntityEditor
extends StandardEditor<MenuEntity> {
    static final String ITEMS_TAB = "itemsTab";
    static final String CONFIG_TAB = "configTab";
    @Autowired
    Messages messages;
    @Autowired
    Notifications notifications;
    @Autowired
    ResourceRoleRepository roleRepository;
    @Autowired
    ScreenBuilders screenBuilders;
    @Autowired
    RemoveOperation removeOperation;
    @Autowired
    DialogHelper dialogHelper;
    @Autowired
    MenuItemLoader menuItemLoader;
    @Autowired
    MenuItemHelper menuItemHelper;
    @Autowired
    MenuItemFilterHelper menuItemFilterHelper;
    @Autowired
    MenuConfigBuilder menuConfigBuilder;
    @Autowired
    DataContext dataContext;
    @Autowired
    TabSheet tabSheet;
    @Autowired
    ComboBox<String> roleField;
    @Autowired
    CollectionContainer<MenuItemEntity> itemsDc;
    @Autowired
    CollectionLoader<MenuItemEntity> itemsDl;
    @Autowired
    TreeDataGrid<MenuItemEntity> itemsTable;
    @Named(value="itemsTable.remove")
    RemoveAction<MenuItemEntity> itemRemoveAction;

    @Subscribe
    public void onInit(Screen.InitEvent event) {
        this.initTabSheet();
        this.initRoleField();
        this.initItemDragAndDrop();
        this.initRemoveItemAction();
    }

    protected void initTabSheet() {
        this.tabSheet.addSelectedTabChangeListener(event -> {
            if (!event.isUserOriginated()) {
                return;
            }
            String tabName = event.getSelectedTab().getName();
            if (ITEMS_TAB.equals(tabName)) {
                this.itemsDl.load();
            } else if (CONFIG_TAB.equals(tabName)) {
                this.updateMenuConfig(this.getRootItem());
            }
        });
    }

    protected void initRoleField() {
        Map<String, String> roleNames = this.roleRepository.getAllRoles().stream().collect(Collectors.toMap(BaseRole::getName, BaseRole::getCode));
        this.roleField.setOptionsMap(roleNames);
    }

    protected void initItemDragAndDrop() {
        TreeGrid grid = (TreeGrid)this.itemsTable.unwrap(TreeGrid.class);
        TreeGridDragSource dragSource = new TreeGridDragSource(grid);
        dragSource.setEffectAllowed(EffectAllowed.MOVE);
        dragSource.setDragDataGenerator("text/plain", MenuItemEntity::getId);
        TreeGridDropTarget dropTarget = new TreeGridDropTarget(grid, DropMode.ON_TOP_OR_BETWEEN);
        dropTarget.addTreeGridDropListener(this::onDropItem);
    }

    protected void onDropItem(TreeGridDropEvent<MenuItemEntity> event) {
        MenuItemEntity item = event.getDataTransferData("text/plain").map(arg_0 -> this.itemsDc.getItemOrNull(arg_0)).orElse(null);
        if (item == null || ((Object)this.getRootItem()).equals(item)) {
            return;
        }
        MenuItemEntity targetItem = event.getDropTargetRow().orElse(null);
        if (targetItem == null || targetItem.getParent() == null) {
            return;
        }
        DropLocation dropLoc = event.getDropLocation();
        if (dropLoc == DropLocation.ON_TOP && targetItem.isMenu()) {
            this.moveItem(item, targetItem, 0);
        } else {
            MenuItemEntity parent = targetItem.getParent();
            int index = parent.getChildIndex(targetItem);
            if (dropLoc != DropLocation.ABOVE) {
                ++index;
            }
            this.moveItem(item, parent, index);
        }
    }

    protected void moveItem(MenuItemEntity item, MenuItemEntity parent, int index) {
        if (((Object)parent).equals(item) || parent.hasAncestor(item)) {
            String warning = this.messages.getMessage(((Object)((Object)this)).getClass(), "cyclicDependencyWarning");
            this.notifications.create().withCaption(warning).show();
            return;
        }
        MenuItemEntity pi = item.getParent();
        if (pi == parent && pi.getChildIndex(item) < index) {
            --index;
        }
        pi.removeChild(item);
        parent.addChild(item, index);
        this.refreshItems();
    }

    protected void refreshItems() {
        MenuItemEntity rootItem = this.getRootItem();
        this.itemsDc.setItems(this.menuItemHelper.buildItemList(rootItem));
    }

    protected void initRemoveItemAction() {
        this.itemRemoveAction.addEnabledRule(() -> {
            Set items = this.itemsTable.getSelected();
            return !items.contains(this.getRootItem());
        });
    }

    @Install(to="itemsDl", target=Target.DATA_LOADER)
    protected List<MenuItemEntity> loadMenuItems(LoadContext<MenuItemEntity> loadContext) {
        MenuItemEntity rootItem = this.menuItemLoader.loadMenu((MenuEntity)this.getEditedEntity());
        List<MenuItemEntity> items = this.menuItemHelper.buildItemList(rootItem);
        return this.menuItemFilterHelper.filterItems(items, loadContext);
    }

    @Subscribe(id="itemsDc", target=Target.DATA_CONTAINER)
    public void onItemsDcItemChange(InstanceContainer.ItemChangeEvent<MenuItemEntity> event) {
        if (event.getPrevItem() == null) {
            this.refreshItems();
        }
    }

    @Install(to="itemsTable.caption", subject="columnGenerator")
    protected String newItemCaptionCell(DataGrid.ColumnGeneratorEvent<MenuItemEntity> event) {
        return this.menuItemHelper.getItemCaption((MenuItemEntity)event.getItem());
    }

    @Subscribe(value="itemsTable.create")
    void onItemCreate(Action.ActionPerformedEvent event) {
        MenuItemEntity si = (MenuItemEntity)this.itemsTable.getSingleSelected();
        if (si == null) {
            si = this.getRootItem();
        }
        MenuItemEntity parent = si.isMenu() ? si : si.getParent();
        int index = parent != si ? parent.getChildIndex(si) + 1 : 0;
        this.screenBuilders.editor(this.itemsTable).newEntity().withOpenMode(OpenMode.DIALOG).withParentDataContext(this.dataContext).withInitializer(i -> i.setParent(parent)).withTransformation(i -> {
            parent.addChild((MenuItemEntity)i, index);
            return i;
        }).show();
    }

    @Subscribe(value="itemsTable.edit")
    void onItemEdit(Action.ActionPerformedEvent event) {
        this.screenBuilders.editor(this.itemsTable).withOpenMode(OpenMode.DIALOG).withParentDataContext(this.dataContext).show();
    }

    @Subscribe(value="itemsTable.remove")
    void onItemRemove(Action.ActionPerformedEvent event) {
        this.removeOperation.builder(this.itemsTable).afterActionPerformed(this::afterItemRemove).remove();
    }

    void afterItemRemove(RemoveOperation.AfterActionPerformedEvent<MenuItemEntity> event) {
        List items = this.itemsDc.getMutableItems();
        for (MenuItemEntity item : event.getItems()) {
            item.getParent().removeChild(item);
            item.visitItems(items::remove);
        }
    }

    @Subscribe(value="itemsTable.resetMenu")
    public void onResetMenu(Action.ActionPerformedEvent event) {
        this.dialogHelper.newConfirmationDialog(this.messages.getMessage(((Object)((Object)this)).getClass(), "resetConfirmation"), this::resetMenu).show();
    }

    protected void resetMenu(Action.ActionPerformedEvent event) {
        MenuItemEntity rootItem = this.menuItemLoader.loadDefaultMenu();
        this.updateMenuConfig(rootItem);
        this.itemsDl.load();
    }

    @Subscribe
    public void onBeforeCommitChanges(StandardEditor.BeforeCommitChangesEvent event) {
        MenuItemEntity rootItem = this.getRootItem();
        if (rootItem == null) {
            return;
        }
        if (ITEMS_TAB.equals(this.tabSheet.getSelectedTab().getName())) {
            this.updateMenuConfig(rootItem);
        }
        new HashSet(this.dataContext.getModified()).forEach(e -> {
            if (e instanceof MenuItemEntity) {
                this.dataContext.evict(e);
            }
        });
    }

    protected void updateMenuConfig(MenuItemEntity rootItem) {
        Document doc = this.menuConfigBuilder.buildMenuConfig(rootItem.getChildren());
        String config = Dom4j.writeDocument((Document)doc, (boolean)true);
        ((MenuEntity)this.getEditedEntity()).setConfig(config);
    }

    protected MenuItemEntity getRootItem() {
        return (MenuItemEntity)this.itemsDc.getItem((Object)"rootItem");
    }
}

