/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu_config;

import com.vaadin.spring.annotation.UIScope;
import io.jmix.core.DataManager;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.ui.menu.MenuConfig;
import javax.annotation.Nullable;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import ru.itsyn.jmix.menu_editor.entity.MenuEntity;
import ru.itsyn.jmix.menu_editor.screen.menu_config.MenuConfigLoader;

@UIScope
@Component(value="menu_UserMenuConfig")
public class UserMenuConfig
extends MenuConfig {
    @Autowired
    DataManager dataManager;
    @Autowired
    CurrentAuthentication currentAuthentication;
    @Autowired
    MenuConfigLoader configLoader;

    protected void init() {
        MenuEntity userMenu = this.loadMenuEntity();
        if (userMenu != null) {
            this.rootItems.clear();
            Document d = this.dom4JTools.readDocument(userMenu.getConfig());
            this.loadMenuItems(d.getRootElement(), null);
            return;
        }
        this.rootItems = this.configLoader.loadDefaultConfig();
    }

    @Nullable
    protected MenuEntity loadMenuEntity() {
        UserDetails user = this.currentAuthentication.getUser();
        String query = "select e from menu_MenuEntity e where e.roleCode in (select ra.roleCode   from sec_RoleAssignmentEntity ra   where ra.username = :username ) order by e.priority desc";
        return this.dataManager.load(MenuEntity.class).query(query).parameter("username", (Object)user.getUsername()).maxResults(1).optional().orElse(null);
    }
}

