/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu_item;

import io.jmix.core.metamodel.datatype.impl.EnumClass;
import java.util.Date;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import ru.itsyn.jmix.menu_editor.entity.MenuItemEntity;
import ru.itsyn.jmix.menu_editor.entity.MenuItemType;

@Component(value="menu_MenuConfigBuilder")
@Scope(value="prototype")
@NotThreadSafe
public class MenuConfigBuilder {
    public static final String MENU_NAMESPACE = "http://jmix.io/schema/ui/menu";

    public Document buildMenuConfig(List<MenuItemEntity> items) {
        Document doc = DocumentHelper.createDocument();
        Element rootElement = doc.addElement("menu-config", MENU_NAMESPACE);
        items.forEach(i -> this.addMenuItem(rootElement, (MenuItemEntity)i));
        return doc;
    }

    protected void addMenuItem(Element parent, MenuItemEntity item) {
        MenuItemType itemType = item.getItemType();
        Element e = parent.addElement(this.getElementName(itemType));
        if (itemType == MenuItemType.SEPARATOR) {
            return;
        }
        this.addAttributeValue(e, "id", item.getId());
        this.addAttributeValue(e, "caption", item.getCaptionKey());
        this.addAttributeValue(e, "description", item.getDescription());
        this.addAttributeValue(e, "stylename", item.getStyleName());
        this.addAttributeValue(e, "icon", item.getIcon());
        if (itemType == MenuItemType.MENU) {
            if (BooleanUtils.isTrue((Boolean)item.getExpanded())) {
                this.addAttributeValue(e, "expanded", item.getExpanded());
            }
            item.getChildren().forEach(i -> this.addMenuItem(e, (MenuItemEntity)i));
        } else if (itemType == MenuItemType.SCREEN) {
            if (!item.getId().equals(item.getScreen())) {
                this.addAttributeValue(e, "screen", item.getScreen());
            }
            this.addAttributeValue(e, "class", item.getRunnableClass());
            this.addAttributeValue(e, "bean", item.getBean());
            this.addAttributeValue(e, "beanMethod", item.getBeanMethod());
            this.addAttributeValue(e, "openMode", (Object)item.getOpenMode());
            this.addAttributeValue(e, "shortcut", item.getShortcut());
            this.addContentXml(e, item.getContentXml());
        }
        this.addAttributeValue(e, "createdDate", item.getCreatedDate());
        this.addAttributeValue(e, "createdBy", item.getCreatedBy());
        this.addAttributeValue(e, "lastModifiedDate", item.getLastModifiedDate());
        this.addAttributeValue(e, "lastModifiedBy", item.getLastModifiedBy());
        this.addAttributeValue(e, "comment", item.getComment());
    }

    protected String getElementName(MenuItemType itemType) {
        if (itemType == MenuItemType.MENU) {
            return "menu";
        }
        if (itemType == MenuItemType.SEPARATOR) {
            return "separator";
        }
        return "item";
    }

    protected void addAttributeValue(Element e, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof EnumClass) {
            value = ((EnumClass)value).getId();
        } else if (value instanceof Date) {
            value = ((Date)value).toInstant();
        }
        e.addAttribute(name, value.toString());
    }

    protected void addContentXml(Element e, String xml) {
        try {
            if (StringUtils.isBlank((CharSequence)xml)) {
                return;
            }
            String docXml = String.format("<root xmlns=\"%s\">%s</root>", MENU_NAMESPACE, xml);
            Document doc = DocumentHelper.parseText((String)docXml);
            for (Node n : doc.getRootElement().content()) {
                n.setParent(null);
                e.add(n);
            }
        }
        catch (DocumentException ex) {
            throw new RuntimeException("Cannot parse contentXml", ex);
        }
    }
}

