/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu_item;

import io.jmix.core.TimeSource;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.ui.component.CheckBox;
import io.jmix.ui.component.ComboBox;
import io.jmix.ui.component.TextField;
import io.jmix.ui.screen.EditedEntityContainer;
import io.jmix.ui.screen.Screen;
import io.jmix.ui.screen.StandardEditor;
import io.jmix.ui.screen.Subscribe;
import io.jmix.ui.screen.UiController;
import io.jmix.ui.screen.UiDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import ru.itsyn.jmix.menu_editor.entity.MenuItemEntity;
import ru.itsyn.jmix.menu_editor.entity.MenuItemType;
import ru.itsyn.jmix.menu_editor.util.MenuItemHelper;

@UiController(value="menu_MenuItemEntity.edit")
@UiDescriptor(value="menu-item-editor.xml")
@EditedEntityContainer(value="editDc")
public class MenuItemEditor
extends StandardEditor<MenuItemEntity> {
    @Autowired
    TimeSource timeSource;
    @Autowired
    CurrentAuthentication currentAuthentication;
    @Autowired
    MenuItemHelper menuItemHelper;
    @Autowired
    TextField<String> idField;
    @Autowired
    TextField<String> captionKeyField;
    @Autowired
    ComboBox<MenuItemType> itemTypeField;
    @Autowired
    CheckBox expandedField;

    @Subscribe
    public void onInit(Screen.InitEvent event) {
        this.initValueChangeListeners();
    }

    protected void initValueChangeListeners() {
        this.idField.addValueChangeListener(e -> this.updateCaption());
        this.captionKeyField.addValueChangeListener(e -> this.updateCaption());
        this.itemTypeField.addValueChangeListener(e -> this.expandedField.setEditable(e.getValue() == MenuItemType.MENU));
    }

    @Subscribe
    public void onInitEntity(StandardEditor.InitEntityEvent<MenuItemEntity> event) {
        MenuItemEntity entity = (MenuItemEntity)event.getEntity();
        entity.setCreatedDate(this.timeSource.currentTimestamp());
        entity.setCreatedBy(this.currentAuthentication.getUser().getUsername());
    }

    @Subscribe
    public void onBeforeShow(Screen.BeforeShowEvent event) {
        MenuItemEntity entity = (MenuItemEntity)this.getEditedEntity();
        if (entity.getId() != null) {
            this.idField.setEditable(false);
        }
    }

    protected void updateCaption() {
        this.menuItemHelper.updateItemCaption((MenuItemEntity)this.getEditedEntity());
    }

    @Subscribe
    public void onBeforeCommitChanges(StandardEditor.BeforeCommitChangesEvent event) {
        MenuItemEntity entity = (MenuItemEntity)this.getEditedEntity();
        entity.setLastModifiedDate(this.timeSource.currentTimestamp());
        entity.setLastModifiedBy(this.currentAuthentication.getUser().getUsername());
    }
}

