/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu_item;

import io.jmix.core.Messages;
import io.jmix.core.UuidProvider;
import io.jmix.ui.menu.MenuItem;
import java.time.Instant;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.itsyn.jmix.menu_editor.entity.MenuItemEntity;
import ru.itsyn.jmix.menu_editor.entity.MenuItemType;
import ru.itsyn.jmix.menu_editor.entity.MenuOpenMode;
import ru.itsyn.jmix.menu_editor.util.MenuItemHelper;

@Component(value="menu_MenuItemFactory")
public class MenuItemFactory {
    public static final String ROOT_ITEM_ID = "rootItem";
    public static final String MESSAGE_PACK = MenuItemFactory.class.getPackageName();
    @Autowired
    Messages messages;
    @Autowired
    MenuItemHelper menuItemHelper;

    public MenuItemEntity createRootItem() {
        MenuItemEntity e = new MenuItemEntity();
        e.setId(ROOT_ITEM_ID);
        e.setItemType(MenuItemType.MENU);
        e.setCaptionKey(this.messages.getMessage(MESSAGE_PACK, "rootItemCaption"));
        this.menuItemHelper.updateItemCaption(e);
        return e;
    }

    public MenuItemEntity createItem(MenuItem item) {
        Element descriptor = item.getDescriptor();
        MenuItemEntity entity = new MenuItemEntity();
        entity.setId(item.getId());
        entity.setCaptionKey(item.getCaption());
        entity.setDescription(item.getDescription());
        entity.setStyleName(item.getStylename());
        entity.setIcon(item.getIcon());
        if (item.isMenu()) {
            entity.setItemType(MenuItemType.MENU);
            entity.setExpanded(item.isExpanded());
        } else if (item.isSeparator()) {
            entity.setItemType(MenuItemType.SEPARATOR);
            entity.setId(this.buildSeparatorId(item));
            entity.setCaptionKey(this.messages.getMessage((Enum)entity.getItemType()));
        } else {
            entity.setItemType(MenuItemType.SCREEN);
            entity.setScreen(item.getScreen());
            entity.setRunnableClass(item.getRunnableClass());
            entity.setBean(item.getBean());
            entity.setBeanMethod(item.getBeanMethod());
            if (descriptor != null) {
                entity.setOpenMode(MenuOpenMode.fromId(descriptor.attributeValue("openType")));
                entity.setShortcut(descriptor.attributeValue("shortcut"));
                entity.setContentXml(this.buildContentXml(descriptor));
            }
        }
        if (descriptor != null) {
            entity.setCreatedDate(this.parseDate(descriptor, "createdDate"));
            entity.setCreatedBy(descriptor.attributeValue("createdBy"));
            entity.setLastModifiedDate(this.parseDate(descriptor, "lastModifiedDate"));
            entity.setLastModifiedBy(descriptor.attributeValue("lastModifiedBy"));
            entity.setComment(descriptor.attributeValue("comment"));
        }
        this.menuItemHelper.updateItemCaption(entity);
        return entity;
    }

    String buildSeparatorId(MenuItem item) {
        MenuItem parent = item.getParent();
        if (parent == null) {
            return UuidProvider.createUuid().toString();
        }
        return "separator-" + parent.getChildren().indexOf(item);
    }

    String buildContentXml(Element descriptor) {
        if (descriptor.content().isEmpty()) {
            return null;
        }
        String xml = descriptor.asXML();
        xml = StringUtils.substringAfter((String)xml, (String)">");
        xml = StringUtils.substringBeforeLast((String)xml, (String)"<");
        return xml.lines().map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.joining("\n"));
    }

    Date parseDate(Element descriptor, String attribute) {
        String value = descriptor.attributeValue(attribute);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Date.from(Instant.parse(value));
    }
}

