/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu_item;

import io.jmix.core.LoadContext;
import io.jmix.core.querycondition.Condition;
import io.jmix.core.querycondition.LogicalCondition;
import io.jmix.core.querycondition.PropertyCondition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import ru.itsyn.jmix.menu_editor.entity.MenuItemEntity;

@Component
public class MenuItemFilterHelper {
    public List<MenuItemEntity> filterItems(List<MenuItemEntity> items, LoadContext<MenuItemEntity> loadContext) {
        if (items.isEmpty()) {
            return items;
        }
        PropertyCondition captionCondition = this.findPropertyCondition(loadContext.getQuery().getCondition(), "caption");
        if (captionCondition == null) {
            return items;
        }
        String captionExp = "" + captionCondition.getParameterValue();
        HashSet<MenuItemEntity> itemSet = new HashSet<MenuItemEntity>();
        itemSet.add(items.get(0));
        for (MenuItemEntity item : items) {
            if (!StringUtils.containsIgnoreCase((CharSequence)item.getCaption(), (CharSequence)captionExp)) continue;
            while (item != null) {
                itemSet.add(item);
                item = item.getParent();
            }
        }
        return items.stream().filter(itemSet::contains).collect(Collectors.toList());
    }

    public PropertyCondition findPropertyCondition(Condition condition, String property) {
        condition = condition != null ? condition.actualize(Collections.emptySet()) : null;
        return this.createConditionStream(condition).filter(c -> c instanceof PropertyCondition).map(c -> (PropertyCondition)c).filter(c -> property.equals(c.getProperty())).findFirst().orElse(null);
    }

    public Stream<Condition> createConditionStream(Condition condition) {
        if (condition instanceof LogicalCondition) {
            return ((LogicalCondition)condition).getConditions().stream().flatMap(this::createConditionStream);
        }
        return Stream.ofNullable(condition);
    }
}

