/*
 * Decompiled with CFR 0.152.
 */
package ru.itsyn.jmix.menu_editor.screen.menu_item;

import io.jmix.ui.menu.MenuItem;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import ru.itsyn.jmix.menu_editor.entity.MenuEntity;
import ru.itsyn.jmix.menu_editor.entity.MenuItemEntity;
import ru.itsyn.jmix.menu_editor.screen.menu_config.MenuConfigLoader;
import ru.itsyn.jmix.menu_editor.screen.menu_item.MenuItemFactory;

@Component(value="menu_MenuItemLoader")
@Scope(value="prototype")
public class MenuItemLoader {
    @Autowired
    ApplicationContext appContext;
    @Autowired
    MenuConfigLoader configLoader;
    @Autowired
    MenuItemFactory menuItemFactory;

    public MenuItemEntity loadMenu(MenuEntity menu) {
        List<MenuItem> items = this.configLoader.loadConfig(menu.getConfig());
        return this.buildMenu(items);
    }

    public MenuItemEntity buildMenu(List<MenuItem> items) {
        MenuItemEntity rootItem = this.menuItemFactory.createRootItem();
        items.forEach(i -> this.buildEntities((MenuItem)i, rootItem));
        return rootItem;
    }

    void buildEntities(MenuItem item, MenuItemEntity parent) {
        MenuItemEntity e = this.menuItemFactory.createItem(item);
        e.setParent(parent);
        parent.getChildren().add(e);
        item.getChildren().forEach(i -> this.buildEntities((MenuItem)i, e));
    }

    public MenuItemEntity loadDefaultMenu() {
        List<MenuItem> items = this.configLoader.loadDefaultConfig();
        return this.buildMenu(items);
    }
}

