/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.wait;

import io.github.itning.retry.strategy.wait.CompositeWaitStrategy;
import io.github.itning.retry.strategy.wait.ExceptionWaitStrategy;
import io.github.itning.retry.strategy.wait.ExponentialWaitStrategy;
import io.github.itning.retry.strategy.wait.FibonacciWaitStrategy;
import io.github.itning.retry.strategy.wait.FixedWaitStrategy;
import io.github.itning.retry.strategy.wait.IncrementingWaitStrategy;
import io.github.itning.retry.strategy.wait.RandomWaitStrategy;
import io.github.itning.retry.strategy.wait.WaitStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class WaitStrategies {
    private static final WaitStrategy NO_WAIT_STRATEGY = new FixedWaitStrategy(0L);

    private WaitStrategies() {
    }

    public static WaitStrategy noWait() {
        return NO_WAIT_STRATEGY;
    }

    public static WaitStrategy fixedWait(long sleepTime, @Nonnull TimeUnit timeUnit) throws IllegalStateException {
        Objects.requireNonNull(timeUnit, "The time unit may not be null");
        return new FixedWaitStrategy(timeUnit.toMillis(sleepTime));
    }

    public static WaitStrategy randomWait(long maximumTime, @Nonnull TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "The time unit may not be null");
        return new RandomWaitStrategy(0L, timeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy randomWait(long minimumTime, @Nonnull TimeUnit minimumTimeUnit, long maximumTime, @Nonnull TimeUnit maximumTimeUnit) {
        Objects.requireNonNull(minimumTimeUnit, "The minimum time unit may not be null");
        Objects.requireNonNull(maximumTimeUnit, "The maximum time unit may not be null");
        return new RandomWaitStrategy(minimumTimeUnit.toMillis(minimumTime), maximumTimeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy incrementingWait(long initialSleepTime, @Nonnull TimeUnit initialSleepTimeUnit, long increment, @Nonnull TimeUnit incrementTimeUnit) {
        Objects.requireNonNull(initialSleepTimeUnit, "The initial sleep time unit may not be null");
        Objects.requireNonNull(incrementTimeUnit, "The increment time unit may not be null");
        return new IncrementingWaitStrategy(initialSleepTimeUnit.toMillis(initialSleepTime), incrementTimeUnit.toMillis(increment));
    }

    public static WaitStrategy exponentialWait() {
        return new ExponentialWaitStrategy(1L, Long.MAX_VALUE);
    }

    public static WaitStrategy exponentialWait(long maximumTime, @Nonnull TimeUnit maximumTimeUnit) {
        Objects.requireNonNull(maximumTimeUnit, "The maximum time unit may not be null");
        return new ExponentialWaitStrategy(1L, maximumTimeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy exponentialWait(long multiplier, long maximumTime, @Nonnull TimeUnit maximumTimeUnit) {
        Objects.requireNonNull(maximumTimeUnit, "The maximum time unit may not be null");
        return new ExponentialWaitStrategy(multiplier, maximumTimeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy fibonacciWait() {
        return new FibonacciWaitStrategy(1L, Long.MAX_VALUE);
    }

    public static WaitStrategy fibonacciWait(long maximumTime, @Nonnull TimeUnit maximumTimeUnit) {
        Objects.requireNonNull(maximumTimeUnit, "The maximum time unit may not be null");
        return new FibonacciWaitStrategy(1L, maximumTimeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy fibonacciWait(long multiplier, long maximumTime, @Nonnull TimeUnit maximumTimeUnit) {
        Objects.requireNonNull(maximumTimeUnit, "The maximum time unit may not be null");
        return new FibonacciWaitStrategy(multiplier, maximumTimeUnit.toMillis(maximumTime));
    }

    public static <T extends Throwable> WaitStrategy exceptionWait(@Nonnull Class<T> exceptionClass, @Nonnull Function<T, Long> function) {
        Objects.requireNonNull(exceptionClass, "exceptionClass may not be null");
        Objects.requireNonNull(function, "function may not be null");
        return new ExceptionWaitStrategy<T>(exceptionClass, function);
    }

    public static WaitStrategy join(WaitStrategy ... waitStrategies) {
        if (waitStrategies.length <= 0) {
            throw new IllegalStateException("Must have at least one wait strategy");
        }
        List<WaitStrategy> waitStrategyList = Arrays.asList(waitStrategies);
        if (waitStrategyList.contains(null)) {
            throw new IllegalStateException("Cannot have a null wait strategy");
        }
        return new CompositeWaitStrategy(waitStrategyList);
    }
}

