/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.wait;

import io.github.itning.retry.Attempt;
import io.github.itning.retry.strategy.wait.WaitStrategy;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class IncrementingWaitStrategy
implements WaitStrategy {
    private final long initialSleepTime;
    private final long increment;

    public IncrementingWaitStrategy(long initialSleepTime, long increment) {
        if (initialSleepTime < 0L) {
            throw new IllegalArgumentException("initialSleepTime must be >= 0 but is " + initialSleepTime);
        }
        this.initialSleepTime = initialSleepTime;
        this.increment = increment;
    }

    @Override
    public long computeSleepTime(Attempt failedAttempt) {
        long result = this.initialSleepTime + this.increment * (failedAttempt.getAttemptNumber() - 1L);
        return Math.max(result, 0L);
    }
}

