/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry;

import io.github.itning.retry.Attempt;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RetryException
extends Exception {
    private final int numberOfFailedAttempts;
    private final Attempt<?> lastFailedAttempt;

    public RetryException(int numberOfFailedAttempts, @Nonnull Attempt<?> lastFailedAttempt) {
        this("Retrying failed to complete successfully after " + numberOfFailedAttempts + " attempts.", numberOfFailedAttempts, lastFailedAttempt);
    }

    public RetryException(String message, int numberOfFailedAttempts, Attempt<?> lastFailedAttempt) {
        super(message, Objects.requireNonNull(lastFailedAttempt, "Last attempt was null").hasException() ? lastFailedAttempt.getExceptionCause() : null);
        this.numberOfFailedAttempts = numberOfFailedAttempts;
        this.lastFailedAttempt = lastFailedAttempt;
    }

    public int getNumberOfFailedAttempts() {
        return this.numberOfFailedAttempts;
    }

    public Attempt<?> getLastFailedAttempt() {
        return this.lastFailedAttempt;
    }
}

