/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.stop;

import io.github.itning.retry.strategy.stop.NeverStopStrategy;
import io.github.itning.retry.strategy.stop.StopAfterAttemptStrategy;
import io.github.itning.retry.strategy.stop.StopAfterDelayStrategy;
import io.github.itning.retry.strategy.stop.StopStrategy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class StopStrategies {
    private StopStrategies() {
    }

    public static StopStrategy neverStop() {
        return NeverStopStrategy.INSTANCE;
    }

    public static StopStrategy stopAfterAttempt(int attemptNumber) {
        return new StopAfterAttemptStrategy(attemptNumber);
    }

    public static StopStrategy stopAfterDelay(long duration, @Nonnull TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "The time unit may not be null");
        return new StopAfterDelayStrategy(timeUnit.toMillis(duration));
    }
}

