/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry;

import io.github.itning.retry.Attempt;
import io.github.itning.retry.Retryer;
import io.github.itning.retry.listener.RetryListener;
import io.github.itning.retry.strategy.block.BlockStrategies;
import io.github.itning.retry.strategy.block.BlockStrategy;
import io.github.itning.retry.strategy.limit.AttemptTimeLimiter;
import io.github.itning.retry.strategy.limit.AttemptTimeLimiters;
import io.github.itning.retry.strategy.stop.StopStrategies;
import io.github.itning.retry.strategy.stop.StopStrategy;
import io.github.itning.retry.strategy.wait.WaitStrategies;
import io.github.itning.retry.strategy.wait.WaitStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class RetryerBuilder<V> {
    private AttemptTimeLimiter<V> attemptTimeLimiter;
    private StopStrategy stopStrategy;
    private WaitStrategy waitStrategy;
    private BlockStrategy blockStrategy;
    private Predicate<Attempt<V>> rejectionPredicate = vAttempt -> false;
    private final List<RetryListener<V>> listeners = new ArrayList<RetryListener<V>>();

    private RetryerBuilder() {
    }

    public static <V> RetryerBuilder<V> newBuilder() {
        return new RetryerBuilder<V>();
    }

    public RetryerBuilder<V> withRetryListener(@Nonnull RetryListener<V> listener) {
        Objects.requireNonNull(listener, "listener may not be null");
        this.listeners.add(listener);
        return this;
    }

    public RetryerBuilder<V> withWaitStrategy(@Nonnull WaitStrategy waitStrategy) throws IllegalStateException {
        Objects.requireNonNull(waitStrategy, "waitStrategy may not be null");
        if (this.waitStrategy != null) {
            throw new IllegalStateException("a wait strategy has already been set " + this.waitStrategy);
        }
        this.waitStrategy = waitStrategy;
        return this;
    }

    public RetryerBuilder<V> withStopStrategy(@Nonnull StopStrategy stopStrategy) throws IllegalStateException {
        Objects.requireNonNull(stopStrategy, "stopStrategy may not be null");
        if (this.stopStrategy != null) {
            throw new IllegalStateException("a stop strategy has already been set " + this.stopStrategy);
        }
        this.stopStrategy = stopStrategy;
        return this;
    }

    public RetryerBuilder<V> withBlockStrategy(@Nonnull BlockStrategy blockStrategy) throws IllegalStateException {
        Objects.requireNonNull(blockStrategy, "blockStrategy may not be null");
        if (this.blockStrategy != null) {
            throw new IllegalStateException("a block strategy has already been set " + this.blockStrategy);
        }
        this.blockStrategy = blockStrategy;
        return this;
    }

    public RetryerBuilder<V> withAttemptTimeLimiter(@Nonnull AttemptTimeLimiter<V> attemptTimeLimiter) {
        Objects.requireNonNull(attemptTimeLimiter);
        this.attemptTimeLimiter = attemptTimeLimiter;
        return this;
    }

    public RetryerBuilder<V> retryIfException() {
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionClassPredicate(Exception.class));
        return this;
    }

    public RetryerBuilder<V> retryIfRuntimeException() {
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionClassPredicate(RuntimeException.class));
        return this;
    }

    public RetryerBuilder<V> retryIfExceptionOfType(@Nonnull Class<? extends Throwable> exceptionClass) {
        Objects.requireNonNull(exceptionClass, "exceptionClass may not be null");
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionClassPredicate(exceptionClass));
        return this;
    }

    public RetryerBuilder<V> retryIfException(@Nonnull Predicate<Throwable> exceptionPredicate) {
        Objects.requireNonNull(exceptionPredicate, "exceptionPredicate may not be null");
        this.rejectionPredicate = this.rejectionPredicate.or(new ExceptionPredicate(exceptionPredicate));
        return this;
    }

    public RetryerBuilder<V> retryIfResult(@Nonnull Predicate<V> resultPredicate) {
        Objects.requireNonNull(resultPredicate, "resultPredicate may not be null");
        this.rejectionPredicate = this.rejectionPredicate.or(new ResultPredicate<V>(resultPredicate));
        return this;
    }

    public Retryer<V> build() {
        AttemptTimeLimiter theAttemptTimeLimiter = this.attemptTimeLimiter == null ? AttemptTimeLimiters.noTimeLimit() : this.attemptTimeLimiter;
        StopStrategy theStopStrategy = this.stopStrategy == null ? StopStrategies.neverStop() : this.stopStrategy;
        WaitStrategy theWaitStrategy = this.waitStrategy == null ? WaitStrategies.noWait() : this.waitStrategy;
        BlockStrategy theBlockStrategy = this.blockStrategy == null ? BlockStrategies.threadSleepStrategy() : this.blockStrategy;
        return new Retryer(theAttemptTimeLimiter, theStopStrategy, theWaitStrategy, theBlockStrategy, this.rejectionPredicate, this.listeners);
    }

    private static final class ExceptionPredicate<V>
    implements Predicate<Attempt<V>> {
        private final Predicate<Throwable> delegate;

        public ExceptionPredicate(Predicate<Throwable> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(Attempt<V> attempt) {
            if (!attempt.hasException()) {
                return false;
            }
            return this.delegate.test(attempt.getExceptionCause());
        }
    }

    private static final class ResultPredicate<V>
    implements Predicate<Attempt<V>> {
        private final Predicate<V> delegate;

        public ResultPredicate(Predicate<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(Attempt<V> attempt) {
            if (!attempt.hasResult()) {
                return false;
            }
            V result = attempt.getResult();
            return this.delegate.test(result);
        }
    }

    private static final class ExceptionClassPredicate<V>
    implements Predicate<Attempt<V>> {
        private final Class<? extends Throwable> exceptionClass;

        public ExceptionClassPredicate(Class<? extends Throwable> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        @Override
        public boolean test(Attempt<V> attempt) {
            if (!attempt.hasException()) {
                return false;
            }
            return this.exceptionClass.isAssignableFrom(attempt.getExceptionCause().getClass());
        }
    }
}

