/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.limit;

import io.github.itning.retry.strategy.limit.AttemptTimeLimiter;
import io.github.itning.retry.strategy.limit.FixedAttemptTimeLimit;
import io.github.itning.retry.strategy.limit.NoAttemptTimeLimit;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class AttemptTimeLimiters {
    private AttemptTimeLimiters() {
    }

    public static <V> AttemptTimeLimiter<V> noTimeLimit() {
        return new NoAttemptTimeLimit();
    }

    public static <V> AttemptTimeLimiter<V> fixedTimeLimit(long duration, @Nonnull TimeUnit timeUnit, @Nonnull ExecutorService executorService) {
        Objects.requireNonNull(timeUnit);
        return new FixedAttemptTimeLimit(duration, timeUnit, executorService);
    }
}

