/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.wait;

import io.github.itning.retry.Attempt;
import io.github.itning.retry.strategy.wait.WaitStrategy;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CompositeWaitStrategy
implements WaitStrategy {
    private final List<WaitStrategy> waitStrategies;

    public CompositeWaitStrategy(List<WaitStrategy> waitStrategies) {
        if (waitStrategies.isEmpty()) {
            throw new IllegalStateException("Need at least one wait strategy");
        }
        this.waitStrategies = waitStrategies;
    }

    @Override
    public long computeSleepTime(Attempt failedAttempt) {
        long waitTime = 0L;
        for (WaitStrategy waitStrategy : this.waitStrategies) {
            waitTime += waitStrategy.computeSleepTime(failedAttempt);
        }
        return waitTime;
    }
}

