/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.wait;

import io.github.itning.retry.Attempt;
import io.github.itning.retry.strategy.wait.WaitStrategy;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ExceptionWaitStrategy<T extends Throwable>
implements WaitStrategy {
    private final Class<T> exceptionClass;
    private final Function<T, Long> function;

    public ExceptionWaitStrategy(@Nonnull Class<T> exceptionClass, @Nonnull Function<T, Long> function) {
        this.exceptionClass = exceptionClass;
        this.function = function;
    }

    @Override
    public long computeSleepTime(Attempt lastAttempt) {
        Throwable cause;
        if (lastAttempt.hasException() && this.exceptionClass.isAssignableFrom((cause = lastAttempt.getExceptionCause()).getClass())) {
            return this.function.apply(cause);
        }
        return 0L;
    }
}

