/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.wait;

import io.github.itning.retry.Attempt;
import io.github.itning.retry.strategy.wait.WaitStrategy;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ExponentialWaitStrategy
implements WaitStrategy {
    private final long multiplier;
    private final long maximumWait;

    public ExponentialWaitStrategy(long multiplier, long maximumWait) {
        if (multiplier <= 0L) {
            throw new IllegalArgumentException("multiplier must be > 0 but is " + multiplier);
        }
        if (maximumWait < 0L) {
            throw new IllegalArgumentException("maximumWait must be >= 0 but is " + maximumWait);
        }
        if (multiplier >= maximumWait) {
            throw new IllegalArgumentException("multiplier must be < maximumWait but is " + multiplier);
        }
        this.multiplier = multiplier;
        this.maximumWait = maximumWait;
    }

    @Override
    public long computeSleepTime(Attempt failedAttempt) {
        double exp = Math.pow(2.0, failedAttempt.getAttemptNumber());
        long result = Math.round((double)this.multiplier * exp);
        if (result > this.maximumWait) {
            result = this.maximumWait;
        }
        return Math.max(result, 0L);
    }
}

