/*
 * Decompiled with CFR 0.152.
 */
package io.github.itning.retry.strategy.wait;

import io.github.itning.retry.Attempt;
import io.github.itning.retry.strategy.wait.WaitStrategy;
import java.util.Random;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RandomWaitStrategy
implements WaitStrategy {
    private static final Random RANDOM = new Random();
    private final long minimum;
    private final long maximum;

    public RandomWaitStrategy(long minimum, long maximum) {
        if (minimum < 0L) {
            throw new IllegalArgumentException("minimum must be >= 0 but is " + minimum);
        }
        if (maximum <= minimum) {
            throw new IllegalArgumentException("maximum must be > minimum but maximum is " + maximum + " and minimum is " + minimum);
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public long computeSleepTime(Attempt failedAttempt) {
        long t = Math.abs(RANDOM.nextLong()) % (this.maximum - this.minimum);
        return t + this.minimum;
    }
}

