/*
 * Decompiled with CFR 0.152.
 */
package io.github.jan.supabase.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.github.jan.supabase.SupabaseSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ'\u0010\r\u001a\u00020\u000b\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/jan/supabase/serializer/JacksonSerializer;", "Lio/github/jan/supabase/SupabaseSerializer;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "decode", "T", "", "type", "Lkotlin/reflect/KType;", "value", "", "(Lkotlin/reflect/KType;Ljava/lang/String;)Ljava/lang/Object;", "encode", "(Lkotlin/reflect/KType;Ljava/lang/Object;)Ljava/lang/String;", "serializer-jackson"})
public final class JacksonSerializer
implements SupabaseSerializer {
    @NotNull
    private final ObjectMapper mapper;

    public JacksonSerializer(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    public /* synthetic */ JacksonSerializer(ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper();
        }
        this(objectMapper);
    }

    @NotNull
    public <T> String encode(@NotNull KType type, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        String string = this.mapper.writeValueAsString(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @NotNull
    public <T> T decode(@NotNull KType type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = this.mapper.readValue(value, this.mapper.constructType(TypesJVMKt.getJavaType((KType)type)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (T)object;
    }

    public JacksonSerializer() {
        this(null, 1, null);
    }
}

