/*
 * Copyright 2023 TikTok Pte. Ltd.
 *
 * This source code is licensed under the MIT license found in
 * the LICENSE file in the root directory of this source tree.
 */

package business_api_client;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
/**
 * Tracking information.
 */
@Schema(description = "Tracking information.")
@javax.annotation.Generated(value = "com.tiktok.codegen.JavatiktokcodegenGenerator", date = "2023-06-28T14:49:22.099759+05:30[Asia/Kolkata]")
public class AdAcoBodyCommonMaterialTrackingInfo {
  @JsonProperty("click_tracking_urls")
  private List<String> clickTrackingUrls = null;

  @JsonProperty("impression_tracking_urls")
  private List<String> impressionTrackingUrls = null;

  @JsonProperty("tracking_app_id")
  private String trackingAppId = null;

  @JsonProperty("tracking_offline_event_set_ids")
  private List<String> trackingOfflineEventSetIds = null;

  @JsonProperty("tracking_pixel_id")
  private String trackingPixelId = null;

  @JsonProperty("vast_moat_enabled")
  private Boolean vastMoatEnabled = null;

  public AdAcoBodyCommonMaterialTrackingInfo clickTrackingUrls(List<String> clickTrackingUrls) {
    this.clickTrackingUrls = clickTrackingUrls;
    return this;
  }

  public AdAcoBodyCommonMaterialTrackingInfo addClickTrackingUrlsItem(String clickTrackingUrlsItem) {
    if (this.clickTrackingUrls == null) {
      this.clickTrackingUrls = new ArrayList<String>();
    }
    this.clickTrackingUrls.add(clickTrackingUrlsItem);
    return this;
  }

   /**
   * Click Tracking URL. URL generated by your data partner to track click events in your ads. Generally you can find and copy the URL from their platform. &lt;ul&gt;&lt;li&gt; If the partner ID for the App (&#x60;app_id&#x60; specified at the ad group level ) that you want to track is &#x60;44&#x60; (TikTok Business SDK) or &#x60;49&#x60; (TikTok App API), you don&#x27;t need to pass in this field. If you do, this field will be ignored. You can obtain the partner ID of an App through &#x60;partner_id&#x60; returned from [/app/list/](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1740859313270786) or [/app/info/](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1740859272887297).&lt;/li&gt;&lt;li&gt; If self-attribution has been enabled for the App (&#x60;app_id&#x60; specified at the ad group level ) that you want to track and the partner ID for the App is not &#x60;44&#x60; (TikTok Business SDK) or &#x60;49&#x60; (TikTok App API), you don&#x27;t need to pass in this field because this field will default to the Click Tracking URL you have configured for the App, and updates to the URL are not supported
   * @return clickTrackingUrls
  **/
  @Schema(description = "Click Tracking URL. URL generated by your data partner to track click events in your ads. Generally you can find and copy the URL from their platform. <ul><li> If the partner ID for the App (`app_id` specified at the ad group level ) that you want to track is `44` (TikTok Business SDK) or `49` (TikTok App API), you don't need to pass in this field. If you do, this field will be ignored. You can obtain the partner ID of an App through `partner_id` returned from [/app/list/](https://ads.tiktok.com/marketing_api/docs?id=1740859313270786) or [/app/info/](https://ads.tiktok.com/marketing_api/docs?id=1740859272887297).</li><li> If self-attribution has been enabled for the App (`app_id` specified at the ad group level ) that you want to track and the partner ID for the App is not `44` (TikTok Business SDK) or `49` (TikTok App API), you don't need to pass in this field because this field will default to the Click Tracking URL you have configured for the App, and updates to the URL are not supported")
  public List<String> getClickTrackingUrls() {
    return clickTrackingUrls;
  }

  public void setClickTrackingUrls(List<String> clickTrackingUrls) {
    this.clickTrackingUrls = clickTrackingUrls;
  }

  public AdAcoBodyCommonMaterialTrackingInfo impressionTrackingUrls(List<String> impressionTrackingUrls) {
    this.impressionTrackingUrls = impressionTrackingUrls;
    return this;
  }

  public AdAcoBodyCommonMaterialTrackingInfo addImpressionTrackingUrlsItem(String impressionTrackingUrlsItem) {
    if (this.impressionTrackingUrls == null) {
      this.impressionTrackingUrls = new ArrayList<String>();
    }
    this.impressionTrackingUrls.add(impressionTrackingUrlsItem);
    return this;
  }

   /**
   * Default Impression Tracking URL. URL generated by your data partner to track impression events in your ads. Generally you can find and copy the URL from their platform. &lt;ul&gt;&lt;li&gt; If the partner ID for the App (&#x60;app_id&#x60; specified at the ad group level ) that you want to track is &#x60;44&#x60; (TikTok Business SDK) or &#x60;49&#x60; (TikTok App API), you don&#x27;t need to pass in this field. If you do, this field will be ignored. You can obtain the partner ID of an App through &#x60;partner_id&#x60; returned from [/app/list/](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1740859313270786) or [/app/info/](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1740859272887297)
   * @return impressionTrackingUrls
  **/
  @Schema(description = "Default Impression Tracking URL. URL generated by your data partner to track impression events in your ads. Generally you can find and copy the URL from their platform. <ul><li> If the partner ID for the App (`app_id` specified at the ad group level ) that you want to track is `44` (TikTok Business SDK) or `49` (TikTok App API), you don't need to pass in this field. If you do, this field will be ignored. You can obtain the partner ID of an App through `partner_id` returned from [/app/list/](https://ads.tiktok.com/marketing_api/docs?id=1740859313270786) or [/app/info/](https://ads.tiktok.com/marketing_api/docs?id=1740859272887297)")
  public List<String> getImpressionTrackingUrls() {
    return impressionTrackingUrls;
  }

  public void setImpressionTrackingUrls(List<String> impressionTrackingUrls) {
    this.impressionTrackingUrls = impressionTrackingUrls;
  }

  public AdAcoBodyCommonMaterialTrackingInfo trackingAppId(String trackingAppId) {
    this.trackingAppId = trackingAppId;
    return this;
  }

   /**
   * The ID of the application that you want to track. You can use this field to track offsite app events. &lt;br&gt;This field supports the campaign objectives for both Auction ads (&#x60;REACH&#x60;, &#x60;VIDEO_VIEWS&#x60;, &#x60;TRAFFIC&#x60;, &#x60;WEB_CONVERSIONS&#x60;, &#x60;LEAD_GENERATION&#x60;, &#x60;APP_PROMOTION&#x60;, &#x60;PRODUCT_SALES&#x60;, &#x60;ENGAGEMENT&#x60;) and Reach &amp; Frequency ads (&#x60;RF_REACH&#x60;).&lt;br&gt;If &#x60;app_id&#x60; is specified at the ad group level and you want to track offsite app events, then the application ID you pass via this field must be the same ID that you specified at the ad group level. Otherwise, you can pass in any application ID that you&#x27;d like to track via this field.&lt;br&gt;You can get application ID (&#x60;app_id&#x60;) via [/app/list/](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1740859313270786).
   * @return trackingAppId
  **/
  @Schema(description = "The ID of the application that you want to track. You can use this field to track offsite app events. <br>This field supports the campaign objectives for both Auction ads (`REACH`, `VIDEO_VIEWS`, `TRAFFIC`, `WEB_CONVERSIONS`, `LEAD_GENERATION`, `APP_PROMOTION`, `PRODUCT_SALES`, `ENGAGEMENT`) and Reach & Frequency ads (`RF_REACH`).<br>If `app_id` is specified at the ad group level and you want to track offsite app events, then the application ID you pass via this field must be the same ID that you specified at the ad group level. Otherwise, you can pass in any application ID that you'd like to track via this field.<br>You can get application ID (`app_id`) via [/app/list/](https://ads.tiktok.com/marketing_api/docs?id=1740859313270786).")
  public String getTrackingAppId() {
    return trackingAppId;
  }

  public void setTrackingAppId(String trackingAppId) {
    this.trackingAppId = trackingAppId;
  }

  public AdAcoBodyCommonMaterialTrackingInfo trackingOfflineEventSetIds(List<String> trackingOfflineEventSetIds) {
    this.trackingOfflineEventSetIds = trackingOfflineEventSetIds;
    return this;
  }

  public AdAcoBodyCommonMaterialTrackingInfo addTrackingOfflineEventSetIdsItem(String trackingOfflineEventSetIdsItem) {
    if (this.trackingOfflineEventSetIds == null) {
      this.trackingOfflineEventSetIds = new ArrayList<String>();
    }
    this.trackingOfflineEventSetIds.add(trackingOfflineEventSetIdsItem);
    return this;
  }

   /**
   * A list of Offline Event set IDs that you want to track. You can use this field to track and measure offline activity from people that see or interact with your ads.
   * @return trackingOfflineEventSetIds
  **/
  @Schema(description = "A list of Offline Event set IDs that you want to track. You can use this field to track and measure offline activity from people that see or interact with your ads.")
  public List<String> getTrackingOfflineEventSetIds() {
    return trackingOfflineEventSetIds;
  }

  public void setTrackingOfflineEventSetIds(List<String> trackingOfflineEventSetIds) {
    this.trackingOfflineEventSetIds = trackingOfflineEventSetIds;
  }

  public AdAcoBodyCommonMaterialTrackingInfo trackingPixelId(String trackingPixelId) {
    this.trackingPixelId = trackingPixelId;
    return this;
  }

   /**
   * The pixel ID that you&#x27;d like to track. You can use this field to track offsite events. It supports the campaign objectives for both Auction ads (&#x60;REACH&#x60;, &#x60;VIDEO_VIEWS&#x60;, &#x60;TRAFFIC&#x60;, &#x60;WEB_CONVERSIONS&#x60;, &#x60;LEAD_GENERATION&#x60;, &#x60;APP_PROMOTION&#x60;, &#x60;PRODUCT_SALES&#x60;, &#x60;ENGAGEMENT&#x60;) and Reach &amp; Frequency ads.
   * @return trackingPixelId
  **/
  @Schema(description = "The pixel ID that you'd like to track. You can use this field to track offsite events. It supports the campaign objectives for both Auction ads (`REACH`, `VIDEO_VIEWS`, `TRAFFIC`, `WEB_CONVERSIONS`, `LEAD_GENERATION`, `APP_PROMOTION`, `PRODUCT_SALES`, `ENGAGEMENT`) and Reach & Frequency ads.")
  public String getTrackingPixelId() {
    return trackingPixelId;
  }

  public void setTrackingPixelId(String trackingPixelId) {
    this.trackingPixelId = trackingPixelId;
  }

  public AdAcoBodyCommonMaterialTrackingInfo vastMoatEnabled(Boolean vastMoatEnabled) {
    this.vastMoatEnabled = vastMoatEnabled;
    return this;
  }

   /**
   * Get vastMoatEnabled
   * @return vastMoatEnabled
  **/
  @Schema(description = "")
  public Boolean isVastMoatEnabled() {
    return vastMoatEnabled;
  }

  public void setVastMoatEnabled(Boolean vastMoatEnabled) {
    this.vastMoatEnabled = vastMoatEnabled;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdAcoBodyCommonMaterialTrackingInfo adAcoBodyCommonMaterialTrackingInfo = (AdAcoBodyCommonMaterialTrackingInfo) o;
    return Objects.equals(this.clickTrackingUrls, adAcoBodyCommonMaterialTrackingInfo.clickTrackingUrls) &&
        Objects.equals(this.impressionTrackingUrls, adAcoBodyCommonMaterialTrackingInfo.impressionTrackingUrls) &&
        Objects.equals(this.trackingAppId, adAcoBodyCommonMaterialTrackingInfo.trackingAppId) &&
        Objects.equals(this.trackingOfflineEventSetIds, adAcoBodyCommonMaterialTrackingInfo.trackingOfflineEventSetIds) &&
        Objects.equals(this.trackingPixelId, adAcoBodyCommonMaterialTrackingInfo.trackingPixelId) &&
        Objects.equals(this.vastMoatEnabled, adAcoBodyCommonMaterialTrackingInfo.vastMoatEnabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clickTrackingUrls, impressionTrackingUrls, trackingAppId, trackingOfflineEventSetIds, trackingPixelId, vastMoatEnabled);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdAcoBodyCommonMaterialTrackingInfo {\n");
    
    sb.append("    clickTrackingUrls: ").append(toIndentedString(clickTrackingUrls)).append("\n");
    sb.append("    impressionTrackingUrls: ").append(toIndentedString(impressionTrackingUrls)).append("\n");
    sb.append("    trackingAppId: ").append(toIndentedString(trackingAppId)).append("\n");
    sb.append("    trackingOfflineEventSetIds: ").append(toIndentedString(trackingOfflineEventSetIds)).append("\n");
    sb.append("    trackingPixelId: ").append(toIndentedString(trackingPixelId)).append("\n");
    sb.append("    vastMoatEnabled: ").append(toIndentedString(vastMoatEnabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
