/*
 * Copyright 2023 TikTok Pte. Ltd.
 *
 * This source code is licensed under the MIT license found in
 * the LICENSE file in the root directory of this source tree.
 */
package io.swagger.client.api;

import business_api.ApiException;
import business_api.SDKException;
import business_api.SDKExceptionForEvent;
import business_api.Response;
import business_api.ApiClient;
import business_api.Configuration;
import business_api.Pair;

import javax.ws.rs.core.GenericType;

import business_api_client.InlineResponse200;
import business_api_client.PixelBatchBody;
import business_api_client.PixelTrackBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "com.tiktok.codegen.JavatiktokcodegenGenerator", date = "2023-06-28T14:49:22.099759+05:30[Asia/Kolkata]")public class EventCallbackApi {
  private ApiClient apiClient;

  public EventCallbackApi() {
    this(Configuration.getDefaultApiClient());
  }

  public EventCallbackApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Pixel Track server-to-server batch api
   * 
   * @param accessToken Authorized Access Token. Option1: [Recommended] Can be obtained in Events Manger under Assets-&gt;Event-&gt; Website Pixel-&gt;Select any pixel in TikTok Ads Manager: https://ads.tiktok.com/i18n/ as described in [Get Started](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1739584855420929). Please be aware that only an Admin or Operator role can generate a token. Option2: with your own developer app, refer to [Authentication](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1738373164380162)  (required)
   * @param body Pixel batch update body parameters (optional)
   * @return InlineResponse200
   * @throws ApiException if fails to make API call
   */
  public Response pixelBatch(String accessToken, PixelBatchBody body) throws ApiException, SDKException, SDKExceptionForEvent {
    Object localVarPostBody = body;
    // verify the required parameter 'accessToken' is set
    if (accessToken == null) {
      throw new ApiException(400, "Missing the required parameter 'accessToken' when calling pixelBatch");
    }
    // create path and map variables
    String localVarPath = "/open_api/v1.3/pixel/batch/";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (accessToken != null)
      localVarHeaderParams.put("Access-Token", apiClient.parameterToString(accessToken));

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse200> localVarReturnType = new GenericType<InlineResponse200>() {};
    InlineResponse200 response = apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      if(response.getCode() != 0)
    {
      if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
          throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
      }
      throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
    }
      Response return_response = new Response();
    return_response.setData(response.getData());
    return_response.setRequestId(response.getRequestId());

    return return_response;
  }
  /**
   * Pixel Track server-to-server api
   * 
   * @param accessToken Authorized Access Token. Option1: [Recommended] Can be obtained in Events Manger under Assets-&gt;Event-&gt; Website Pixel-&gt;Select any pixel in TikTok Ads Manager: https://ads.tiktok.com/i18n/ as described in [Get Started](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1739584855420929). Please be aware that only an Admin or Operator role can generate a token. Option2: with your own developer app, refer to [Authentication](https://ads.tiktok.com/marketing_api/docs?id&#x3D;1738373164380162)  (required)
   * @param body Pixel track body parameters (optional)
   * @return InlineResponse200
   * @throws ApiException if fails to make API call
   */
  public Response pixelTrack(String accessToken, PixelTrackBody body) throws ApiException, SDKException, SDKExceptionForEvent {
    Object localVarPostBody = body;
    // verify the required parameter 'accessToken' is set
    if (accessToken == null) {
      throw new ApiException(400, "Missing the required parameter 'accessToken' when calling pixelTrack");
    }
    // create path and map variables
    String localVarPath = "/open_api/v1.3/pixel/track/";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (accessToken != null)
      localVarHeaderParams.put("Access-Token", apiClient.parameterToString(accessToken));

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse200> localVarReturnType = new GenericType<InlineResponse200>() {};
    InlineResponse200 response = apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      if(response.getCode() != 0)
    {
      if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
          throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
      }
      throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
    }
      Response return_response = new Response();
    return_response.setData(response.getData());
    return_response.setRequestId(response.getRequestId());

    return return_response;
  }
}
