/*
 * Decompiled with CFR 0.152.
 */
package business_api;

import business_api.CustomInstantDeserializer;
import business_api.RFC3339DateFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.threetenbp.ThreeTenModule;
import java.text.DateFormat;
import javax.ws.rs.ext.ContextResolver;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZonedDateTime;

public class JSON
implements ContextResolver<ObjectMapper> {
    private ObjectMapper mapper = new ObjectMapper();

    public JSON() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.mapper.setDateFormat((DateFormat)((Object)new RFC3339DateFormat()));
        ThreeTenModule module = new ThreeTenModule();
        module.addDeserializer(Instant.class, CustomInstantDeserializer.INSTANT);
        module.addDeserializer(OffsetDateTime.class, CustomInstantDeserializer.OFFSET_DATE_TIME);
        module.addDeserializer(ZonedDateTime.class, CustomInstantDeserializer.ZONED_DATE_TIME);
        this.mapper.registerModule((Module)module);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.mapper.setDateFormat(dateFormat);
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }
}

