/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import business_api_client.AdAcoBodyCommonMaterialTrackingInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Common material.")
public class AdAcoBodyCommonMaterial {
    @JsonProperty(value="ad_name")
    private String adName = null;
    @JsonProperty(value="call_to_action_id")
    private String callToActionId = null;
    @JsonProperty(value="creative_authorized")
    private Boolean creativeAuthorized = null;
    @JsonProperty(value="fallback_type")
    private String fallbackType = null;
    @JsonProperty(value="identity_id")
    private String identityId = null;
    @JsonProperty(value="identity_type")
    private String identityType = null;
    @JsonProperty(value="is_smart_creative")
    private Boolean isSmartCreative = null;
    @JsonProperty(value="playable_url")
    private String playableUrl = null;
    @JsonProperty(value="tracking_info")
    private AdAcoBodyCommonMaterialTrackingInfo trackingInfo = null;

    public AdAcoBodyCommonMaterial adName(String adName) {
        this.adName = adName;
        return this;
    }

    @Schema(description="Ad name. Set as \" \" (Empty string) for it to be automatically generated. The format of auto-generated ad name is- creative name + creation time (e.g. adcreative20210111190739). Character limit is 512 and cannot contain emoji.")
    public String getAdName() {
        return this.adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public AdAcoBodyCommonMaterial callToActionId(String callToActionId) {
        this.callToActionId = callToActionId;
        return this;
    }

    @Schema(description="The ID of the CTA portfolio that you want to use in your ads. A CTA portfolio is a group of auto-optimized CTAs. For details about auto-optimized CTAs, see [CTA recommendations > Dynamic CTAs](https://ads.tiktok.com/marketing_api/docs?id=1740307296329730)")
    public String getCallToActionId() {
        return this.callToActionId;
    }

    public void setCallToActionId(String callToActionId) {
        this.callToActionId = callToActionId;
    }

    public AdAcoBodyCommonMaterial creativeAuthorized(Boolean creativeAuthorized) {
        this.creativeAuthorized = creativeAuthorized;
        return this;
    }

    @Schema(description="Whether you grant displaying some of your ads in our TikTok for Business Creative Center. Only valid for non-US advertisers, the default value is `false`.")
    public Boolean isCreativeAuthorized() {
        return this.creativeAuthorized;
    }

    public void setCreativeAuthorized(Boolean creativeAuthorized) {
        this.creativeAuthorized = creativeAuthorized;
    }

    public AdAcoBodyCommonMaterial fallbackType(String fallbackType) {
        this.fallbackType = fallbackType;
        return this;
    }

    @Schema(description="Fallback Type. If the audience do not have the app installed, you can have them fall back to install the app, or to view a specific web page.  Allowed values- `APP_INSTALL `, `WEBSITE`. If website is chosen, you need to specify the url via `landing_page_urls` field.")
    public String getFallbackType() {
        return this.fallbackType;
    }

    public void setFallbackType(String fallbackType) {
        this.fallbackType = fallbackType;
    }

    public AdAcoBodyCommonMaterial identityId(String identityId) {
        this.identityId = identityId;
        return this;
    }

    @Schema(description="Identity ID, required when you use Spark Ads (`tiktok_item_id`).")
    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public AdAcoBodyCommonMaterial identityType(String identityType) {
        this.identityType = identityType;
        return this;
    }

    @Schema(description="Identity type. Required when you use Spark Ads (`tiktok_item_id`). Enum values- `AUTH_CODE`, `TT_USER`. For details about identities, see [Identities](https://ads.tiktok.com/marketing_api/docs?id=1738958351620097).")
    public String getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public AdAcoBodyCommonMaterial isSmartCreative(Boolean isSmartCreative) {
        this.isSmartCreative = isSmartCreative;
        return this;
    }

    @Schema(description="Whether the ad is a Smart Creative ad. Default value- `False`. Smart Creative is currently an allowlist-only feature. If you would like to access it, please contact your TikTok representative.")
    public Boolean isIsSmartCreative() {
        return this.isSmartCreative;
    }

    public void setIsSmartCreative(Boolean isSmartCreative) {
        this.isSmartCreative = isSmartCreative;
    }

    public AdAcoBodyCommonMaterial playableUrl(String playableUrl) {
        this.playableUrl = playableUrl;
        return this;
    }

    @Schema(description="Playable material url, valid only in Pangle placement. You can get the url via the [/playable/get/](https://ads.tiktok.com/marketing_api/docs?id=1737732758495234) endpoint. Note that all ads in the same ad group share the same playable material.")
    public String getPlayableUrl() {
        return this.playableUrl;
    }

    public void setPlayableUrl(String playableUrl) {
        this.playableUrl = playableUrl;
    }

    public AdAcoBodyCommonMaterial trackingInfo(AdAcoBodyCommonMaterialTrackingInfo trackingInfo) {
        this.trackingInfo = trackingInfo;
        return this;
    }

    @Schema(description="")
    public AdAcoBodyCommonMaterialTrackingInfo getTrackingInfo() {
        return this.trackingInfo;
    }

    public void setTrackingInfo(AdAcoBodyCommonMaterialTrackingInfo trackingInfo) {
        this.trackingInfo = trackingInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdAcoBodyCommonMaterial adAcoBodyCommonMaterial = (AdAcoBodyCommonMaterial)o;
        return Objects.equals(this.adName, adAcoBodyCommonMaterial.adName) && Objects.equals(this.callToActionId, adAcoBodyCommonMaterial.callToActionId) && Objects.equals(this.creativeAuthorized, adAcoBodyCommonMaterial.creativeAuthorized) && Objects.equals(this.fallbackType, adAcoBodyCommonMaterial.fallbackType) && Objects.equals(this.identityId, adAcoBodyCommonMaterial.identityId) && Objects.equals(this.identityType, adAcoBodyCommonMaterial.identityType) && Objects.equals(this.isSmartCreative, adAcoBodyCommonMaterial.isSmartCreative) && Objects.equals(this.playableUrl, adAcoBodyCommonMaterial.playableUrl) && Objects.equals(this.trackingInfo, adAcoBodyCommonMaterial.trackingInfo);
    }

    public int hashCode() {
        return Objects.hash(this.adName, this.callToActionId, this.creativeAuthorized, this.fallbackType, this.identityId, this.identityType, this.isSmartCreative, this.playableUrl, this.trackingInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdAcoBodyCommonMaterial {\n");
        sb.append("    adName: ").append(this.toIndentedString(this.adName)).append("\n");
        sb.append("    callToActionId: ").append(this.toIndentedString(this.callToActionId)).append("\n");
        sb.append("    creativeAuthorized: ").append(this.toIndentedString(this.creativeAuthorized)).append("\n");
        sb.append("    fallbackType: ").append(this.toIndentedString(this.fallbackType)).append("\n");
        sb.append("    identityId: ").append(this.toIndentedString(this.identityId)).append("\n");
        sb.append("    identityType: ").append(this.toIndentedString(this.identityType)).append("\n");
        sb.append("    isSmartCreative: ").append(this.toIndentedString(this.isSmartCreative)).append("\n");
        sb.append("    playableUrl: ").append(this.toIndentedString(this.playableUrl)).append("\n");
        sb.append("    trackingInfo: ").append(this.toIndentedString(this.trackingInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

