/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Tracking information.")
public class AdAcoBodyCommonMaterialTrackingInfo {
    @JsonProperty(value="click_tracking_urls")
    private List<String> clickTrackingUrls = null;
    @JsonProperty(value="impression_tracking_urls")
    private List<String> impressionTrackingUrls = null;
    @JsonProperty(value="tracking_app_id")
    private String trackingAppId = null;
    @JsonProperty(value="tracking_offline_event_set_ids")
    private List<String> trackingOfflineEventSetIds = null;
    @JsonProperty(value="tracking_pixel_id")
    private String trackingPixelId = null;
    @JsonProperty(value="vast_moat_enabled")
    private Boolean vastMoatEnabled = null;

    public AdAcoBodyCommonMaterialTrackingInfo clickTrackingUrls(List<String> clickTrackingUrls) {
        this.clickTrackingUrls = clickTrackingUrls;
        return this;
    }

    public AdAcoBodyCommonMaterialTrackingInfo addClickTrackingUrlsItem(String clickTrackingUrlsItem) {
        if (this.clickTrackingUrls == null) {
            this.clickTrackingUrls = new ArrayList<String>();
        }
        this.clickTrackingUrls.add(clickTrackingUrlsItem);
        return this;
    }

    @Schema(description="Click Tracking URL. URL generated by your data partner to track click events in your ads. Generally you can find and copy the URL from their platform. <ul><li> If the partner ID for the App (`app_id` specified at the ad group level ) that you want to track is `44` (TikTok Business SDK) or `49` (TikTok App API), you don't need to pass in this field. If you do, this field will be ignored. You can obtain the partner ID of an App through `partner_id` returned from [/app/list/](https://ads.tiktok.com/marketing_api/docs?id=1740859313270786) or [/app/info/](https://ads.tiktok.com/marketing_api/docs?id=1740859272887297).</li><li> If self-attribution has been enabled for the App (`app_id` specified at the ad group level ) that you want to track and the partner ID for the App is not `44` (TikTok Business SDK) or `49` (TikTok App API), you don't need to pass in this field because this field will default to the Click Tracking URL you have configured for the App, and updates to the URL are not supported")
    public List<String> getClickTrackingUrls() {
        return this.clickTrackingUrls;
    }

    public void setClickTrackingUrls(List<String> clickTrackingUrls) {
        this.clickTrackingUrls = clickTrackingUrls;
    }

    public AdAcoBodyCommonMaterialTrackingInfo impressionTrackingUrls(List<String> impressionTrackingUrls) {
        this.impressionTrackingUrls = impressionTrackingUrls;
        return this;
    }

    public AdAcoBodyCommonMaterialTrackingInfo addImpressionTrackingUrlsItem(String impressionTrackingUrlsItem) {
        if (this.impressionTrackingUrls == null) {
            this.impressionTrackingUrls = new ArrayList<String>();
        }
        this.impressionTrackingUrls.add(impressionTrackingUrlsItem);
        return this;
    }

    @Schema(description="Default Impression Tracking URL. URL generated by your data partner to track impression events in your ads. Generally you can find and copy the URL from their platform. <ul><li> If the partner ID for the App (`app_id` specified at the ad group level ) that you want to track is `44` (TikTok Business SDK) or `49` (TikTok App API), you don't need to pass in this field. If you do, this field will be ignored. You can obtain the partner ID of an App through `partner_id` returned from [/app/list/](https://ads.tiktok.com/marketing_api/docs?id=1740859313270786) or [/app/info/](https://ads.tiktok.com/marketing_api/docs?id=1740859272887297)")
    public List<String> getImpressionTrackingUrls() {
        return this.impressionTrackingUrls;
    }

    public void setImpressionTrackingUrls(List<String> impressionTrackingUrls) {
        this.impressionTrackingUrls = impressionTrackingUrls;
    }

    public AdAcoBodyCommonMaterialTrackingInfo trackingAppId(String trackingAppId) {
        this.trackingAppId = trackingAppId;
        return this;
    }

    @Schema(description="The ID of the application that you want to track. You can use this field to track offsite app events. <br>This field supports the campaign objectives for both Auction ads (`REACH`, `VIDEO_VIEWS`, `TRAFFIC`, `WEB_CONVERSIONS`, `LEAD_GENERATION`, `APP_PROMOTION`, `PRODUCT_SALES`, `ENGAGEMENT`) and Reach & Frequency ads (`RF_REACH`).<br>If `app_id` is specified at the ad group level and you want to track offsite app events, then the application ID you pass via this field must be the same ID that you specified at the ad group level. Otherwise, you can pass in any application ID that you'd like to track via this field.<br>You can get application ID (`app_id`) via [/app/list/](https://ads.tiktok.com/marketing_api/docs?id=1740859313270786).")
    public String getTrackingAppId() {
        return this.trackingAppId;
    }

    public void setTrackingAppId(String trackingAppId) {
        this.trackingAppId = trackingAppId;
    }

    public AdAcoBodyCommonMaterialTrackingInfo trackingOfflineEventSetIds(List<String> trackingOfflineEventSetIds) {
        this.trackingOfflineEventSetIds = trackingOfflineEventSetIds;
        return this;
    }

    public AdAcoBodyCommonMaterialTrackingInfo addTrackingOfflineEventSetIdsItem(String trackingOfflineEventSetIdsItem) {
        if (this.trackingOfflineEventSetIds == null) {
            this.trackingOfflineEventSetIds = new ArrayList<String>();
        }
        this.trackingOfflineEventSetIds.add(trackingOfflineEventSetIdsItem);
        return this;
    }

    @Schema(description="A list of Offline Event set IDs that you want to track. You can use this field to track and measure offline activity from people that see or interact with your ads.")
    public List<String> getTrackingOfflineEventSetIds() {
        return this.trackingOfflineEventSetIds;
    }

    public void setTrackingOfflineEventSetIds(List<String> trackingOfflineEventSetIds) {
        this.trackingOfflineEventSetIds = trackingOfflineEventSetIds;
    }

    public AdAcoBodyCommonMaterialTrackingInfo trackingPixelId(String trackingPixelId) {
        this.trackingPixelId = trackingPixelId;
        return this;
    }

    @Schema(description="The pixel ID that you'd like to track. You can use this field to track offsite events. It supports the campaign objectives for both Auction ads (`REACH`, `VIDEO_VIEWS`, `TRAFFIC`, `WEB_CONVERSIONS`, `LEAD_GENERATION`, `APP_PROMOTION`, `PRODUCT_SALES`, `ENGAGEMENT`) and Reach & Frequency ads.")
    public String getTrackingPixelId() {
        return this.trackingPixelId;
    }

    public void setTrackingPixelId(String trackingPixelId) {
        this.trackingPixelId = trackingPixelId;
    }

    public AdAcoBodyCommonMaterialTrackingInfo vastMoatEnabled(Boolean vastMoatEnabled) {
        this.vastMoatEnabled = vastMoatEnabled;
        return this;
    }

    @Schema(description="")
    public Boolean isVastMoatEnabled() {
        return this.vastMoatEnabled;
    }

    public void setVastMoatEnabled(Boolean vastMoatEnabled) {
        this.vastMoatEnabled = vastMoatEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdAcoBodyCommonMaterialTrackingInfo adAcoBodyCommonMaterialTrackingInfo = (AdAcoBodyCommonMaterialTrackingInfo)o;
        return Objects.equals(this.clickTrackingUrls, adAcoBodyCommonMaterialTrackingInfo.clickTrackingUrls) && Objects.equals(this.impressionTrackingUrls, adAcoBodyCommonMaterialTrackingInfo.impressionTrackingUrls) && Objects.equals(this.trackingAppId, adAcoBodyCommonMaterialTrackingInfo.trackingAppId) && Objects.equals(this.trackingOfflineEventSetIds, adAcoBodyCommonMaterialTrackingInfo.trackingOfflineEventSetIds) && Objects.equals(this.trackingPixelId, adAcoBodyCommonMaterialTrackingInfo.trackingPixelId) && Objects.equals(this.vastMoatEnabled, adAcoBodyCommonMaterialTrackingInfo.vastMoatEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.clickTrackingUrls, this.impressionTrackingUrls, this.trackingAppId, this.trackingOfflineEventSetIds, this.trackingPixelId, this.vastMoatEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdAcoBodyCommonMaterialTrackingInfo {\n");
        sb.append("    clickTrackingUrls: ").append(this.toIndentedString(this.clickTrackingUrls)).append("\n");
        sb.append("    impressionTrackingUrls: ").append(this.toIndentedString(this.impressionTrackingUrls)).append("\n");
        sb.append("    trackingAppId: ").append(this.toIndentedString(this.trackingAppId)).append("\n");
        sb.append("    trackingOfflineEventSetIds: ").append(this.toIndentedString(this.trackingOfflineEventSetIds)).append("\n");
        sb.append("    trackingPixelId: ").append(this.toIndentedString(this.trackingPixelId)).append("\n");
        sb.append("    vastMoatEnabled: ").append(this.toIndentedString(this.vastMoatEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

