/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import business_api_client.AdAcoBodyMediaInfoImageInfo;
import business_api_client.AdAcoBodyMediaInfoVideoInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Material information.")
public class AdAcoBodyMediaInfo {
    @JsonProperty(value="identity_id")
    private String identityId = null;
    @JsonProperty(value="identity_type")
    private String identityType = null;
    @JsonProperty(value="image_info")
    private List<AdAcoBodyMediaInfoImageInfo> imageInfo = null;
    @JsonProperty(value="tiktok_item_id")
    private String tiktokItemId = null;
    @JsonProperty(value="video_info")
    private AdAcoBodyMediaInfoVideoInfo videoInfo = null;

    public AdAcoBodyMediaInfo identityId(String identityId) {
        this.identityId = identityId;
        return this;
    }

    @Schema(description="Identity ID. Required when you are not using Spark Ads (`tiktok_item_id`).")
    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public AdAcoBodyMediaInfo identityType(String identityType) {
        this.identityType = identityType;
        return this;
    }

    @Schema(description="Identity type. Required when you are not using Spark Ads (`tiktok_item_id`). The only supported value is `CUSTOMIZED_USER`.")
    public String getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public AdAcoBodyMediaInfo imageInfo(List<AdAcoBodyMediaInfoImageInfo> imageInfo) {
        this.imageInfo = imageInfo;
        return this;
    }

    public AdAcoBodyMediaInfo addImageInfoItem(AdAcoBodyMediaInfoImageInfo imageInfoItem) {
        if (this.imageInfo == null) {
            this.imageInfo = new ArrayList<AdAcoBodyMediaInfoImageInfo>();
        }
        this.imageInfo.add(imageInfoItem);
        return this;
    }

    @Schema(description="Image information. When you want to upload image materials (`video_info` is NOT included in the request), this field will be used as image materials. When you want to upload video materials (`video_info` is included in the request), this field will be used as the video cover. Only 1 picture can be submitted in each `image_info` object.")
    public List<AdAcoBodyMediaInfoImageInfo> getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(List<AdAcoBodyMediaInfoImageInfo> imageInfo) {
        this.imageInfo = imageInfo;
    }

    public AdAcoBodyMediaInfo tiktokItemId(String tiktokItemId) {
        this.tiktokItemId = tiktokItemId;
        return this;
    }

    @Schema(description="The ID of the TikTok post to be used as an ad (Spark Ad). Pass in the `tiktok_item_id` you get from the response of the [/tt_video/info/](https://ads.tiktok.com/marketing_api/docs?id=1738376324021250) and  [/identity/video/get/](https://ads.tiktok.com/marketing_api/docs?id=1740218475032577) endpoints.")
    public String getTiktokItemId() {
        return this.tiktokItemId;
    }

    public void setTiktokItemId(String tiktokItemId) {
        this.tiktokItemId = tiktokItemId;
    }

    public AdAcoBodyMediaInfo videoInfo(AdAcoBodyMediaInfoVideoInfo videoInfo) {
        this.videoInfo = videoInfo;
        return this;
    }

    @Schema(description="")
    public AdAcoBodyMediaInfoVideoInfo getVideoInfo() {
        return this.videoInfo;
    }

    public void setVideoInfo(AdAcoBodyMediaInfoVideoInfo videoInfo) {
        this.videoInfo = videoInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdAcoBodyMediaInfo adAcoBodyMediaInfo = (AdAcoBodyMediaInfo)o;
        return Objects.equals(this.identityId, adAcoBodyMediaInfo.identityId) && Objects.equals(this.identityType, adAcoBodyMediaInfo.identityType) && Objects.equals(this.imageInfo, adAcoBodyMediaInfo.imageInfo) && Objects.equals(this.tiktokItemId, adAcoBodyMediaInfo.tiktokItemId) && Objects.equals(this.videoInfo, adAcoBodyMediaInfo.videoInfo);
    }

    public int hashCode() {
        return Objects.hash(this.identityId, this.identityType, this.imageInfo, this.tiktokItemId, this.videoInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdAcoBodyMediaInfo {\n");
        sb.append("    identityId: ").append(this.toIndentedString(this.identityId)).append("\n");
        sb.append("    identityType: ").append(this.toIndentedString(this.identityType)).append("\n");
        sb.append("    imageInfo: ").append(this.toIndentedString(this.imageInfo)).append("\n");
        sb.append("    tiktokItemId: ").append(this.toIndentedString(this.tiktokItemId)).append("\n");
        sb.append("    videoInfo: ").append(this.toIndentedString(this.videoInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

