/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.util.Objects;

public class AdUploadBody {
    @JsonProperty(value="advertiser_id")
    private String advertiserId = null;
    @JsonProperty(value="auto_bind_enabled")
    private Boolean autoBindEnabled = null;
    @JsonProperty(value="auto_fix_enabled")
    private Boolean autoFixEnabled = null;
    @JsonProperty(value="file_id")
    private String fileId = null;
    @JsonProperty(value="file_name")
    private String fileName = null;
    @JsonProperty(value="flaw_detect")
    private Boolean flawDetect = null;
    @JsonProperty(value="is_third_party")
    private Boolean isThirdParty = null;
    @JsonProperty(value="upload_type")
    private String uploadType = null;
    @JsonProperty(value="video_file")
    private File videoFile = null;
    @JsonProperty(value="video_id")
    private String videoId = null;
    @JsonProperty(value="video_signature")
    private String videoSignature = null;
    @JsonProperty(value="video_url")
    private String videoUrl = null;

    public AdUploadBody advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Schema(description="Advertiser ID")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public AdUploadBody autoBindEnabled(Boolean autoBindEnabled) {
        this.autoBindEnabled = autoBindEnabled;
        return this;
    }

    @Schema(description="Whether to automatically upload the fixed video to your creative library. Default value : False. Valid only when flaw_detect = True and auto_fix_enabled = True.")
    public Boolean isAutoBindEnabled() {
        return this.autoBindEnabled;
    }

    public void setAutoBindEnabled(Boolean autoBindEnabled) {
        this.autoBindEnabled = autoBindEnabled;
    }

    public AdUploadBody autoFixEnabled(Boolean autoFixEnabled) {
        this.autoFixEnabled = autoFixEnabled;
        return this;
    }

    @Schema(description="Whether to automatically fix the detected issue. Default value : False. \\n If an issue is detected in your video and: \\n auto_fix_enabled = False, then well return an error message with flaw types indicated. \\n auto_fix_enabled =True, then well automatically fix all the issues and return fix_task_id and flaw_types.")
    public Boolean isAutoFixEnabled() {
        return this.autoFixEnabled;
    }

    public void setAutoFixEnabled(Boolean autoFixEnabled) {
        this.autoFixEnabled = autoFixEnabled;
    }

    public AdUploadBody fileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    @Schema(description="The file_id of the file that you want to upload. This field is for files that are uploaded to the file repository. You can get file_id via the Upload Files endpoints. This field is required when upload_type is UPLOAD_BY_FILE_ID.")
    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public AdUploadBody fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(description="Video name. Length limit: 1 - 100 characters. The default value is the file name or the last path of the URL. If the file name contains more than 100 characters, only the first 100 characters will be used. Note: Videos under the same advertiser_id cannot have duplicated file names. If you get an error about duplicated file names, please rename the files or append timestamps to the original file names (for example, in the format of _, and upload the videos again.")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public AdUploadBody flawDetect(Boolean flawDetect) {
        this.flawDetect = flawDetect;
        return this;
    }

    @Schema(description="Whether to automatically detect an issue in your video. Default value is False.")
    public Boolean isFlawDetect() {
        return this.flawDetect;
    }

    public void setFlawDetect(Boolean flawDetect) {
        this.flawDetect = flawDetect;
    }

    public AdUploadBody isThirdParty(Boolean isThirdParty) {
        this.isThirdParty = isThirdParty;
        return this;
    }

    @Schema(description="The video is third party or not.")
    public Boolean isIsThirdParty() {
        return this.isThirdParty;
    }

    public void setIsThirdParty(Boolean isThirdParty) {
        this.isThirdParty = isThirdParty;
    }

    public AdUploadBody uploadType(String uploadType) {
        this.uploadType = uploadType;
        return this;
    }

    @Schema(description="Image upload method. Default value: UPLOAD_BY_FILE Enum values: UPLOAD_BY_FILE, UPLOAD_BY_URL, UPLOAD_BY_FILE_ID, UPLOAD_BY_VIDEO_ID.")
    public String getUploadType() {
        return this.uploadType;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public AdUploadBody videoFile(File videoFile) {
        this.videoFile = videoFile;
        return this;
    }

    @Schema(description="Video file. Required when upload_type is UPLOAD_BY_FILE.")
    public File getVideoFile() {
        return this.videoFile;
    }

    public void setVideoFile(File videoFile) {
        this.videoFile = videoFile;
    }

    public AdUploadBody videoId(String videoId) {
        this.videoId = videoId;
        return this;
    }

    @Schema(description="Video ID. Required when upload_type is UPLOAD_BY_VIDEO_ID.")
    public String getVideoId() {
        return this.videoId;
    }

    public void setVideoId(String videoId) {
        this.videoId = videoId;
    }

    public AdUploadBody videoSignature(String videoSignature) {
        this.videoSignature = videoSignature;
        return this;
    }

    @Schema(description="Video MD5 (used for server verification). Required when upload_type is UPLOAD_BY_FILE.")
    public String getVideoSignature() {
        return this.videoSignature;
    }

    public void setVideoSignature(String videoSignature) {
        this.videoSignature = videoSignature;
    }

    public AdUploadBody videoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
        return this;
    }

    @Schema(description="Video url address, like http://xxx.xxx. Required when upload_type is UPLOAD_BY_URL. \\n (1) File size: better within 10MB. \\n (2)Verification: we will verify the data if you set a Content-MD5 in the response header. \\n (3) Others: ratio, format, resolution and bitrate limitation is the same as video_file.")
    public String getVideoUrl() {
        return this.videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdUploadBody adUploadBody = (AdUploadBody)o;
        return Objects.equals(this.advertiserId, adUploadBody.advertiserId) && Objects.equals(this.autoBindEnabled, adUploadBody.autoBindEnabled) && Objects.equals(this.autoFixEnabled, adUploadBody.autoFixEnabled) && Objects.equals(this.fileId, adUploadBody.fileId) && Objects.equals(this.fileName, adUploadBody.fileName) && Objects.equals(this.flawDetect, adUploadBody.flawDetect) && Objects.equals(this.isThirdParty, adUploadBody.isThirdParty) && Objects.equals(this.uploadType, adUploadBody.uploadType) && Objects.equals(this.videoFile, adUploadBody.videoFile) && Objects.equals(this.videoId, adUploadBody.videoId) && Objects.equals(this.videoSignature, adUploadBody.videoSignature) && Objects.equals(this.videoUrl, adUploadBody.videoUrl);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserId, this.autoBindEnabled, this.autoFixEnabled, this.fileId, this.fileName, this.flawDetect, this.isThirdParty, this.uploadType, Objects.hashCode(this.videoFile), this.videoId, this.videoSignature, this.videoUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdUploadBody {\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    autoBindEnabled: ").append(this.toIndentedString(this.autoBindEnabled)).append("\n");
        sb.append("    autoFixEnabled: ").append(this.toIndentedString(this.autoFixEnabled)).append("\n");
        sb.append("    fileId: ").append(this.toIndentedString(this.fileId)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    flawDetect: ").append(this.toIndentedString(this.flawDetect)).append("\n");
        sb.append("    isThirdParty: ").append(this.toIndentedString(this.isThirdParty)).append("\n");
        sb.append("    uploadType: ").append(this.toIndentedString(this.uploadType)).append("\n");
        sb.append("    videoFile: ").append(this.toIndentedString(this.videoFile)).append("\n");
        sb.append("    videoId: ").append(this.toIndentedString(this.videoId)).append("\n");
        sb.append("    videoSignature: ").append(this.toIndentedString(this.videoSignature)).append("\n");
        sb.append("    videoUrl: ").append(this.toIndentedString(this.videoUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

