/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import business_api_client.OpenApiv13adgroupcreateActions;
import business_api_client.OpenApiv13adgroupcreateExcludedCustomActions;
import business_api_client.OpenApiv13adgroupcreateIncludedCustomActions;
import business_api_client.OpenApiv13adgroupcreateTargetingExpansion;
import business_api_client.OpenApiv13adgroupupdateAudienceRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AdgroupUpdateBody {
    @JsonProperty(value="actions")
    private List<OpenApiv13adgroupcreateActions> actions = null;
    @JsonProperty(value="adgroup_id")
    private String adgroupId = null;
    @JsonProperty(value="adgroup_name")
    private String adgroupName = null;
    @JsonProperty(value="advertiser_id")
    private String advertiserId = null;
    @JsonProperty(value="age_groups")
    private List<String> ageGroups = null;
    @JsonProperty(value="app_download_url")
    private String appDownloadUrl = null;
    @JsonProperty(value="app_id")
    private String appId = null;
    @JsonProperty(value="audience_ids")
    private List<String> audienceIds = null;
    @JsonProperty(value="audience_rule")
    private OpenApiv13adgroupupdateAudienceRule audienceRule = null;
    @JsonProperty(value="audience_type")
    private String audienceType = null;
    @JsonProperty(value="auto_targeting_enabled")
    private Boolean autoTargetingEnabled = null;
    @JsonProperty(value="bid_price")
    private BigDecimal bidPrice = null;
    @JsonProperty(value="bid_type")
    private String bidType = null;
    @JsonProperty(value="billing_event")
    private String billingEvent = null;
    @JsonProperty(value="blocked_pangle_app_ids")
    private List<String> blockedPangleAppIds = null;
    @JsonProperty(value="brand_safety_type")
    private String brandSafetyType = null;
    @JsonProperty(value="budget")
    private BigDecimal budget = null;
    @JsonProperty(value="carrier_ids")
    private List<String> carrierIds = null;
    @JsonProperty(value="catalog_authorized_bc_id")
    private String catalogAuthorizedBcId = null;
    @JsonProperty(value="comment_disabled")
    private String commentDisabled = null;
    @JsonProperty(value="contextual_tag_ids")
    private List<String> contextualTagIds = null;
    @JsonProperty(value="conversion_bid_price")
    private BigDecimal conversionBidPrice = null;
    @JsonProperty(value="conversion_id")
    private Integer conversionId = null;
    @JsonProperty(value="creative_material_mode")
    private String creativeMaterialMode = null;
    @JsonProperty(value="dayparting")
    private String dayparting = null;
    @JsonProperty(value="deep_bid_type")
    private String deepBidType = null;
    @JsonProperty(value="deep_cpa_bid")
    private BigDecimal deepCpaBid = null;
    @JsonProperty(value="device_model_ids")
    private List<String> deviceModelIds = null;
    @JsonProperty(value="device_price_ranges")
    private List<Integer> devicePriceRanges = null;
    @JsonProperty(value="excluded_audience_ids")
    private List<String> excludedAudienceIds = null;
    @JsonProperty(value="excluded_custom_actions")
    private OpenApiv13adgroupcreateExcludedCustomActions excludedCustomActions = null;
    @JsonProperty(value="excluded_pangle_audience_package_ids")
    private List<String> excludedPangleAudiencePackageIds = null;
    @JsonProperty(value="frequency")
    private Integer frequency = null;
    @JsonProperty(value="frequency_schedule")
    private Integer frequencySchedule = null;
    @JsonProperty(value="gender")
    private String gender = null;
    @JsonProperty(value="household_income")
    private List<String> householdIncome = null;
    @JsonProperty(value="identity_id")
    private String identityId = null;
    @JsonProperty(value="identity_type")
    private String identityType = null;
    @JsonProperty(value="identity_authorized_bc_id")
    private String identityAuthorizedBcId = null;
    @JsonProperty(value="included_custom_actions")
    private OpenApiv13adgroupcreateIncludedCustomActions includedCustomActions = null;
    @JsonProperty(value="included_pangle_audience_package_ids")
    private List<String> includedPangleAudiencePackageIds = null;
    @JsonProperty(value="interest_category_ids")
    private List<String> interestCategoryIds = null;
    @JsonProperty(value="interest_keyword_ids")
    private List<String> interestKeywordIds = null;
    @JsonProperty(value="interest_keywords")
    private List<String> interestKeywords = null;
    @JsonProperty(value="ios14_targeting")
    private String ios14Targeting = null;
    @JsonProperty(value="is_hfss")
    private Boolean isHfss = null;
    @JsonProperty(value="languages")
    private List<String> languages = null;
    @JsonProperty(value="location_ids")
    private List<String> locationIds = null;
    @JsonProperty(value="min_android_version")
    private String minAndroidVersion = null;
    @JsonProperty(value="min_ios_version")
    private String minIosVersion = null;
    @JsonProperty(value="network_types")
    private List<String> networkTypes = null;
    @JsonProperty(value="next_day_retention")
    private BigDecimal nextDayRetention = null;
    @JsonProperty(value="operating_systems")
    private List<String> operatingSystems = null;
    @JsonProperty(value="pacing")
    private String pacing = null;
    @JsonProperty(value="purchase_intention_keyword_ids")
    private List<String> purchaseIntentionKeywordIds = null;
    @JsonProperty(value="roas_bid")
    private BigDecimal roasBid = null;
    @JsonProperty(value="schedule_end_time")
    private String scheduleEndTime = null;
    @JsonProperty(value="schedule_start_time")
    private String scheduleStartTime = null;
    @JsonProperty(value="schedule_type")
    private String scheduleType = null;
    @JsonProperty(value="secondary_optimization_event")
    private String secondaryOptimizationEvent = null;
    @JsonProperty(value="shopping_ads_retargeting_actions_days")
    private Integer shoppingAdsRetargetingActionsDays = null;
    @JsonProperty(value="shopping_ads_retargeting_type")
    private String shoppingAdsRetargetingType = null;
    @JsonProperty(value="spending_power")
    private String spendingPower = null;
    @JsonProperty(value="targeting_expansion")
    private OpenApiv13adgroupcreateTargetingExpansion targetingExpansion = null;

    public AdgroupUpdateBody actions(List<OpenApiv13adgroupcreateActions> actions) {
        this.actions = actions;
        return this;
    }

    public AdgroupUpdateBody addActionsItem(OpenApiv13adgroupcreateActions actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<OpenApiv13adgroupcreateActions>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Schema(description="A list of action category objects.")
    public List<OpenApiv13adgroupcreateActions> getActions() {
        return this.actions;
    }

    public void setActions(List<OpenApiv13adgroupcreateActions> actions) {
        this.actions = actions;
    }

    public AdgroupUpdateBody adgroupId(String adgroupId) {
        this.adgroupId = adgroupId;
        return this;
    }

    @Schema(required=true, description="Ad group ID")
    public String getAdgroupId() {
        return this.adgroupId;
    }

    public void setAdgroupId(String adgroupId) {
        this.adgroupId = adgroupId;
    }

    public AdgroupUpdateBody adgroupName(String adgroupName) {
        this.adgroupName = adgroupName;
        return this;
    }

    @Schema(description="Ad group name. Character limit is 512 and cannot contain emoji.")
    public String getAdgroupName() {
        return this.adgroupName;
    }

    public void setAdgroupName(String adgroupName) {
        this.adgroupName = adgroupName;
    }

    public AdgroupUpdateBody advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Schema(required=true, description="Advertiser ID")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public AdgroupUpdateBody ageGroups(List<String> ageGroups) {
        this.ageGroups = ageGroups;
        return this;
    }

    public AdgroupUpdateBody addAgeGroupsItem(String ageGroupsItem) {
        if (this.ageGroups == null) {
            this.ageGroups = new ArrayList<String>();
        }
        this.ageGroups.add(ageGroupsItem);
        return this;
    }

    @Schema(description="Age groups you want to target. For enum values, see [Enumeration - Targeting Age Group](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public List<String> getAgeGroups() {
        return this.ageGroups;
    }

    public void setAgeGroups(List<String> ageGroups) {
        this.ageGroups = ageGroups;
    }

    public AdgroupUpdateBody appDownloadUrl(String appDownloadUrl) {
        this.appDownloadUrl = appDownloadUrl;
        return this;
    }

    @Schema(description="App download link")
    public String getAppDownloadUrl() {
        return this.appDownloadUrl;
    }

    public void setAppDownloadUrl(String appDownloadUrl) {
        this.appDownloadUrl = appDownloadUrl;
    }

    public AdgroupUpdateBody appId(String appId) {
        this.appId = appId;
        return this;
    }

    @Schema(description="The Application id of the promoted app. You can get `app_id` by using the [/app/list/](https://ads.tiktok.com/marketing_api/docs?id=1740859313270786) endpoint. Required in the following use cases- When `objective_type` is `APP_INSTALL`.When `objective_type` is `APP_PROMOTION` and `app_promotion_type` is `APP_RETARGETING` (App retargeting).When `objective_type` is `APP_PROMOTION` , `app_promotion_type` is `APP_INSTALL`(App install), and it is not an iOS14 Dedicated Campaign.When `objective_type` is `CONVERSIONS` and `promotion_type` is `APP_ANDROID` or `APP_IOS`")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public AdgroupUpdateBody audienceIds(List<String> audienceIds) {
        this.audienceIds = audienceIds;
        return this;
    }

    public AdgroupUpdateBody addAudienceIdsItem(String audienceIdsItem) {
        if (this.audienceIds == null) {
            this.audienceIds = new ArrayList<String>();
        }
        this.audienceIds.add(audienceIdsItem);
        return this;
    }

    @Schema(description="List of audience IDs. You can get audience IDs by using the [/dmp/custom_audience/list/](https://ads.tiktok.com/marketing_api/docs?id=1739940506015746) endpoint.")
    public List<String> getAudienceIds() {
        return this.audienceIds;
    }

    public void setAudienceIds(List<String> audienceIds) {
        this.audienceIds = audienceIds;
    }

    public AdgroupUpdateBody audienceRule(OpenApiv13adgroupupdateAudienceRule audienceRule) {
        this.audienceRule = audienceRule;
        return this;
    }

    @Schema(description="")
    public OpenApiv13adgroupupdateAudienceRule getAudienceRule() {
        return this.audienceRule;
    }

    public void setAudienceRule(OpenApiv13adgroupupdateAudienceRule audienceRule) {
        this.audienceRule = audienceRule;
    }

    public AdgroupUpdateBody audienceType(String audienceType) {
        this.audienceType = audienceType;
        return this;
    }

    @Schema(description="App retargeting audience type, required when objective_type is `CONVERSIONS` and externla_type is app-related. Currently, the only supported enumeration is `NEW_CUSTOM_AUDIENCE`; for this type, you must pass audience IDs to the `audience_ids` field when creating or updating the ad group. The audiences to be used must be either Custom File Audience or App Activity Audience. Optionally, you can specify the `excluded_audience_ids` field. If both `audience_ids` and `excluded_audience_ids` are specified, they cannot contain the same IDs")
    public String getAudienceType() {
        return this.audienceType;
    }

    public void setAudienceType(String audienceType) {
        this.audienceType = audienceType;
    }

    public AdgroupUpdateBody autoTargetingEnabled(Boolean autoTargetingEnabled) {
        this.autoTargetingEnabled = autoTargetingEnabled;
        return this;
    }

    @Schema(description="Whether to enable automated targeting.")
    public Boolean isAutoTargetingEnabled() {
        return this.autoTargetingEnabled;
    }

    public void setAutoTargetingEnabled(Boolean autoTargetingEnabled) {
        this.autoTargetingEnabled = autoTargetingEnabled;
    }

    public AdgroupUpdateBody bidPrice(BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
        return this;
    }

    @Schema(description="The maximum cost per result you are willing to bid (for Bid Cap bidding strategy), or an average cost per result that you want to achieve (for Cost Cap bidding strategy). When Campaign Budget Optimization (`budget_optimize_on`) is on, we suggest that you set the same bid value for all ad groups in the campaign. Note- To specify `bid_price`, you need to set `bid_type` as `BID_TYPE_CUSTOM`.`bid_price` needs to be lower than budget set at the campaign level and ad group level. See [Bidding-Bidding limits](https://ads.tiktok.com/marketing_api/docs?id=1745292444424193) to learn more about the bid verification mechanism.")
    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    public void setBidPrice(BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }

    public AdgroupUpdateBody bidType(String bidType) {
        this.bidType = bidType;
        return this;
    }

    @Schema(description="Bidding strategy that determines how the system manages your cost per result, spends your budget, and how it delivers ads. Required when Campaign Budget Optimization (CBO) is enabled (`budget_optimize_on` = `TRUE`). For enum values, see [Enumeration - Bidding Strategy](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public String getBidType() {
        return this.bidType;
    }

    public void setBidType(String bidType) {
        this.bidType = bidType;
    }

    public AdgroupUpdateBody billingEvent(String billingEvent) {
        this.billingEvent = billingEvent;
        return this;
    }

    @Schema(description="Events that you want to pay for. For enum values, see [Enumeration - Billing Event](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).|")
    public String getBillingEvent() {
        return this.billingEvent;
    }

    public void setBillingEvent(String billingEvent) {
        this.billingEvent = billingEvent;
    }

    public AdgroupUpdateBody blockedPangleAppIds(List<String> blockedPangleAppIds) {
        this.blockedPangleAppIds = blockedPangleAppIds;
        return this;
    }

    public AdgroupUpdateBody addBlockedPangleAppIdsItem(String blockedPangleAppIdsItem) {
        if (this.blockedPangleAppIds == null) {
            this.blockedPangleAppIds = new ArrayList<String>();
        }
        this.blockedPangleAppIds.add(blockedPangleAppIdsItem);
        return this;
    }

    @Schema(description="Pangle app block list ID. You can get an ID via the `app_package_id` field returned by [Get Pangle block list](https://ads.tiktok.com/marketing_api/docs?id=1740039957181441). It only takes effect when Pangle placement is selected.")
    public List<String> getBlockedPangleAppIds() {
        return this.blockedPangleAppIds;
    }

    public void setBlockedPangleAppIds(List<String> blockedPangleAppIds) {
        this.blockedPangleAppIds = blockedPangleAppIds;
    }

    public AdgroupUpdateBody brandSafetyType(String brandSafetyType) {
        this.brandSafetyType = brandSafetyType;
        return this;
    }

    @Schema(description="Valid only when `placements` is set as `PLACEMENT_TIKTOK`. Default value- `NO_BRAND_SAFETY`. Enum values- `NO_BRAND_SAFETY`-  To not use any brand safety solution.  Full inventory, which means your ads may appear next to some content featuring mature themes. `STANDARD_INVENTORY`- Use TikTok's brand safety solution. Standard inventory means that ads will appear next to content that is appropriate for most brands. `LIMITED_INVENTORY`- Use TikTok's brand safety solution. Limited inventory means that your ads will not appear next to content that contains mature themes.`THIRD_PARTY`- Use a third-party brand safety solution. You also need to pass in a value to the `brand_safety_partner` field. To get the countries and regions that your ads can be deployed to based on your brand safety settings, use the [/tool/region/] function. Note -   Pre-bid first-party Brand Safety solutions for `APP_PROMOTION`, `APP_INSTALL`, `WEB_CONVERSIONS`, `CONVERSIONS`, `TRAFFIC`,  `LEAD_GENERATION` objectives in Auction ads, and pre-bid third-party brand safety solutions are currently allowlist-only features. If you would like to access them, please contact your TikTok representative.  Pre-bid third-party Brand Safety solutions are not supported for TikTok Pulse campaigns (`rf_campaign_type` =`PULSE`).  See [Brand safety](https://ads.tiktok.com/marketing_api/docs?id=1739381752981505) to learn about the supported advertising objectives, supported markets, and the general introduction of pre-bid Brand Safety filtering.  Once set, this field cannot be modified.")
    public String getBrandSafetyType() {
        return this.brandSafetyType;
    }

    public void setBrandSafetyType(String brandSafetyType) {
        this.brandSafetyType = brandSafetyType;
    }

    public AdgroupUpdateBody budget(BigDecimal budget) {
        this.budget = budget;
        return this;
    }

    @Schema(description="Ad group budget. The setting will be ignored when Campaign Budget Optimization (`budget_optimize_on` = `TRUE`) is enabled. For how to configure budget settings, see [Budget](https://ads.tiktok.com/marketing_api/docs?id=1739381246298114). To directly see the daily budget value range for a currency, see [Currency-Daily budget value range](https://ads.tiktok.com/marketing_api/docs?id=1737585839634433).")
    public BigDecimal getBudget() {
        return this.budget;
    }

    public void setBudget(BigDecimal budget) {
        this.budget = budget;
    }

    public AdgroupUpdateBody carrierIds(List<String> carrierIds) {
        this.carrierIds = carrierIds;
        return this;
    }

    public AdgroupUpdateBody addCarrierIdsItem(String carrierIdsItem) {
        if (this.carrierIds == null) {
            this.carrierIds = new ArrayList<String>();
        }
        this.carrierIds.add(carrierIdsItem);
        return this;
    }

    @Schema(description="Carriers that you want to target. A carrier is valid only when the `in_use` field for the carrier is `true`. The carriers must be consistent with the location(s) that you want to target. Use [/tool/carrier/](https://ads.tiktok.com/marketing_api/docs?id=1737168013095938) endpoint to get the enum values.")
    public List<String> getCarrierIds() {
        return this.carrierIds;
    }

    public void setCarrierIds(List<String> carrierIds) {
        this.carrierIds = carrierIds;
    }

    public AdgroupUpdateBody catalogAuthorizedBcId(String catalogAuthorizedBcId) {
        this.catalogAuthorizedBcId = catalogAuthorizedBcId;
        return this;
    }

    @Schema(description="For catalogs in Business Center, you must specify the ID of the Business Center that a catalog belongs to.")
    public String getCatalogAuthorizedBcId() {
        return this.catalogAuthorizedBcId;
    }

    public void setCatalogAuthorizedBcId(String catalogAuthorizedBcId) {
        this.catalogAuthorizedBcId = catalogAuthorizedBcId;
    }

    public AdgroupUpdateBody commentDisabled(String commentDisabled) {
        this.commentDisabled = commentDisabled;
        return this;
    }

    @Schema(description="Whether to allow comments on your ads on TikTok.")
    public String getCommentDisabled() {
        return this.commentDisabled;
    }

    public void setCommentDisabled(String commentDisabled) {
        this.commentDisabled = commentDisabled;
    }

    public AdgroupUpdateBody contextualTagIds(List<String> contextualTagIds) {
        this.contextualTagIds = contextualTagIds;
        return this;
    }

    public AdgroupUpdateBody addContextualTagIdsItem(String contextualTagIdsItem) {
        if (this.contextualTagIds == null) {
            this.contextualTagIds = new ArrayList<String>();
        }
        this.contextualTagIds.add(contextualTagIdsItem);
        return this;
    }

    @Schema(description="Contextual tag IDs. You can use [/tool/contextual_tag/get/](https://ads.tiktok.com/marketing_api/docs?id=1747747118654465) to get available contextual tags.  See [Contextual targeting](https://ads.tiktok.com/marketing_api/docs?id=1745292519923713)  to learn more about how to use contextual targeting.<p><span style=\"color-darkred\"><b>Note</b></span>- This is an allowlist-only feature. If you would like to access it, please contact your TikTok representative.Only supports `REACH` and `VIDEO_VIEWS` as objectives (`objective_type`) at the campaign level. Not supported when `brand_safety_type` is set to `THIRD_PARTY`.")
    public List<String> getContextualTagIds() {
        return this.contextualTagIds;
    }

    public void setContextualTagIds(List<String> contextualTagIds) {
        this.contextualTagIds = contextualTagIds;
    }

    public AdgroupUpdateBody conversionBidPrice(BigDecimal conversionBidPrice) {
        this.conversionBidPrice = conversionBidPrice;
        return this;
    }

    @Schema(description="Where you can set a target cost per conversion for oCPM(Optimized Cost per Mille); Required when `billing_event` = `OCPM` and `bid_type` = `BID_TYPE_CUSTOM`.`conversion_bid_price` needs to be lower than budget set at the campaign level and ad group level. See [Bidding-Bidding limits](https://ads.tiktok.com/marketing_api/docs?id=1745292444424193) to learn more about the bid verification mechanism.")
    public BigDecimal getConversionBidPrice() {
        return this.conversionBidPrice;
    }

    public void setConversionBidPrice(BigDecimal conversionBidPrice) {
        this.conversionBidPrice = conversionBidPrice;
    }

    public AdgroupUpdateBody conversionId(Integer conversionId) {
        this.conversionId = conversionId;
        return this;
    }

    @Schema(description="Conversion Id")
    public Integer getConversionId() {
        return this.conversionId;
    }

    public void setConversionId(Integer conversionId) {
        this.conversionId = conversionId;
    }

    public AdgroupUpdateBody creativeMaterialMode(String creativeMaterialMode) {
        this.creativeMaterialMode = creativeMaterialMode;
        return this;
    }

    @Schema(description="The strategy that your creatives will be delivered.<br data-tomark-pass>`Note`- When you choose automated ad, your creative materials will automatically be combined for delivery. Tiktok Ads' smart optimization algorithm is applied and will be used to achieve the best ad performance during delivery. <br data-tomark-pass>Optional values include- `CUSTOM` (custom), `DYNAMIC` (automated). Default value is `CUSTOM` (custom). See [help center](https://ads.tiktok.com/help/article?aid=6670043695674294277) for more.")
    public String getCreativeMaterialMode() {
        return this.creativeMaterialMode;
    }

    public void setCreativeMaterialMode(String creativeMaterialMode) {
        this.creativeMaterialMode = creativeMaterialMode;
    }

    public AdgroupUpdateBody dayparting(String dayparting) {
        this.dayparting = dayparting;
        return this;
    }

    @Schema(description="Ad delivery arrangement, in the format of a string that consists of 48 x 7 characters. Each character is mapped to a 30-minute timeframe from Monday to Sunday. Each character can be set to either 0 or 1. 1 represents delivery in the 30-minute timeframe, and 0 stands for non-delivery in the 30-minute timeframe. The first character is mapped to 0-01-0-30 of Monday; The second character is mapped to 0-31-1-00 of Monday, and the last character represents 23-31-0-00 Sunday.")
    public String getDayparting() {
        return this.dayparting;
    }

    public void setDayparting(String dayparting) {
        this.dayparting = dayparting;
    }

    public AdgroupUpdateBody deepBidType(String deepBidType) {
        this.deepBidType = deepBidType;
        return this;
    }

    @Schema(description="Bidding strategy for in-app events. Required when Campaign Budget Optimization (CBO) is enabled (`budget_optimize_on` = `TRUE`)  and `optimization_goal` is `VALUE`. Enum values- `VO_MIN_ROAS` (allowlisted), `VO_HIGHEST_VALUE` (allowlisted). For details, see [Enumeration - Deep-level Bidding Strategy](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public String getDeepBidType() {
        return this.deepBidType;
    }

    public void setDeepBidType(String deepBidType) {
        this.deepBidType = deepBidType;
    }

    public AdgroupUpdateBody deepCpaBid(BigDecimal deepCpaBid) {
        this.deepCpaBid = deepCpaBid;
        return this;
    }

    @Schema(description="Deep CPA bid")
    public BigDecimal getDeepCpaBid() {
        return this.deepCpaBid;
    }

    public void setDeepCpaBid(BigDecimal deepCpaBid) {
        this.deepCpaBid = deepCpaBid;
    }

    public AdgroupUpdateBody deviceModelIds(List<String> deviceModelIds) {
        this.deviceModelIds = deviceModelIds;
        return this;
    }

    public AdgroupUpdateBody addDeviceModelIdsItem(String deviceModelIdsItem) {
        if (this.deviceModelIds == null) {
            this.deviceModelIds = new ArrayList<String>();
        }
        this.deviceModelIds.add(deviceModelIdsItem);
        return this;
    }

    @Schema(description="IDs of the device models that you want to target. Use [/tool/device_model/](https://ads.tiktok.com/marketing_api/docs?id=1737172880570369) to get the complete list of device model IDs and their statuses, and only active devices (`is_active` = `True` in the response of  [/tool/device_model/](https://ads.tiktok.com/marketing_api/docs?id=1737172880570369)) can be used to create ads.")
    public List<String> getDeviceModelIds() {
        return this.deviceModelIds;
    }

    public void setDeviceModelIds(List<String> deviceModelIds) {
        this.deviceModelIds = deviceModelIds;
    }

    public AdgroupUpdateBody devicePriceRanges(List<Integer> devicePriceRanges) {
        this.devicePriceRanges = devicePriceRanges;
        return this;
    }

    public AdgroupUpdateBody addDevicePriceRangesItem(Integer devicePriceRangesItem) {
        if (this.devicePriceRanges == null) {
            this.devicePriceRanges = new ArrayList<Integer>();
        }
        this.devicePriceRanges.add(devicePriceRangesItem);
        return this;
    }

    @Schema(description="Targeting device price range. 10000 means 1000+. The numbers must be in multiples of 50. The upper limit you set will be added by 50 and the resulting new number will be used as the actual upper limit for device targeting. The actual upper limit is shown in the ad group settings in TikTok Ads Manager. If you set and get the price range of [0, 250], it actually means [0, 300].")
    public List<Integer> getDevicePriceRanges() {
        return this.devicePriceRanges;
    }

    public void setDevicePriceRanges(List<Integer> devicePriceRanges) {
        this.devicePriceRanges = devicePriceRanges;
    }

    public AdgroupUpdateBody excludedAudienceIds(List<String> excludedAudienceIds) {
        this.excludedAudienceIds = excludedAudienceIds;
        return this;
    }

    public AdgroupUpdateBody addExcludedAudienceIdsItem(String excludedAudienceIdsItem) {
        if (this.excludedAudienceIds == null) {
            this.excludedAudienceIds = new ArrayList<String>();
        }
        this.excludedAudienceIds.add(excludedAudienceIdsItem);
        return this;
    }

    @Schema(description="List of audience ID to be excluded. You can get audience IDs by using the [/dmp/custom_audience/list/](https://ads.tiktok.com/marketing_api/docs?id=1739940506015746) endpoint.")
    public List<String> getExcludedAudienceIds() {
        return this.excludedAudienceIds;
    }

    public void setExcludedAudienceIds(List<String> excludedAudienceIds) {
        this.excludedAudienceIds = excludedAudienceIds;
    }

    public AdgroupUpdateBody excludedCustomActions(OpenApiv13adgroupcreateExcludedCustomActions excludedCustomActions) {
        this.excludedCustomActions = excludedCustomActions;
        return this;
    }

    @Schema(description="")
    public OpenApiv13adgroupcreateExcludedCustomActions getExcludedCustomActions() {
        return this.excludedCustomActions;
    }

    public void setExcludedCustomActions(OpenApiv13adgroupcreateExcludedCustomActions excludedCustomActions) {
        this.excludedCustomActions = excludedCustomActions;
    }

    public AdgroupUpdateBody excludedPangleAudiencePackageIds(List<String> excludedPangleAudiencePackageIds) {
        this.excludedPangleAudiencePackageIds = excludedPangleAudiencePackageIds;
        return this;
    }

    public AdgroupUpdateBody addExcludedPangleAudiencePackageIdsItem(String excludedPangleAudiencePackageIdsItem) {
        if (this.excludedPangleAudiencePackageIds == null) {
            this.excludedPangleAudiencePackageIds = new ArrayList<String>();
        }
        this.excludedPangleAudiencePackageIds.add(excludedPangleAudiencePackageIdsItem);
        return this;
    }

    @Schema(description="IDs of the Pangle audiences that you want to exclude. Valid only for Pangle placement. You can get audience IDs (`package_id`) by using the [/pangle_audience_package/get/](https://ads.tiktok.com/marketing_api/docs?id=1740040177229826) endpoint. You need to set `bind_type` to `EXCLUDE`. Do not specify this field and `included_pangle_audience_package_ids` at the same time.")
    public List<String> getExcludedPangleAudiencePackageIds() {
        return this.excludedPangleAudiencePackageIds;
    }

    public void setExcludedPangleAudiencePackageIds(List<String> excludedPangleAudiencePackageIds) {
        this.excludedPangleAudiencePackageIds = excludedPangleAudiencePackageIds;
    }

    public AdgroupUpdateBody frequency(Integer frequency) {
        this.frequency = frequency;
        return this;
    }

    @Schema(description="Frequency, together with `frequency_schedule`, controls how often people see your ad (only available for `REACH` ads). The below conditions should be both met-1 <= `frequency` <= `frequency_schedule` * 3 1 <= `frequency_schedule` <=7 For example, `frequency` = 2 & `frequency_schedule` = 3 means \"show ads no more than twice every 3 day\".")
    public Integer getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public AdgroupUpdateBody frequencySchedule(Integer frequencySchedule) {
        this.frequencySchedule = frequencySchedule;
        return this;
    }

    @Schema(description="Frequency_schedule`, together with `frequency`, controls how often people see your ad (only available for `REACH` ads). See `frequency` fields for more.")
    public Integer getFrequencySchedule() {
        return this.frequencySchedule;
    }

    public void setFrequencySchedule(Integer frequencySchedule) {
        this.frequencySchedule = frequencySchedule;
    }

    public AdgroupUpdateBody gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="Gender that you want to target. Enum values- `GENDER_FEMALE`,`GENDER_MALE`,`GENDER_UNLIMITED`")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public AdgroupUpdateBody householdIncome(List<String> householdIncome) {
        this.householdIncome = householdIncome;
        return this;
    }

    public AdgroupUpdateBody addHouseholdIncomeItem(String householdIncomeItem) {
        if (this.householdIncome == null) {
            this.householdIncome = new ArrayList<String>();
        }
        this.householdIncome.add(householdIncomeItem);
        return this;
    }

    @Schema(description="Household income that you want to target. Enum values- `TOP5`(Top 5% of ZIP codes), `TOP10`(Top 10% of ZIP codes), `TOP10_25`(Top 10% -25% of ZIP codes), `TOP25_50`(Top 25% - 50% of ZIP codes). Note-  It only supports the ad objectives for Auction ads. See [Advertising objectives](https://ads.tiktok.com/marketing_api/docs?id=1737585562434561) for details. It  is only applicable the TikTok Placement in US. If you have specified `special_industries` at the campaign level, then you cannot use the field here. `household_income` is an allowlist-only feature that is only available in US. If you would like to access it, please contact your TikTok representative.")
    public List<String> getHouseholdIncome() {
        return this.householdIncome;
    }

    public void setHouseholdIncome(List<String> householdIncome) {
        this.householdIncome = householdIncome;
    }

    public AdgroupUpdateBody identityId(String identityId) {
        this.identityId = identityId;
        return this;
    }

    @Schema(description="Identity ID. Required and only valid when `objective_type` is `SHOP_PURCHASES` or `PRODUCT_SALES`.")
    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public AdgroupUpdateBody identityType(String identityType) {
        this.identityType = identityType;
        return this;
    }

    @Schema(description="Identity type. Enum values- `AUTH_CODE` (Authorized Post User), `TT_USER` (TikTok Business Account User), `BC_AUTH_TT`(The TikTok account that a Business Center is authorized to access). Required and only valid when `objective_type` is `SHOP_PURCHASES` or `PRODUCT_SALES`. See [Identities](https://ads.tiktok.com/marketing_api/docs?id=1738958351620097) for details.")
    public String getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public AdgroupUpdateBody identityAuthorizedBcId(String identityAuthorizedBcId) {
        this.identityAuthorizedBcId = identityAuthorizedBcId;
        return this;
    }

    @Schema(description="ID of the Business Center that a TikTok Account User in Business Center identity is associated with. Required when `identity_type` is `BC_AUTH_TT`.")
    public String getIdentityAuthorizedBcId() {
        return this.identityAuthorizedBcId;
    }

    public void setIdentityAuthorizedBcId(String identityAuthorizedBcId) {
        this.identityAuthorizedBcId = identityAuthorizedBcId;
    }

    public AdgroupUpdateBody includedCustomActions(OpenApiv13adgroupcreateIncludedCustomActions includedCustomActions) {
        this.includedCustomActions = includedCustomActions;
        return this;
    }

    @Schema(description="")
    public OpenApiv13adgroupcreateIncludedCustomActions getIncludedCustomActions() {
        return this.includedCustomActions;
    }

    public void setIncludedCustomActions(OpenApiv13adgroupcreateIncludedCustomActions includedCustomActions) {
        this.includedCustomActions = includedCustomActions;
    }

    public AdgroupUpdateBody includedPangleAudiencePackageIds(List<String> includedPangleAudiencePackageIds) {
        this.includedPangleAudiencePackageIds = includedPangleAudiencePackageIds;
        return this;
    }

    public AdgroupUpdateBody addIncludedPangleAudiencePackageIdsItem(String includedPangleAudiencePackageIdsItem) {
        if (this.includedPangleAudiencePackageIds == null) {
            this.includedPangleAudiencePackageIds = new ArrayList<String>();
        }
        this.includedPangleAudiencePackageIds.add(includedPangleAudiencePackageIdsItem);
        return this;
    }

    @Schema(description="IDs of the Pangle audiences that you want to include. Valid only for Pangle placement. You can get audience IDs (`package_id`) by using the [/pangle_audience_package/get/](https://ads.tiktok.com/marketing_api/docs?id=1740040177229826) endpoint. You need to set `bind_type` to `INCLUDE`.  Do not specify this field and `excluded_pangle_audience_package_ids` at the sa")
    public List<String> getIncludedPangleAudiencePackageIds() {
        return this.includedPangleAudiencePackageIds;
    }

    public void setIncludedPangleAudiencePackageIds(List<String> includedPangleAudiencePackageIds) {
        this.includedPangleAudiencePackageIds = includedPangleAudiencePackageIds;
    }

    public AdgroupUpdateBody interestCategoryIds(List<String> interestCategoryIds) {
        this.interestCategoryIds = interestCategoryIds;
        return this;
    }

    public AdgroupUpdateBody addInterestCategoryIdsItem(String interestCategoryIdsItem) {
        if (this.interestCategoryIds == null) {
            this.interestCategoryIds = new ArrayList<String>();
        }
        this.interestCategoryIds.add(interestCategoryIdsItem);
        return this;
    }

    @Schema(description="Interest classification. If the interest is specified, users that do not meet interest target will be excluded during delivery. Do not specify if you wish to target everyone. Use [/tool/target_recommend_tags/](https://ads.tiktok.com/marketing_api/docs?id=1736275204260866) to get a list of recommended interest categories based on your targeting regions and your industries. Use [/tool/interest_category/](https://ads.tiktok.com/marketing_api/docs?id=1737174348712961) endpoint to get the complete list of interest categories.")
    public List<String> getInterestCategoryIds() {
        return this.interestCategoryIds;
    }

    public void setInterestCategoryIds(List<String> interestCategoryIds) {
        this.interestCategoryIds = interestCategoryIds;
    }

    public AdgroupUpdateBody interestKeywordIds(List<String> interestKeywordIds) {
        this.interestKeywordIds = interestKeywordIds;
        return this;
    }

    public AdgroupUpdateBody addInterestKeywordIdsItem(String interestKeywordIdsItem) {
        if (this.interestKeywordIds == null) {
            this.interestKeywordIds = new ArrayList<String>();
        }
        this.interestKeywordIds.add(interestKeywordIdsItem);
        return this;
    }

    @Schema(description="IDs of interest keywords that you want to use to target audience. You can get recommended interest keywords IDs by using the [/tool/interest_keyword/recommend/](https://ads.tiktok.com/marketing_api/docs?id=1737180852720642) endpoint.")
    public List<String> getInterestKeywordIds() {
        return this.interestKeywordIds;
    }

    public void setInterestKeywordIds(List<String> interestKeywordIds) {
        this.interestKeywordIds = interestKeywordIds;
    }

    public AdgroupUpdateBody interestKeywords(List<String> interestKeywords) {
        this.interestKeywords = interestKeywords;
        return this;
    }

    public AdgroupUpdateBody addInterestKeywordsItem(String interestKeywordsItem) {
        if (this.interestKeywords == null) {
            this.interestKeywords = new ArrayList<String>();
        }
        this.interestKeywords.add(interestKeywordsItem);
        return this;
    }

    @Schema(description=" Interest Keywords")
    public List<String> getInterestKeywords() {
        return this.interestKeywords;
    }

    public void setInterestKeywords(List<String> interestKeywords) {
        this.interestKeywords = interestKeywords;
    }

    public AdgroupUpdateBody ios14Targeting(String ios14Targeting) {
        this.ios14Targeting = ios14Targeting;
        return this;
    }

    @Schema(description="The iOS devices that you want to target. When `campaign_type` of the campaign is set as `IOS14_CAMPAIGN`,  `ios14_targeting` is required and must be specified as `IOS14_PLUS`. Enum values-`UNSET`- Devices with iOS 14.4 or earlier versions. The default value for ad groups that were created before the introduction of this field.`IOS14_MINUS`- Devices with versions earlier than iOS 14.0, which are not affected by the iOS 14 privacy update. This is the default value for ad groups that are created after the introduction of this field.`IOS14_PLUS`- Devices with iOS 14.5 and above. The iOS 14 privacy update has been enforced in this group of devices. Specify this value if you want to create an iOS 14 campaign.  Each iOS 14 campaign can have up to 2 active ad groups. <br data-tomark-pass> If `IOS14_PLUS` is specified, this field cannot be updated. If `IOS14_PLUS` is specified for this field, the system will verify if related fields meet the requirements for an iOS 14 campaign. The following fields will be checked. `app_id`- It must not be an ID of an Android app.`operating_systems`- It must not be `ANDROID` or `PC`.`min_ios_version`- You must specify a value for this field, and the the value must not contradict with the selection for `ios14_targeting`.`min_android_version`- Must not be specified.`optimization_goal`- Can only be set to `IN_APP_EVENT`, `INSTALL`, or `CLICK`.`shopping_ads_retargeting_type`- Must not be specified.`shopping_ads_retargeting_actions_days`- Must not be specified. `conversion_window`- Must not be specified.On the Ad level, `deeplink_type` must not be set to `DEFERRED_DEEPLINK`.")
    public String getIos14Targeting() {
        return this.ios14Targeting;
    }

    public void setIos14Targeting(String ios14Targeting) {
        this.ios14Targeting = ios14Targeting;
    }

    public AdgroupUpdateBody isHfss(Boolean isHfss) {
        this.isHfss = isHfss;
        return this;
    }

    @Schema(description="Whether the promoted content is HFSS foods (foods that are high in fat, salt, or sugar).")
    public Boolean isIsHfss() {
        return this.isHfss;
    }

    public void setIsHfss(Boolean isHfss) {
        this.isHfss = isHfss;
    }

    public AdgroupUpdateBody languages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    public AdgroupUpdateBody addLanguagesItem(String languagesItem) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.add(languagesItem);
        return this;
    }

    @Schema(description="Codes of the languages that you want to target. For the list of languages codes supported, see [Enumeration - Language Code](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).You can get language codes via [/tool/language/](https://ads.tiktok.com/marketing_api/docs?id=1737188554152962), and if you don't want to limit the languages you target, assign an empty value to this field or do not pass in this field.")
    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public AdgroupUpdateBody locationIds(List<String> locationIds) {
        this.locationIds = locationIds;
        return this;
    }

    public AdgroupUpdateBody addLocationIdsItem(String locationIdsItem) {
        if (this.locationIds == null) {
            this.locationIds = new ArrayList<String>();
        }
        this.locationIds.add(locationIdsItem);
        return this;
    }

    @Schema(description="IDs of the locations that you want to target. To get the available locations and corresponding IDs based on your placement and objective, use the [/tool/region/](https://ads.tiktok.com/marketing_api/docs?id=1737189539571713) endpoint. To get the list of location IDs, see [Location IDs](https://ads.tiktok.com/marketing_api/docs?id=1739311040498689).")
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    public void setLocationIds(List<String> locationIds) {
        this.locationIds = locationIds;
    }

    public AdgroupUpdateBody minAndroidVersion(String minAndroidVersion) {
        this.minAndroidVersion = minAndroidVersion;
        return this;
    }

    @Schema(description="Minimum device Android version. For enum values, see [Enumeration - Minimum Android Version](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public String getMinAndroidVersion() {
        return this.minAndroidVersion;
    }

    public void setMinAndroidVersion(String minAndroidVersion) {
        this.minAndroidVersion = minAndroidVersion;
    }

    public AdgroupUpdateBody minIosVersion(String minIosVersion) {
        this.minIosVersion = minIosVersion;
        return this;
    }

    @Schema(description="Minimum iOS version. For enum values, see [Enumeration - Minimum iOS Version](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138). This field is required when `ios14_targeting` is specified.")
    public String getMinIosVersion() {
        return this.minIosVersion;
    }

    public void setMinIosVersion(String minIosVersion) {
        this.minIosVersion = minIosVersion;
    }

    public AdgroupUpdateBody networkTypes(List<String> networkTypes) {
        this.networkTypes = networkTypes;
        return this;
    }

    public AdgroupUpdateBody addNetworkTypesItem(String networkTypesItem) {
        if (this.networkTypes == null) {
            this.networkTypes = new ArrayList<String>();
        }
        this.networkTypes.add(networkTypesItem);
        return this;
    }

    @Schema(description="Device connection types that you want to target. Default- `unlimited`. For enum values, see [Enumeration - Connection Type](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public List<String> getNetworkTypes() {
        return this.networkTypes;
    }

    public void setNetworkTypes(List<String> networkTypes) {
        this.networkTypes = networkTypes;
    }

    public AdgroupUpdateBody nextDayRetention(BigDecimal nextDayRetention) {
        this.nextDayRetention = nextDayRetention;
        return this;
    }

    @Schema(description="Day 2 retention ratio. Formula- `next_day_retention` = `conversion_bid_price`/`deep_cpa_bid`. Value range is (0,1]. Only valid when `placements` is `PLACEMENT_PANGLE` and `secondary_optimization_event` is `NEXT_DAY_OPEN`. If you want to use this field, please pass in `conversion_bid_price`, `deep_cpa_bid`, and `next_day_retention` at the same time, and make sure the value of them meets the calculation formula. Otherwise there might be unexpected errors.")
    public BigDecimal getNextDayRetention() {
        return this.nextDayRetention;
    }

    public void setNextDayRetention(BigDecimal nextDayRetention) {
        this.nextDayRetention = nextDayRetention;
    }

    public AdgroupUpdateBody operatingSystems(List<String> operatingSystems) {
        this.operatingSystems = operatingSystems;
        return this;
    }

    public AdgroupUpdateBody addOperatingSystemsItem(String operatingSystemsItem) {
        if (this.operatingSystems == null) {
            this.operatingSystems = new ArrayList<String>();
        }
        this.operatingSystems.add(operatingSystemsItem);
        return this;
    }

    @Schema(description="Device operating systems that you want to target. Only one value is allowed.  Enum values- `ANDROID`, `IOS`. This field is required in two scenarios- `objective_type` = `APP_INSTALL``objective`=`TRAFFIC` and `optimization_event` = `APP_IOS` or `APP_ANDROID`")
    public List<String> getOperatingSystems() {
        return this.operatingSystems;
    }

    public void setOperatingSystems(List<String> operatingSystems) {
        this.operatingSystems = operatingSystems;
    }

    public AdgroupUpdateBody pacing(String pacing) {
        this.pacing = pacing;
        return this;
    }

    @Schema(description="You can choose between `PACING_MODE_SMOOTH` and `PACING_MODE_FAST`. For `PACING_MODE_SMOOTH`, the budget is allocated evenly within the scheduled time. `PACING_MODE_FAST` would consume budget and produce results as soon as possible. When Campaign Budget Optimization (`budget_optimize_on`) is on, your setting will be ignored and it will be set as `PACING_MODE_SMOOTH`. Otherwise, this field is required.")
    public String getPacing() {
        return this.pacing;
    }

    public void setPacing(String pacing) {
        this.pacing = pacing;
    }

    public AdgroupUpdateBody purchaseIntentionKeywordIds(List<String> purchaseIntentionKeywordIds) {
        this.purchaseIntentionKeywordIds = purchaseIntentionKeywordIds;
        return this;
    }

    public AdgroupUpdateBody addPurchaseIntentionKeywordIdsItem(String purchaseIntentionKeywordIdsItem) {
        if (this.purchaseIntentionKeywordIds == null) {
            this.purchaseIntentionKeywordIds = new ArrayList<String>();
        }
        this.purchaseIntentionKeywordIds.add(purchaseIntentionKeywordIdsItem);
        return this;
    }

    @Schema(description="IDs of purchase intention keywords that you want to use to target audiences with an interest in purchases related to a content category. To get purchase intention keyword IDs, you need to set `audience_type` as `PURCHASE_INTENTION` when calling [/tool/interest_keyword/recommend/](https://ads.tiktok.com/marketing_api/docs?id=1737180852720642) and then get purchase intention keyword IDs from `keyword_id` in the response. Note-Do not pass in `purchase_intention_keyword_ids` and `interest_keyword_ids` at the same time. Otherwise, keyword conflict will occur.`purchase_intention_keyword_ids` only supports auctions ads with the corresponding advertising objective(`objective_type`) as App promotion (`APP_PROMOTION`), Conversions (`CONVERSIONS` ) \uff0cor Product sales (`PRODUCT_SALES` when the corresponding `promotion_type` = `APP_ANDROID`, `APP_IOS`, or `WEBSITE`\uff09, and the placement setting should include TikTok.")
    public List<String> getPurchaseIntentionKeywordIds() {
        return this.purchaseIntentionKeywordIds;
    }

    public void setPurchaseIntentionKeywordIds(List<String> purchaseIntentionKeywordIds) {
        this.purchaseIntentionKeywordIds = purchaseIntentionKeywordIds;
    }

    public AdgroupUpdateBody roasBid(BigDecimal roasBid) {
        this.roasBid = roasBid;
        return this;
    }

    @Schema(description="ROAS goal for Value Optimization. Required when `deep_bid_type` is `VO_MIN_ROAS`.")
    public BigDecimal getRoasBid() {
        return this.roasBid;
    }

    public void setRoasBid(BigDecimal roasBid) {
        this.roasBid = roasBid;
    }

    public AdgroupUpdateBody scheduleEndTime(String scheduleEndTime) {
        this.scheduleEndTime = scheduleEndTime;
        return this;
    }

    @Schema(description="Schedule end time (UTC+0), in the format of \"YYYY-MM-DD HH-MM-SS\". This field is required when `schedule_type` is `SCHEDULE_START_END` or `budget_mode` is `BUDGET_MODE_TOTAL`")
    public String getScheduleEndTime() {
        return this.scheduleEndTime;
    }

    public void setScheduleEndTime(String scheduleEndTime) {
        this.scheduleEndTime = scheduleEndTime;
    }

    public AdgroupUpdateBody scheduleStartTime(String scheduleStartTime) {
        this.scheduleStartTime = scheduleStartTime;
        return this;
    }

    @Schema(description="Schedule start time (UTC+0), in the format of \"YYYY-MM-DD HH-MM-SS\". The start time can be up to 12 hours earlier than the current time.")
    public String getScheduleStartTime() {
        return this.scheduleStartTime;
    }

    public void setScheduleStartTime(String scheduleStartTime) {
        this.scheduleStartTime = scheduleStartTime;
    }

    public AdgroupUpdateBody scheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    @Schema(description="The schedule type can be either `SCHEDULE_START_END` or `SCHEDULE_FROM_NOW`. If you choose `SCHEDULE_START_END`, you need to specify a start time and an end time. If you choose `SCHEDULE_FROM_NOW`, you only need to specify a start time and the end time will be automatically set to 10 years later than the start time. If `budget_mode` is `BUDGET_MODE_TOTAL`, this field must be set to `SCHEDULE_START_END`.")
    public String getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public AdgroupUpdateBody secondaryOptimizationEvent(String secondaryOptimizationEvent) {
        this.secondaryOptimizationEvent = secondaryOptimizationEvent;
        return this;
    }

    @Schema(description="The secondary goal when optimization goal (`optimization_goal`) is Install (`INSTALL`) or Value (`VALUE`). For enum values, see [Conversion events - Secondary-goal events](https://ads.tiktok.com/marketing_api/docs?id=1739361474981889).")
    public String getSecondaryOptimizationEvent() {
        return this.secondaryOptimizationEvent;
    }

    public void setSecondaryOptimizationEvent(String secondaryOptimizationEvent) {
        this.secondaryOptimizationEvent = secondaryOptimizationEvent;
    }

    public AdgroupUpdateBody shoppingAdsRetargetingActionsDays(Integer shoppingAdsRetargetingActionsDays) {
        this.shoppingAdsRetargetingActionsDays = shoppingAdsRetargetingActionsDays;
        return this;
    }

    @Schema(description="The valid time range for the specified audience action. Audiences who have completed the specified action within the time range will be retargeted by the shopping ads. Required when `shopping_ads_retargeting_type` is `LAB1` or `LAB2`.")
    public Integer getShoppingAdsRetargetingActionsDays() {
        return this.shoppingAdsRetargetingActionsDays;
    }

    public void setShoppingAdsRetargetingActionsDays(Integer shoppingAdsRetargetingActionsDays) {
        this.shoppingAdsRetargetingActionsDays = shoppingAdsRetargetingActionsDays;
    }

    public AdgroupUpdateBody shoppingAdsRetargetingType(String shoppingAdsRetargetingType) {
        this.shoppingAdsRetargetingType = shoppingAdsRetargetingType;
        return this;
    }

    @Schema(description="Valid when the campaign `objective_type` is `PRODUCT_SALES`. The retargeting type of shopping ads. Enum values- `LAB1`- Retargeting audiences who viewed products or added products to cart but didn't purchase products. `LAB2`- Retargeting audiences who added products to cart but didn't purchase products. `LAB3`- Retargeting audiences using custom combination. `OFF`- No retargeting.")
    public String getShoppingAdsRetargetingType() {
        return this.shoppingAdsRetargetingType;
    }

    public void setShoppingAdsRetargetingType(String shoppingAdsRetargetingType) {
        this.shoppingAdsRetargetingType = shoppingAdsRetargetingType;
    }

    public AdgroupUpdateBody spendingPower(String spendingPower) {
        this.spendingPower = spendingPower;
        return this;
    }

    @Schema(description="Spending power that you want to target. Enum values- `ALL`, `HIGH`.   If it is set to `HIGH`, you can target high spending users who typically spend more on purchases than average users.  Note-  It is only applicable to the TikTok placement. Your `placements` field must contain the enum value of `PLACEMENT_TIKTOK` . It only supports the ad objectives for Auction ads. See [Advertising objectives](https://ads.tiktok.com/marketing_api/docs?id=1737585562434561) for details.  It cannot be used with special industries targeting at the same time. If you have specified `special_industries` at the campaign level, then you cannot use the field here. When `auto_targeting_enabled` is `True` at the ad group level, then `spending_power`  will be automatically set to `ALL`.  Enum values are `ALL` and `HIGH`. Even if you don't specify this field,  then we will still return `ALL` spending power users.")
    public String getSpendingPower() {
        return this.spendingPower;
    }

    public void setSpendingPower(String spendingPower) {
        this.spendingPower = spendingPower;
    }

    public AdgroupUpdateBody targetingExpansion(OpenApiv13adgroupcreateTargetingExpansion targetingExpansion) {
        this.targetingExpansion = targetingExpansion;
        return this;
    }

    @Schema(description="")
    public OpenApiv13adgroupcreateTargetingExpansion getTargetingExpansion() {
        return this.targetingExpansion;
    }

    public void setTargetingExpansion(OpenApiv13adgroupcreateTargetingExpansion targetingExpansion) {
        this.targetingExpansion = targetingExpansion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdgroupUpdateBody adgroupUpdateBody = (AdgroupUpdateBody)o;
        return Objects.equals(this.actions, adgroupUpdateBody.actions) && Objects.equals(this.adgroupId, adgroupUpdateBody.adgroupId) && Objects.equals(this.adgroupName, adgroupUpdateBody.adgroupName) && Objects.equals(this.advertiserId, adgroupUpdateBody.advertiserId) && Objects.equals(this.ageGroups, adgroupUpdateBody.ageGroups) && Objects.equals(this.appDownloadUrl, adgroupUpdateBody.appDownloadUrl) && Objects.equals(this.appId, adgroupUpdateBody.appId) && Objects.equals(this.audienceIds, adgroupUpdateBody.audienceIds) && Objects.equals(this.audienceRule, adgroupUpdateBody.audienceRule) && Objects.equals(this.audienceType, adgroupUpdateBody.audienceType) && Objects.equals(this.autoTargetingEnabled, adgroupUpdateBody.autoTargetingEnabled) && Objects.equals(this.bidPrice, adgroupUpdateBody.bidPrice) && Objects.equals(this.bidType, adgroupUpdateBody.bidType) && Objects.equals(this.billingEvent, adgroupUpdateBody.billingEvent) && Objects.equals(this.blockedPangleAppIds, adgroupUpdateBody.blockedPangleAppIds) && Objects.equals(this.brandSafetyType, adgroupUpdateBody.brandSafetyType) && Objects.equals(this.budget, adgroupUpdateBody.budget) && Objects.equals(this.carrierIds, adgroupUpdateBody.carrierIds) && Objects.equals(this.catalogAuthorizedBcId, adgroupUpdateBody.catalogAuthorizedBcId) && Objects.equals(this.commentDisabled, adgroupUpdateBody.commentDisabled) && Objects.equals(this.contextualTagIds, adgroupUpdateBody.contextualTagIds) && Objects.equals(this.conversionBidPrice, adgroupUpdateBody.conversionBidPrice) && Objects.equals(this.conversionId, adgroupUpdateBody.conversionId) && Objects.equals(this.creativeMaterialMode, adgroupUpdateBody.creativeMaterialMode) && Objects.equals(this.dayparting, adgroupUpdateBody.dayparting) && Objects.equals(this.deepBidType, adgroupUpdateBody.deepBidType) && Objects.equals(this.deepCpaBid, adgroupUpdateBody.deepCpaBid) && Objects.equals(this.deviceModelIds, adgroupUpdateBody.deviceModelIds) && Objects.equals(this.devicePriceRanges, adgroupUpdateBody.devicePriceRanges) && Objects.equals(this.excludedAudienceIds, adgroupUpdateBody.excludedAudienceIds) && Objects.equals(this.excludedCustomActions, adgroupUpdateBody.excludedCustomActions) && Objects.equals(this.excludedPangleAudiencePackageIds, adgroupUpdateBody.excludedPangleAudiencePackageIds) && Objects.equals(this.frequency, adgroupUpdateBody.frequency) && Objects.equals(this.frequencySchedule, adgroupUpdateBody.frequencySchedule) && Objects.equals(this.gender, adgroupUpdateBody.gender) && Objects.equals(this.householdIncome, adgroupUpdateBody.householdIncome) && Objects.equals(this.identityId, adgroupUpdateBody.identityId) && Objects.equals(this.identityType, adgroupUpdateBody.identityType) && Objects.equals(this.identityAuthorizedBcId, adgroupUpdateBody.identityAuthorizedBcId) && Objects.equals(this.includedCustomActions, adgroupUpdateBody.includedCustomActions) && Objects.equals(this.includedPangleAudiencePackageIds, adgroupUpdateBody.includedPangleAudiencePackageIds) && Objects.equals(this.interestCategoryIds, adgroupUpdateBody.interestCategoryIds) && Objects.equals(this.interestKeywordIds, adgroupUpdateBody.interestKeywordIds) && Objects.equals(this.interestKeywords, adgroupUpdateBody.interestKeywords) && Objects.equals(this.ios14Targeting, adgroupUpdateBody.ios14Targeting) && Objects.equals(this.isHfss, adgroupUpdateBody.isHfss) && Objects.equals(this.languages, adgroupUpdateBody.languages) && Objects.equals(this.locationIds, adgroupUpdateBody.locationIds) && Objects.equals(this.minAndroidVersion, adgroupUpdateBody.minAndroidVersion) && Objects.equals(this.minIosVersion, adgroupUpdateBody.minIosVersion) && Objects.equals(this.networkTypes, adgroupUpdateBody.networkTypes) && Objects.equals(this.nextDayRetention, adgroupUpdateBody.nextDayRetention) && Objects.equals(this.operatingSystems, adgroupUpdateBody.operatingSystems) && Objects.equals(this.pacing, adgroupUpdateBody.pacing) && Objects.equals(this.purchaseIntentionKeywordIds, adgroupUpdateBody.purchaseIntentionKeywordIds) && Objects.equals(this.roasBid, adgroupUpdateBody.roasBid) && Objects.equals(this.scheduleEndTime, adgroupUpdateBody.scheduleEndTime) && Objects.equals(this.scheduleStartTime, adgroupUpdateBody.scheduleStartTime) && Objects.equals(this.scheduleType, adgroupUpdateBody.scheduleType) && Objects.equals(this.secondaryOptimizationEvent, adgroupUpdateBody.secondaryOptimizationEvent) && Objects.equals(this.shoppingAdsRetargetingActionsDays, adgroupUpdateBody.shoppingAdsRetargetingActionsDays) && Objects.equals(this.shoppingAdsRetargetingType, adgroupUpdateBody.shoppingAdsRetargetingType) && Objects.equals(this.spendingPower, adgroupUpdateBody.spendingPower) && Objects.equals(this.targetingExpansion, adgroupUpdateBody.targetingExpansion);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.adgroupId, this.adgroupName, this.advertiserId, this.ageGroups, this.appDownloadUrl, this.appId, this.audienceIds, this.audienceRule, this.audienceType, this.autoTargetingEnabled, this.bidPrice, this.bidType, this.billingEvent, this.blockedPangleAppIds, this.brandSafetyType, this.budget, this.carrierIds, this.catalogAuthorizedBcId, this.commentDisabled, this.contextualTagIds, this.conversionBidPrice, this.conversionId, this.creativeMaterialMode, this.dayparting, this.deepBidType, this.deepCpaBid, this.deviceModelIds, this.devicePriceRanges, this.excludedAudienceIds, this.excludedCustomActions, this.excludedPangleAudiencePackageIds, this.frequency, this.frequencySchedule, this.gender, this.householdIncome, this.identityId, this.identityType, this.identityAuthorizedBcId, this.includedCustomActions, this.includedPangleAudiencePackageIds, this.interestCategoryIds, this.interestKeywordIds, this.interestKeywords, this.ios14Targeting, this.isHfss, this.languages, this.locationIds, this.minAndroidVersion, this.minIosVersion, this.networkTypes, this.nextDayRetention, this.operatingSystems, this.pacing, this.purchaseIntentionKeywordIds, this.roasBid, this.scheduleEndTime, this.scheduleStartTime, this.scheduleType, this.secondaryOptimizationEvent, this.shoppingAdsRetargetingActionsDays, this.shoppingAdsRetargetingType, this.spendingPower, this.targetingExpansion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdgroupUpdateBody {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    adgroupId: ").append(this.toIndentedString(this.adgroupId)).append("\n");
        sb.append("    adgroupName: ").append(this.toIndentedString(this.adgroupName)).append("\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    ageGroups: ").append(this.toIndentedString(this.ageGroups)).append("\n");
        sb.append("    appDownloadUrl: ").append(this.toIndentedString(this.appDownloadUrl)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    audienceIds: ").append(this.toIndentedString(this.audienceIds)).append("\n");
        sb.append("    audienceRule: ").append(this.toIndentedString(this.audienceRule)).append("\n");
        sb.append("    audienceType: ").append(this.toIndentedString(this.audienceType)).append("\n");
        sb.append("    autoTargetingEnabled: ").append(this.toIndentedString(this.autoTargetingEnabled)).append("\n");
        sb.append("    bidPrice: ").append(this.toIndentedString(this.bidPrice)).append("\n");
        sb.append("    bidType: ").append(this.toIndentedString(this.bidType)).append("\n");
        sb.append("    billingEvent: ").append(this.toIndentedString(this.billingEvent)).append("\n");
        sb.append("    blockedPangleAppIds: ").append(this.toIndentedString(this.blockedPangleAppIds)).append("\n");
        sb.append("    brandSafetyType: ").append(this.toIndentedString(this.brandSafetyType)).append("\n");
        sb.append("    budget: ").append(this.toIndentedString(this.budget)).append("\n");
        sb.append("    carrierIds: ").append(this.toIndentedString(this.carrierIds)).append("\n");
        sb.append("    catalogAuthorizedBcId: ").append(this.toIndentedString(this.catalogAuthorizedBcId)).append("\n");
        sb.append("    commentDisabled: ").append(this.toIndentedString(this.commentDisabled)).append("\n");
        sb.append("    contextualTagIds: ").append(this.toIndentedString(this.contextualTagIds)).append("\n");
        sb.append("    conversionBidPrice: ").append(this.toIndentedString(this.conversionBidPrice)).append("\n");
        sb.append("    conversionId: ").append(this.toIndentedString(this.conversionId)).append("\n");
        sb.append("    creativeMaterialMode: ").append(this.toIndentedString(this.creativeMaterialMode)).append("\n");
        sb.append("    dayparting: ").append(this.toIndentedString(this.dayparting)).append("\n");
        sb.append("    deepBidType: ").append(this.toIndentedString(this.deepBidType)).append("\n");
        sb.append("    deepCpaBid: ").append(this.toIndentedString(this.deepCpaBid)).append("\n");
        sb.append("    deviceModelIds: ").append(this.toIndentedString(this.deviceModelIds)).append("\n");
        sb.append("    devicePriceRanges: ").append(this.toIndentedString(this.devicePriceRanges)).append("\n");
        sb.append("    excludedAudienceIds: ").append(this.toIndentedString(this.excludedAudienceIds)).append("\n");
        sb.append("    excludedCustomActions: ").append(this.toIndentedString(this.excludedCustomActions)).append("\n");
        sb.append("    excludedPangleAudiencePackageIds: ").append(this.toIndentedString(this.excludedPangleAudiencePackageIds)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    frequencySchedule: ").append(this.toIndentedString(this.frequencySchedule)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("    householdIncome: ").append(this.toIndentedString(this.householdIncome)).append("\n");
        sb.append("    identityId: ").append(this.toIndentedString(this.identityId)).append("\n");
        sb.append("    identityType: ").append(this.toIndentedString(this.identityType)).append("\n");
        sb.append("    identityAuthorizedBcId: ").append(this.toIndentedString(this.identityAuthorizedBcId)).append("\n");
        sb.append("    includedCustomActions: ").append(this.toIndentedString(this.includedCustomActions)).append("\n");
        sb.append("    includedPangleAudiencePackageIds: ").append(this.toIndentedString(this.includedPangleAudiencePackageIds)).append("\n");
        sb.append("    interestCategoryIds: ").append(this.toIndentedString(this.interestCategoryIds)).append("\n");
        sb.append("    interestKeywordIds: ").append(this.toIndentedString(this.interestKeywordIds)).append("\n");
        sb.append("    interestKeywords: ").append(this.toIndentedString(this.interestKeywords)).append("\n");
        sb.append("    ios14Targeting: ").append(this.toIndentedString(this.ios14Targeting)).append("\n");
        sb.append("    isHfss: ").append(this.toIndentedString(this.isHfss)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    locationIds: ").append(this.toIndentedString(this.locationIds)).append("\n");
        sb.append("    minAndroidVersion: ").append(this.toIndentedString(this.minAndroidVersion)).append("\n");
        sb.append("    minIosVersion: ").append(this.toIndentedString(this.minIosVersion)).append("\n");
        sb.append("    networkTypes: ").append(this.toIndentedString(this.networkTypes)).append("\n");
        sb.append("    nextDayRetention: ").append(this.toIndentedString(this.nextDayRetention)).append("\n");
        sb.append("    operatingSystems: ").append(this.toIndentedString(this.operatingSystems)).append("\n");
        sb.append("    pacing: ").append(this.toIndentedString(this.pacing)).append("\n");
        sb.append("    purchaseIntentionKeywordIds: ").append(this.toIndentedString(this.purchaseIntentionKeywordIds)).append("\n");
        sb.append("    roasBid: ").append(this.toIndentedString(this.roasBid)).append("\n");
        sb.append("    scheduleEndTime: ").append(this.toIndentedString(this.scheduleEndTime)).append("\n");
        sb.append("    scheduleStartTime: ").append(this.toIndentedString(this.scheduleStartTime)).append("\n");
        sb.append("    scheduleType: ").append(this.toIndentedString(this.scheduleType)).append("\n");
        sb.append("    secondaryOptimizationEvent: ").append(this.toIndentedString(this.secondaryOptimizationEvent)).append("\n");
        sb.append("    shoppingAdsRetargetingActionsDays: ").append(this.toIndentedString(this.shoppingAdsRetargetingActionsDays)).append("\n");
        sb.append("    shoppingAdsRetargetingType: ").append(this.toIndentedString(this.shoppingAdsRetargetingType)).append("\n");
        sb.append("    spendingPower: ").append(this.toIndentedString(this.spendingPower)).append("\n");
        sb.append("    targetingExpansion: ").append(this.toIndentedString(this.targetingExpansion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

