/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import business_api_client.OpenApiv13advertiserupdateQualificationImages;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class AdvertiserUpdateBody {
    @JsonProperty(value="address")
    private String address = null;
    @JsonProperty(value="advertiser_id")
    private String advertiserId = null;
    @JsonProperty(value="advertiser_name")
    private String advertiserName = null;
    @JsonProperty(value="company")
    private String company = null;
    @JsonProperty(value="contact_email")
    private String contactEmail = null;
    @JsonProperty(value="contact_name")
    private String contactName = null;
    @JsonProperty(value="contact_number")
    private String contactNumber = null;
    @JsonProperty(value="license_image_id")
    private String licenseImageId = null;
    @JsonProperty(value="license_no")
    private String licenseNo = null;
    @JsonProperty(value="need_submit_certificate")
    private Boolean needSubmitCertificate = null;
    @JsonProperty(value="promotion_link")
    private String promotionLink = null;
    @JsonProperty(value="qualification_images")
    private OpenApiv13advertiserupdateQualificationImages qualificationImages = null;
    @JsonProperty(value="tax_map")
    private String taxMap = null;

    public AdvertiserUpdateBody address(String address) {
        this.address = address;
        return this;
    }

    @Schema(description="Business address that is shown on receipts")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AdvertiserUpdateBody advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Schema(required=true, description="Ad account ID")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public AdvertiserUpdateBody advertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
        return this;
    }

    @Schema(description="Ad account name")
    public String getAdvertiserName() {
        return this.advertiserName;
    }

    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
    }

    public AdvertiserUpdateBody company(String company) {
        this.company = company;
        return this;
    }

    @Schema(description="Company name")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public AdvertiserUpdateBody contactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    @Schema(description="Contact email")
    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public AdvertiserUpdateBody contactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    @Schema(description="Name of the contact person")
    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public AdvertiserUpdateBody contactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
        return this;
    }

    @Schema(description="Contact phone number")
    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public AdvertiserUpdateBody licenseImageId(String licenseImageId) {
        this.licenseImageId = licenseImageId;
        return this;
    }

    @Schema(description="Image ID (`image_id`) of the business license")
    public String getLicenseImageId() {
        return this.licenseImageId;
    }

    public void setLicenseImageId(String licenseImageId) {
        this.licenseImageId = licenseImageId;
    }

    public AdvertiserUpdateBody licenseNo(String licenseNo) {
        this.licenseNo = licenseNo;
        return this;
    }

    @Schema(description="Business license number. This is required for ad accounts that are registered in the Chinese mainland, Hong Kong, or in countries Brazil and Mexico")
    public String getLicenseNo() {
        return this.licenseNo;
    }

    public void setLicenseNo(String licenseNo) {
        this.licenseNo = licenseNo;
    }

    public AdvertiserUpdateBody needSubmitCertificate(Boolean needSubmitCertificate) {
        this.needSubmitCertificate = needSubmitCertificate;
        return this;
    }

    @Schema(description="Whether you want to submit the new certificate images for review")
    public Boolean isNeedSubmitCertificate() {
        return this.needSubmitCertificate;
    }

    public void setNeedSubmitCertificate(Boolean needSubmitCertificate) {
        this.needSubmitCertificate = needSubmitCertificate;
    }

    public AdvertiserUpdateBody promotionLink(String promotionLink) {
        this.promotionLink = promotionLink;
        return this;
    }

    @Schema(description="Promotion link. Length cannot exceed 255 characters")
    public String getPromotionLink() {
        return this.promotionLink;
    }

    public void setPromotionLink(String promotionLink) {
        this.promotionLink = promotionLink;
    }

    public AdvertiserUpdateBody qualificationImages(OpenApiv13advertiserupdateQualificationImages qualificationImages) {
        this.qualificationImages = qualificationImages;
        return this;
    }

    @Schema(description="")
    public OpenApiv13advertiserupdateQualificationImages getQualificationImages() {
        return this.qualificationImages;
    }

    public void setQualificationImages(OpenApiv13advertiserupdateQualificationImages qualificationImages) {
        this.qualificationImages = qualificationImages;
    }

    public AdvertiserUpdateBody taxMap(String taxMap) {
        this.taxMap = taxMap;
        return this;
    }

    @Schema(description="Billing and invoicing tax number. Different countries use different tax number fields. France uses `vat`, and Brazil uses `tax_id`")
    public String getTaxMap() {
        return this.taxMap;
    }

    public void setTaxMap(String taxMap) {
        this.taxMap = taxMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvertiserUpdateBody advertiserUpdateBody = (AdvertiserUpdateBody)o;
        return Objects.equals(this.address, advertiserUpdateBody.address) && Objects.equals(this.advertiserId, advertiserUpdateBody.advertiserId) && Objects.equals(this.advertiserName, advertiserUpdateBody.advertiserName) && Objects.equals(this.company, advertiserUpdateBody.company) && Objects.equals(this.contactEmail, advertiserUpdateBody.contactEmail) && Objects.equals(this.contactName, advertiserUpdateBody.contactName) && Objects.equals(this.contactNumber, advertiserUpdateBody.contactNumber) && Objects.equals(this.licenseImageId, advertiserUpdateBody.licenseImageId) && Objects.equals(this.licenseNo, advertiserUpdateBody.licenseNo) && Objects.equals(this.needSubmitCertificate, advertiserUpdateBody.needSubmitCertificate) && Objects.equals(this.promotionLink, advertiserUpdateBody.promotionLink) && Objects.equals(this.qualificationImages, advertiserUpdateBody.qualificationImages) && Objects.equals(this.taxMap, advertiserUpdateBody.taxMap);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.advertiserId, this.advertiserName, this.company, this.contactEmail, this.contactName, this.contactNumber, this.licenseImageId, this.licenseNo, this.needSubmitCertificate, this.promotionLink, this.qualificationImages, this.taxMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdvertiserUpdateBody {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    advertiserName: ").append(this.toIndentedString(this.advertiserName)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    contactEmail: ").append(this.toIndentedString(this.contactEmail)).append("\n");
        sb.append("    contactName: ").append(this.toIndentedString(this.contactName)).append("\n");
        sb.append("    contactNumber: ").append(this.toIndentedString(this.contactNumber)).append("\n");
        sb.append("    licenseImageId: ").append(this.toIndentedString(this.licenseImageId)).append("\n");
        sb.append("    licenseNo: ").append(this.toIndentedString(this.licenseNo)).append("\n");
        sb.append("    needSubmitCertificate: ").append(this.toIndentedString(this.needSubmitCertificate)).append("\n");
        sb.append("    promotionLink: ").append(this.toIndentedString(this.promotionLink)).append("\n");
        sb.append("    qualificationImages: ").append(this.toIndentedString(this.qualificationImages)).append("\n");
        sb.append("    taxMap: ").append(this.toIndentedString(this.taxMap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

