/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

public class BcTransferBody {
    @JsonProperty(value="advertiser_id")
    private String advertiserId = null;
    @JsonProperty(value="bc_id")
    private String bcId = null;
    @JsonProperty(value="cash_amount")
    private BigDecimal cashAmount = null;
    @JsonProperty(value="grant_amount")
    private BigDecimal grantAmount = null;
    @JsonProperty(value="transfer_type")
    private String transferType = null;

    public BcTransferBody advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Schema(required=true, description="Ad Account ID")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public BcTransferBody bcId(String bcId) {
        this.bcId = bcId;
        return this;
    }

    @Schema(required=true, description="Business Center ID")
    public String getBcId() {
        return this.bcId;
    }

    public void setBcId(String bcId) {
        this.bcId = bcId;
    }

    public BcTransferBody cashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
        return this;
    }

    @Schema(description="The amount to process. You need to specify either cash_amount or grant_amount. Rounded to two decimal places. Value range > 0.")
    public BigDecimal getCashAmount() {
        return this.cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public BcTransferBody grantAmount(BigDecimal grantAmount) {
        this.grantAmount = grantAmount;
        return this;
    }

    @Schema(description="Coupon/voucher amount. You need to specify either `cash_amount` or `grant_amount`. Rounded to two decimal places. Value range > 0")
    public BigDecimal getGrantAmount() {
        return this.grantAmount;
    }

    public void setGrantAmount(BigDecimal grantAmount) {
        this.grantAmount = grantAmount;
    }

    public BcTransferBody transferType(String transferType) {
        this.transferType = transferType;
        return this;
    }

    @Schema(required=true, description="How you'd like to process payments from an ad account. Enum values\uff1a`RECHARGE`(transfer), `REFUND`(deduction)")
    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BcTransferBody bcTransferBody = (BcTransferBody)o;
        return Objects.equals(this.advertiserId, bcTransferBody.advertiserId) && Objects.equals(this.bcId, bcTransferBody.bcId) && Objects.equals(this.cashAmount, bcTransferBody.cashAmount) && Objects.equals(this.grantAmount, bcTransferBody.grantAmount) && Objects.equals(this.transferType, bcTransferBody.transferType);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserId, this.bcId, this.cashAmount, this.grantAmount, this.transferType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BcTransferBody {\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    bcId: ").append(this.toIndentedString(this.bcId)).append("\n");
        sb.append("    cashAmount: ").append(this.toIndentedString(this.cashAmount)).append("\n");
        sb.append("    grantAmount: ").append(this.toIndentedString(this.grantAmount)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString(this.transferType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

