/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CampaignCreateBody {
    @JsonProperty(value="advertiser_id")
    private String advertiserId = null;
    @JsonProperty(value="app_id")
    private String appId = null;
    @JsonProperty(value="app_promotion_type")
    private String appPromotionType = null;
    @JsonProperty(value="budget")
    private Float budget = null;
    @JsonProperty(value="budget_mode")
    private String budgetMode = null;
    @JsonProperty(value="budget_optimize_on")
    private Boolean budgetOptimizeOn = null;
    @JsonProperty(value="campaign_name")
    private String campaignName = null;
    @JsonProperty(value="campaign_type")
    private String campaignType = null;
    @JsonProperty(value="objective_type")
    private String objectiveType = null;
    @JsonProperty(value="operation_status")
    private String operationStatus = null;
    @JsonProperty(value="optimization_goal")
    private String optimizationGoal = null;
    @JsonProperty(value="rf_campaign_type")
    private String rfCampaignType = null;
    @JsonProperty(value="special_industries")
    private List<String> specialIndustries = null;

    public CampaignCreateBody advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Schema(required=true, description="Advertiser ID")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public CampaignCreateBody appId(String appId) {
        this.appId = appId;
        return this;
    }

    @Schema(description="App ID, required when the campaign is an iOS 14 Dedicated Campaign (camapign_type=IOS14_CAMPAIGN) with the advertising objective (objective_type) as PRODUCT_SALES.")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public CampaignCreateBody appPromotionType(String appPromotionType) {
        this.appPromotionType = appPromotionType;
        return this;
    }

    @Schema(description="App promotion type. Required when `objective_type` is `APP_PROMOTION`. Enum values- `APP_INSTALL`, `APP_RETARGETING`. Note- `APP_INSTALL` can be used in an iOS14 Dedicated Campaign, while `APP_RETARGETING` cannot be used.")
    public String getAppPromotionType() {
        return this.appPromotionType;
    }

    public void setAppPromotionType(String appPromotionType) {
        this.appPromotionType = appPromotionType;
    }

    public CampaignCreateBody budget(Float budget) {
        this.budget = budget;
        return this;
    }

    @Schema(description="Campaign budget, required when budget_mode is BUDGET_MODE_DAY or BUDGET_MODE_TOTAL. To learn about the mininum budget and how to set budget types, see Budget settings.")
    public Float getBudget() {
        return this.budget;
    }

    public void setBudget(Float budget) {
        this.budget = budget;
    }

    public CampaignCreateBody budgetMode(String budgetMode) {
        this.budgetMode = budgetMode;
        return this;
    }

    @Schema(description="Budget mode. When Campaign Budget Optimization is enabled, only BUDGET_MODE_DAY is supported. When \"objective_type\" is RF_REACH, only BUDGET_MODE_INFINITE is supported. To learn about how to set budget types, see Budget setting.")
    public String getBudgetMode() {
        return this.budgetMode;
    }

    public void setBudgetMode(String budgetMode) {
        this.budgetMode = budgetMode;
    }

    public CampaignCreateBody budgetOptimizeOn(Boolean budgetOptimizeOn) {
        this.budgetOptimizeOn = budgetOptimizeOn;
        return this;
    }

    @Schema(description="Whether to enable Campaign Budget Optimization. True: Enabled. False: Not enabled. Default: True. For details about Campaign Budget Optimization (CBO), see Campaign Budget Optimization.")
    public Boolean isBudgetOptimizeOn() {
        return this.budgetOptimizeOn;
    }

    public void setBudgetOptimizeOn(Boolean budgetOptimizeOn) {
        this.budgetOptimizeOn = budgetOptimizeOn;
    }

    public CampaignCreateBody campaignName(String campaignName) {
        this.campaignName = campaignName;
        return this;
    }

    @Schema(required=true, description="Campaign name. It can contain up to 512 characters. Emoji is not supported. Note: Each word in Chinese or Japanese counts as two characters, while each letter in English counts as one character.")
    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public CampaignCreateBody campaignType(String campaignType) {
        this.campaignType = campaignType;
        return this;
    }

    @Schema(description="Enums values: REGULAR_CAMPAIGN, IOS14_CAMPAIGN. The value IOS14_CAMPAIGN supports the advertising objective PRODUCT_SALES only. For iOS 14 Dedicated Campaign with objectives other than PRODUCT_SALES , set campaign_type as REGULAR_CAMPAIGN.")
    public String getCampaignType() {
        return this.campaignType;
    }

    public void setCampaignType(String campaignType) {
        this.campaignType = campaignType;
    }

    public CampaignCreateBody objectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
        return this;
    }

    @Schema(required=true, description="Advertising objective. For enum values and descriptions, see Objectives.")
    public String getObjectiveType() {
        return this.objectiveType;
    }

    public void setObjectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
    }

    public CampaignCreateBody operationStatus(String operationStatus) {
        this.operationStatus = operationStatus;
        return this;
    }

    @Schema(description="The field operation_status is currently an allowlist-only feature. If you would like to access it, please contact your TikTok representative. If you pass in this field without applying for allowlisting first, the field will be ignored and no error message will appear. For Reach & Frequency campaigns, please specify operation_status as ENABLE or do not pass in operation_status. Do not specify operation_status as DISABLE.  The status of the campaign when created. Enum values: ENABLE : The campaign is enabled when created. DISABLE : The campaign is disabled when created. Default value: ENABLE. If you want to update the status of the campaign after creation, use the /campaign/status/update/ endpoint.")
    public String getOperationStatus() {
        return this.operationStatus;
    }

    public void setOperationStatus(String operationStatus) {
        this.operationStatus = operationStatus;
    }

    public CampaignCreateBody optimizationGoal(String optimizationGoal) {
        this.optimizationGoal = optimizationGoal;
        return this;
    }

    @Schema(description="Optimization goal at the campaign level. Required when Campaign Budget Optimization is enabled. Allowed values: CONVERT, INSTALL, VALUE, IN_APP_EVENT and LEAD_GENERATION.")
    public String getOptimizationGoal() {
        return this.optimizationGoal;
    }

    public void setOptimizationGoal(String optimizationGoal) {
        this.optimizationGoal = optimizationGoal;
    }

    public CampaignCreateBody rfCampaignType(String rfCampaignType) {
        this.rfCampaignType = rfCampaignType;
        return this;
    }

    @Schema(description="When `objective_type` is specified as `RF_REACH`, use this field to set the campaign as a TikTok Pulse campaign, then you can get available premium contextual tags. Do not pass in this field when `objective_type` is not specified as `RF_REACH`.Enum values- `STANDARD` (Reach & Frequency campaign), `PULSE`(TikTok Pulse campaign). Note<- This is an allowlist-only feature. If you would like to access it, please contact your TikTok representative. This field cannot be updated after creation. If you select `rf_campaign_type` to `PULSE` , then you must enter contextual tags of `PREMIUM` type in the `contextual_tag_ids`  field in [/adgroup/rf/create/](https://ads.tiktok.com/marketing_api/docs?id=1738235338194945). In this case, the CPM in your ad group is fixed. If you set `rf_campaign_type` to `PULSE`, then the targeting locations cannot be updated in  [/adgroup/rf/update/](https://ads.tiktok.com/marketing_api/docs?id=1738235402874882). If you set `rf_campaign_type` to `PULSE`, then `feed_type` cannot be `TOP_FEED` in  [/adgroup/rf/create/](https://ads.tiktok.com/marketing_api/docs?id=1738235338194945).")
    public String getRfCampaignType() {
        return this.rfCampaignType;
    }

    public void setRfCampaignType(String rfCampaignType) {
        this.rfCampaignType = rfCampaignType;
    }

    public CampaignCreateBody specialIndustries(List<String> specialIndustries) {
        this.specialIndustries = specialIndustries;
        return this;
    }

    public CampaignCreateBody addSpecialIndustriesItem(String specialIndustriesItem) {
        if (this.specialIndustries == null) {
            this.specialIndustries = new ArrayList<String>();
        }
        this.specialIndustries.add(specialIndustriesItem);
        return this;
    }

    @Schema(description="Ad categories. Enum values: HOUSING(Ads for real estate listings, homeowners insurance, mortgage loans or other related opportunities.) EMPLOYMENT(Ads for job offers, internship, professional certification programs or other related opportunities.) CREDIT(Ads for credit card offers, auto loans, long-term financing or other related opportunities.) Note: Once you've specified the industry type, the system will adjust your ad group target options to help you comply with advertising policies. See Ad targeting to know more.")
    public List<String> getSpecialIndustries() {
        return this.specialIndustries;
    }

    public void setSpecialIndustries(List<String> specialIndustries) {
        this.specialIndustries = specialIndustries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignCreateBody campaignCreateBody = (CampaignCreateBody)o;
        return Objects.equals(this.advertiserId, campaignCreateBody.advertiserId) && Objects.equals(this.appId, campaignCreateBody.appId) && Objects.equals(this.appPromotionType, campaignCreateBody.appPromotionType) && Objects.equals(this.budget, campaignCreateBody.budget) && Objects.equals(this.budgetMode, campaignCreateBody.budgetMode) && Objects.equals(this.budgetOptimizeOn, campaignCreateBody.budgetOptimizeOn) && Objects.equals(this.campaignName, campaignCreateBody.campaignName) && Objects.equals(this.campaignType, campaignCreateBody.campaignType) && Objects.equals(this.objectiveType, campaignCreateBody.objectiveType) && Objects.equals(this.operationStatus, campaignCreateBody.operationStatus) && Objects.equals(this.optimizationGoal, campaignCreateBody.optimizationGoal) && Objects.equals(this.rfCampaignType, campaignCreateBody.rfCampaignType) && Objects.equals(this.specialIndustries, campaignCreateBody.specialIndustries);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserId, this.appId, this.appPromotionType, this.budget, this.budgetMode, this.budgetOptimizeOn, this.campaignName, this.campaignType, this.objectiveType, this.operationStatus, this.optimizationGoal, this.rfCampaignType, this.specialIndustries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignCreateBody {\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    appPromotionType: ").append(this.toIndentedString(this.appPromotionType)).append("\n");
        sb.append("    budget: ").append(this.toIndentedString(this.budget)).append("\n");
        sb.append("    budgetMode: ").append(this.toIndentedString(this.budgetMode)).append("\n");
        sb.append("    budgetOptimizeOn: ").append(this.toIndentedString(this.budgetOptimizeOn)).append("\n");
        sb.append("    campaignName: ").append(this.toIndentedString(this.campaignName)).append("\n");
        sb.append("    campaignType: ").append(this.toIndentedString(this.campaignType)).append("\n");
        sb.append("    objectiveType: ").append(this.toIndentedString(this.objectiveType)).append("\n");
        sb.append("    operationStatus: ").append(this.toIndentedString(this.operationStatus)).append("\n");
        sb.append("    optimizationGoal: ").append(this.toIndentedString(this.optimizationGoal)).append("\n");
        sb.append("    rfCampaignType: ").append(this.toIndentedString(this.rfCampaignType)).append("\n");
        sb.append("    specialIndustries: ").append(this.toIndentedString(this.specialIndustries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

