/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CampaignUpdateBody {
    @JsonProperty(value="advertiser_id")
    private String advertiserId = null;
    @JsonProperty(value="budget")
    private Float budget = null;
    @JsonProperty(value="budget_mode")
    private String budgetMode = null;
    @JsonProperty(value="campaign_id")
    private String campaignId = null;
    @JsonProperty(value="campaign_name")
    private String campaignName = null;
    @JsonProperty(value="roas_bid")
    private Float roasBid = null;
    @JsonProperty(value="special_industries")
    private List<String> specialIndustries = null;

    public CampaignUpdateBody advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Schema(required=true, description="Advertiser ID")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public CampaignUpdateBody budget(Float budget) {
        this.budget = budget;
        return this;
    }

    @Schema(description="Campaign budget. Required when budget_mode is BUDGET_MODE_DAY or BUDGET_MODE_TOTAL. To learn about the mininum budget and how to set budget types, see Budget settings.")
    public Float getBudget() {
        return this.budget;
    }

    public void setBudget(Float budget) {
        this.budget = budget;
    }

    public CampaignUpdateBody budgetMode(String budgetMode) {
        this.budgetMode = budgetMode;
        return this;
    }

    @Schema(description="Budget type. When Campaign Budgeet Optimization is enabled, only BUDGET_MODE_DAY is supported. To learn about how to set budget types, see Budget setting.")
    public String getBudgetMode() {
        return this.budgetMode;
    }

    public void setBudgetMode(String budgetMode) {
        this.budgetMode = budgetMode;
    }

    public CampaignUpdateBody campaignId(String campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    @Schema(required=true, description="Campaign name. It can contain up to 512 characters. Emoji is not supported. Note: Each word in Chinese or Japanese counts as two characters, while each letter in English counts as one character.")
    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public CampaignUpdateBody campaignName(String campaignName) {
        this.campaignName = campaignName;
        return this;
    }

    @Schema(description="Campaign name. It can contain up to 512 characters. Emoji is not supported. Note: Each word in Chinese or Japanese counts as two characters, while each letter in English counts as one character.")
    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public CampaignUpdateBody roasBid(Float roasBid) {
        this.roasBid = roasBid;
        return this;
    }

    @Schema(description="ROAS (Return On Advertising Spend) goal to optimize value. This field can be modified only when Campaign Budget Optimization(budget_optimize_on) is enabled , optimization_goal is VALUE and deep_bid_type is VO_MIN_ROAS. Value range: 0.01-1000.")
    public Float getRoasBid() {
        return this.roasBid;
    }

    public void setRoasBid(Float roasBid) {
        this.roasBid = roasBid;
    }

    public CampaignUpdateBody specialIndustries(List<String> specialIndustries) {
        this.specialIndustries = specialIndustries;
        return this;
    }

    public CampaignUpdateBody addSpecialIndustriesItem(String specialIndustriesItem) {
        if (this.specialIndustries == null) {
            this.specialIndustries = new ArrayList<String>();
        }
        this.specialIndustries.add(specialIndustriesItem);
        return this;
    }

    @Schema(description="Ad categories. Enum values: HOUSING(Ads for real estate listings, homeowners insurance, mortgage loans or other related opportunities.) EMPLOYMENT(Ads for job offers, internship, professional certification programs or other related opportunities.) CREDIT(Ads for credit card offers, auto loans, long-term financing or other related opportunities.) Note: The ONLY supported operation here is that you can clear all the values for the field if you've specifed it when creating a campaign. If you've not specified the field when creating a campaign, you cannot specify it now either.")
    public List<String> getSpecialIndustries() {
        return this.specialIndustries;
    }

    public void setSpecialIndustries(List<String> specialIndustries) {
        this.specialIndustries = specialIndustries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignUpdateBody campaignUpdateBody = (CampaignUpdateBody)o;
        return Objects.equals(this.advertiserId, campaignUpdateBody.advertiserId) && Objects.equals(this.budget, campaignUpdateBody.budget) && Objects.equals(this.budgetMode, campaignUpdateBody.budgetMode) && Objects.equals(this.campaignId, campaignUpdateBody.campaignId) && Objects.equals(this.campaignName, campaignUpdateBody.campaignName) && Objects.equals(this.roasBid, campaignUpdateBody.roasBid) && Objects.equals(this.specialIndustries, campaignUpdateBody.specialIndustries);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserId, this.budget, this.budgetMode, this.campaignId, this.campaignName, this.roasBid, this.specialIndustries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignUpdateBody {\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    budget: ").append(this.toIndentedString(this.budget)).append("\n");
        sb.append("    budgetMode: ").append(this.toIndentedString(this.budgetMode)).append("\n");
        sb.append("    campaignId: ").append(this.toIndentedString(this.campaignId)).append("\n");
        sb.append("    campaignName: ").append(this.toIndentedString(this.campaignName)).append("\n");
        sb.append("    roasBid: ").append(this.toIndentedString(this.roasBid)).append("\n");
        sb.append("    specialIndustries: ").append(this.toIndentedString(this.specialIndustries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

