/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.util.Objects;

public class FileImageAdUpload {
    @JsonProperty(value="advertiser_id")
    private String advertiserId = null;
    @JsonProperty(value="file_id")
    private String fileId = null;
    @JsonProperty(value="file_name")
    private String fileName = null;
    @JsonProperty(value="image_file")
    private File imageFile = null;
    @JsonProperty(value="image_signature")
    private String imageSignature = null;
    @JsonProperty(value="image_url")
    private String imageUrl = null;
    @JsonProperty(value="upload_type")
    private String uploadType = null;

    public FileImageAdUpload advertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    @Schema(required=true, description="Advertiser ID")
    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public void setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
    }

    public FileImageAdUpload fileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    @Schema(description="The file_id of the image that you want to upload. This field is for files that are uploaded to the file repository. You can get file_id via the Upload Files endpoints. This field is required when upload_type is UPLOAD_BY_FILE_ID.")
    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public FileImageAdUpload fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(description="Image name. Length limit\uff1a1-100 characters. The default value is the file name. If the final filename has more than 100 chars, it will be cut off.")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public FileImageAdUpload imageFile(File imageFile) {
        this.imageFile = imageFile;
        return this;
    }

    @Schema(description="Picture file, required when upload_type is UPLOAD_BY_FILE.")
    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    public FileImageAdUpload imageSignature(String imageSignature) {
        this.imageSignature = imageSignature;
        return this;
    }

    @Schema(description="Md5 of the image (used for server verification). Required when upload_type is UPLOAD_BY_FILE.")
    public String getImageSignature() {
        return this.imageSignature;
    }

    public void setImageSignature(String imageSignature) {
        this.imageSignature = imageSignature;
    }

    public FileImageAdUpload imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @Schema(description="Image url address, like http://xxx.xxx. Required when upload_type is UPLOAD_BY_URL.")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public FileImageAdUpload uploadType(String uploadType) {
        this.uploadType = uploadType;
        return this;
    }

    @Schema(description="Image upload method. Default value UPLOAD_BY_FILE.   Enum values: UPLOAD_BY_FILE, UPLOAD_BY_URL, UPLOAD_BY_FILE_ID.")
    public String getUploadType() {
        return this.uploadType;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileImageAdUpload fileImageAdUpload = (FileImageAdUpload)o;
        return Objects.equals(this.advertiserId, fileImageAdUpload.advertiserId) && Objects.equals(this.fileId, fileImageAdUpload.fileId) && Objects.equals(this.fileName, fileImageAdUpload.fileName) && Objects.equals(this.imageFile, fileImageAdUpload.imageFile) && Objects.equals(this.imageSignature, fileImageAdUpload.imageSignature) && Objects.equals(this.imageUrl, fileImageAdUpload.imageUrl) && Objects.equals(this.uploadType, fileImageAdUpload.uploadType);
    }

    public int hashCode() {
        return Objects.hash(this.advertiserId, this.fileId, this.fileName, Objects.hashCode(this.imageFile), this.imageSignature, this.imageUrl, this.uploadType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileImageAdUpload {\n");
        sb.append("    advertiserId: ").append(this.toIndentedString(this.advertiserId)).append("\n");
        sb.append("    fileId: ").append(this.toIndentedString(this.fileId)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    imageFile: ").append(this.toIndentedString(this.imageFile)).append("\n");
        sb.append("    imageSignature: ").append(this.toIndentedString(this.imageSignature)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    uploadType: ").append(this.toIndentedString(this.uploadType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

