/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class Filtering {
    @JsonProperty(value="keyword")
    private String keyword = null;
    @JsonProperty(value="user_email")
    private String userEmail = null;
    @JsonProperty(value="user_id")
    private String userId = null;

    public Filtering keyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    @Schema(description="Keyword of the asset you are looking for")
    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Filtering userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @Schema(description="Email of the user that you want to get assets for. Note: `user_id` and `user_mail` cannot be set at the same time. For users that are in `BOUND` status, use `user_id` to get their assets. For users that are in `PENDING` status, use `user_email` to get their assets. Use `user_email` as filter only when you have set `asset_type` as `ADVERTISER` and the invitation for the user to join Business Center is still pending.")
    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Filtering userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Schema(description="ID of the user that you want to get assets for. Note: `user_id` and `user_mail` cannot be set at the same time. For users that are in `BOUND` status, use `user_id` to get their assets. For users that are in `PENDING` status, use `user_email` to get their assets")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filtering filtering = (Filtering)o;
        return Objects.equals(this.keyword, filtering.keyword) && Objects.equals(this.userEmail, filtering.userEmail) && Objects.equals(this.userId, filtering.userId);
    }

    public int hashCode() {
        return Objects.hash(this.keyword, this.userEmail, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Filtering {\n");
        sb.append("    keyword: ").append(this.toIndentedString(this.keyword)).append("\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

