/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FilteringAdGet {
    @JsonProperty(value="ad_ids")
    private List<String> adIds = null;
    @JsonProperty(value="adgroup_ids")
    private List<String> adgroupIds = null;
    @JsonProperty(value="billing_events")
    private List<String> billingEvents = null;
    @JsonProperty(value="campaign_ids")
    private List<String> campaignIds = null;
    @JsonProperty(value="creation_filter_end_time")
    private String creationFilterEndTime = null;
    @JsonProperty(value="creation_filter_start_time")
    private String creationFilterStartTime = null;
    @JsonProperty(value="objective_type")
    private String objectiveType = null;
    @JsonProperty(value="primary_status")
    private String primaryStatus = null;
    @JsonProperty(value="secondary_status")
    private String secondaryStatus = null;

    public FilteringAdGet adIds(List<String> adIds) {
        this.adIds = adIds;
        return this;
    }

    public FilteringAdGet addAdIdsItem(String adIdsItem) {
        if (this.adIds == null) {
            this.adIds = new ArrayList<String>();
        }
        this.adIds.add(adIdsItem);
        return this;
    }

    @Schema(description="A list of Ad ID\uff0cquantity- `1-100`")
    public List<String> getAdIds() {
        return this.adIds;
    }

    public void setAdIds(List<String> adIds) {
        this.adIds = adIds;
    }

    public FilteringAdGet adgroupIds(List<String> adgroupIds) {
        this.adgroupIds = adgroupIds;
        return this;
    }

    public FilteringAdGet addAdgroupIdsItem(String adgroupIdsItem) {
        if (this.adgroupIds == null) {
            this.adgroupIds = new ArrayList<String>();
        }
        this.adgroupIds.add(adgroupIdsItem);
        return this;
    }

    @Schema(description="A list of Ad group ID, quantity- `1-100`")
    public List<String> getAdgroupIds() {
        return this.adgroupIds;
    }

    public void setAdgroupIds(List<String> adgroupIds) {
        this.adgroupIds = adgroupIds;
    }

    public FilteringAdGet billingEvents(List<String> billingEvents) {
        this.billingEvents = billingEvents;
        return this;
    }

    public FilteringAdGet addBillingEventsItem(String billingEventsItem) {
        if (this.billingEvents == null) {
            this.billingEvents = new ArrayList<String>();
        }
        this.billingEvents.add(billingEventsItem);
        return this;
    }

    @Schema(description="Billing events. For enum values, see [Enumeration - Billing Event](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public List<String> getBillingEvents() {
        return this.billingEvents;
    }

    public void setBillingEvents(List<String> billingEvents) {
        this.billingEvents = billingEvents;
    }

    public FilteringAdGet campaignIds(List<String> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public FilteringAdGet addCampaignIdsItem(String campaignIdsItem) {
        if (this.campaignIds == null) {
            this.campaignIds = new ArrayList<String>();
        }
        this.campaignIds.add(campaignIdsItem);
        return this;
    }

    @Schema(description="A list of Campaign IDs, quantity- `1-100`")
    public List<String> getCampaignIds() {
        return this.campaignIds;
    }

    public void setCampaignIds(List<String> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public FilteringAdGet creationFilterEndTime(String creationFilterEndTime) {
        this.creationFilterEndTime = creationFilterEndTime;
        return this;
    }

    @Schema(description="Filter by higher range of ad creation time, in the format of `YYYY-MM-DD HH:MM:SS` (UTC time zone). Ads created earlier than this time will be returned.")
    public String getCreationFilterEndTime() {
        return this.creationFilterEndTime;
    }

    public void setCreationFilterEndTime(String creationFilterEndTime) {
        this.creationFilterEndTime = creationFilterEndTime;
    }

    public FilteringAdGet creationFilterStartTime(String creationFilterStartTime) {
        this.creationFilterStartTime = creationFilterStartTime;
        return this;
    }

    @Schema(description="Filter by lower range of ad creation time, in the format of `YYYY-MM-DD HH:MM:SS` (UTC time zone). Ads created later than this time will be returned. Suggestion A time range within 6 months is suggested when applying a creation time filter, to ensure that the success and speed of the task won't be affected.")
    public String getCreationFilterStartTime() {
        return this.creationFilterStartTime;
    }

    public void setCreationFilterStartTime(String creationFilterStartTime) {
        this.creationFilterStartTime = creationFilterStartTime;
    }

    public FilteringAdGet objectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
        return this;
    }

    @Schema(description="Advertising Objective. For enum values, see [Enumeration - Advertising Objective](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138). Note- Whether you choose `WEB_CONVERSIONS` or  `CONVERSIONS` as the objective filter, we will return data of both `WEB_CONVERSIONS` and  `CONVERSIONS`.")
    public String getObjectiveType() {
        return this.objectiveType;
    }

    public void setObjectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
    }

    public FilteringAdGet primaryStatus(String primaryStatus) {
        this.primaryStatus = primaryStatus;
        return this;
    }

    @Schema(description="Primary status. For enum values, see [Enumeration -Primary status](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public String getPrimaryStatus() {
        return this.primaryStatus;
    }

    public void setPrimaryStatus(String primaryStatus) {
        this.primaryStatus = primaryStatus;
    }

    public FilteringAdGet secondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
        return this;
    }

    @Schema(description="Ad status\uff08secondary status). For enum values, see [Enumeration - Ad Status - Secondary Status](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138). his field is not returned in the sandbox environment because the ad is not actually delivered. [Supported secondary statuses for a primary status](https://ads.tiktok.com/marketing_api/docs?id=1757239620352002) to learn about the valid values you can pass in via `secondary_status` for the primary status you specify.")
    public String getSecondaryStatus() {
        return this.secondaryStatus;
    }

    public void setSecondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringAdGet filteringAdGet = (FilteringAdGet)o;
        return Objects.equals(this.adIds, filteringAdGet.adIds) && Objects.equals(this.adgroupIds, filteringAdGet.adgroupIds) && Objects.equals(this.billingEvents, filteringAdGet.billingEvents) && Objects.equals(this.campaignIds, filteringAdGet.campaignIds) && Objects.equals(this.creationFilterEndTime, filteringAdGet.creationFilterEndTime) && Objects.equals(this.creationFilterStartTime, filteringAdGet.creationFilterStartTime) && Objects.equals(this.objectiveType, filteringAdGet.objectiveType) && Objects.equals(this.primaryStatus, filteringAdGet.primaryStatus) && Objects.equals(this.secondaryStatus, filteringAdGet.secondaryStatus);
    }

    public int hashCode() {
        return Objects.hash(this.adIds, this.adgroupIds, this.billingEvents, this.campaignIds, this.creationFilterEndTime, this.creationFilterStartTime, this.objectiveType, this.primaryStatus, this.secondaryStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilteringAdGet {\n");
        sb.append("    adIds: ").append(this.toIndentedString(this.adIds)).append("\n");
        sb.append("    adgroupIds: ").append(this.toIndentedString(this.adgroupIds)).append("\n");
        sb.append("    billingEvents: ").append(this.toIndentedString(this.billingEvents)).append("\n");
        sb.append("    campaignIds: ").append(this.toIndentedString(this.campaignIds)).append("\n");
        sb.append("    creationFilterEndTime: ").append(this.toIndentedString(this.creationFilterEndTime)).append("\n");
        sb.append("    creationFilterStartTime: ").append(this.toIndentedString(this.creationFilterStartTime)).append("\n");
        sb.append("    objectiveType: ").append(this.toIndentedString(this.objectiveType)).append("\n");
        sb.append("    primaryStatus: ").append(this.toIndentedString(this.primaryStatus)).append("\n");
        sb.append("    secondaryStatus: ").append(this.toIndentedString(this.secondaryStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

