/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FilteringAdgroupGet {
    @JsonProperty(value="adgroup_ids")
    private List<String> adgroupIds = null;
    @JsonProperty(value="adgroup_name")
    private String adgroupName = null;
    @JsonProperty(value="billing_events")
    private List<String> billingEvents = null;
    @JsonProperty(value="campaign_ids")
    private List<String> campaignIds = null;
    @JsonProperty(value="creation_filter_end_time")
    private String creationFilterEndTime = null;
    @JsonProperty(value="creation_filter_start_time")
    private String creationFilterStartTime = null;
    @JsonProperty(value="objective_type")
    private String objectiveType = null;
    @JsonProperty(value="primary_status")
    private String primaryStatus = null;
    @JsonProperty(value="secondary_status")
    private String secondaryStatus = null;

    public FilteringAdgroupGet adgroupIds(List<String> adgroupIds) {
        this.adgroupIds = adgroupIds;
        return this;
    }

    public FilteringAdgroupGet addAdgroupIdsItem(String adgroupIdsItem) {
        if (this.adgroupIds == null) {
            this.adgroupIds = new ArrayList<String>();
        }
        this.adgroupIds.add(adgroupIdsItem);
        return this;
    }

    @Schema(description="List of Ad group ID. Allowed number of IDs- `1-100`")
    public List<String> getAdgroupIds() {
        return this.adgroupIds;
    }

    public void setAdgroupIds(List<String> adgroupIds) {
        this.adgroupIds = adgroupIds;
    }

    public FilteringAdgroupGet adgroupName(String adgroupName) {
        this.adgroupName = adgroupName;
        return this;
    }

    @Schema(description="Ad group name.")
    public String getAdgroupName() {
        return this.adgroupName;
    }

    public void setAdgroupName(String adgroupName) {
        this.adgroupName = adgroupName;
    }

    public FilteringAdgroupGet billingEvents(List<String> billingEvents) {
        this.billingEvents = billingEvents;
        return this;
    }

    public FilteringAdgroupGet addBillingEventsItem(String billingEventsItem) {
        if (this.billingEvents == null) {
            this.billingEvents = new ArrayList<String>();
        }
        this.billingEvents.add(billingEventsItem);
        return this;
    }

    @Schema(description="Events that you want to pay for.  For enum values, see [Enumeration - Billing Event](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public List<String> getBillingEvents() {
        return this.billingEvents;
    }

    public void setBillingEvents(List<String> billingEvents) {
        this.billingEvents = billingEvents;
    }

    public FilteringAdgroupGet campaignIds(List<String> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public FilteringAdgroupGet addCampaignIdsItem(String campaignIdsItem) {
        if (this.campaignIds == null) {
            this.campaignIds = new ArrayList<String>();
        }
        this.campaignIds.add(campaignIdsItem);
        return this;
    }

    @Schema(description="List of campaign IDs. Allowed number of IDs- `1-100`")
    public List<String> getCampaignIds() {
        return this.campaignIds;
    }

    public void setCampaignIds(List<String> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public FilteringAdgroupGet creationFilterEndTime(String creationFilterEndTime) {
        this.creationFilterEndTime = creationFilterEndTime;
        return this;
    }

    @Schema(description="Filter by higher range of ad group creation time, in the format of `YYYY-MM-DD HH:MM:SS` (UTC time zone). Ad groups created earlier than this time will be returned. Suggestion- A time range within 6 months is suggested when applying a creation time filter, to ensure that the success and speed of the task won't be affected.")
    public String getCreationFilterEndTime() {
        return this.creationFilterEndTime;
    }

    public void setCreationFilterEndTime(String creationFilterEndTime) {
        this.creationFilterEndTime = creationFilterEndTime;
    }

    public FilteringAdgroupGet creationFilterStartTime(String creationFilterStartTime) {
        this.creationFilterStartTime = creationFilterStartTime;
        return this;
    }

    @Schema(description="Filter by lower range of ad group creation time, in the format of `YYYY-MM-DD HH:MM:SS` (UTC time zone). Ad groups created later than this time will be returned. Suggestion- A time range within 6 months is suggested when applying a creation time filter, to ensure that the success and speed of the task won't be affected.")
    public String getCreationFilterStartTime() {
        return this.creationFilterStartTime;
    }

    public void setCreationFilterStartTime(String creationFilterStartTime) {
        this.creationFilterStartTime = creationFilterStartTime;
    }

    public FilteringAdgroupGet objectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
        return this;
    }

    @Schema(description="Advertising objective. For details, see [Enumeration - Advertising Objective](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138). Whether you choose `WEB_CONVERSIONS` or  `CONVERSIONS` as the objective filter, we will return data of both `WEB_CONVERSIONS` and  `CONVERSIONS`.")
    public String getObjectiveType() {
        return this.objectiveType;
    }

    public void setObjectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
    }

    public FilteringAdgroupGet primaryStatus(String primaryStatus) {
        this.primaryStatus = primaryStatus;
        return this;
    }

    @Schema(description="Primary status. For enum values, see [Enumeration - Primary Status](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138). The default value is `STATUS_NOT_DELETE`, which returns ad groups in all status excluding `STATUS_DELETE`. If you want to get ad groups in all status including `STATUS_DELETE`, use `STATUS_ALL` instead.")
    public String getPrimaryStatus() {
        return this.primaryStatus;
    }

    public void setPrimaryStatus(String primaryStatus) {
        this.primaryStatus = primaryStatus;
    }

    public FilteringAdgroupGet secondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
        return this;
    }

    @Schema(description="Ad group status\uff08secondary status). For enum values, see [Enumeration - Ad Group Status - Secondary Status](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138). his field is not returned in the sandbox environment because the ad group is not actually delivered. See [Supported secondary statuses for a primary status](https://ads.tiktok.com/marketing_api/docs?id=1757239620352002) to learn about the valid values you can pass in via `secondary_status` for the primary status you specify.")
    public String getSecondaryStatus() {
        return this.secondaryStatus;
    }

    public void setSecondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringAdgroupGet filteringAdgroupGet = (FilteringAdgroupGet)o;
        return Objects.equals(this.adgroupIds, filteringAdgroupGet.adgroupIds) && Objects.equals(this.adgroupName, filteringAdgroupGet.adgroupName) && Objects.equals(this.billingEvents, filteringAdgroupGet.billingEvents) && Objects.equals(this.campaignIds, filteringAdgroupGet.campaignIds) && Objects.equals(this.creationFilterEndTime, filteringAdgroupGet.creationFilterEndTime) && Objects.equals(this.creationFilterStartTime, filteringAdgroupGet.creationFilterStartTime) && Objects.equals(this.objectiveType, filteringAdgroupGet.objectiveType) && Objects.equals(this.primaryStatus, filteringAdgroupGet.primaryStatus) && Objects.equals(this.secondaryStatus, filteringAdgroupGet.secondaryStatus);
    }

    public int hashCode() {
        return Objects.hash(this.adgroupIds, this.adgroupName, this.billingEvents, this.campaignIds, this.creationFilterEndTime, this.creationFilterStartTime, this.objectiveType, this.primaryStatus, this.secondaryStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilteringAdgroupGet {\n");
        sb.append("    adgroupIds: ").append(this.toIndentedString(this.adgroupIds)).append("\n");
        sb.append("    adgroupName: ").append(this.toIndentedString(this.adgroupName)).append("\n");
        sb.append("    billingEvents: ").append(this.toIndentedString(this.billingEvents)).append("\n");
        sb.append("    campaignIds: ").append(this.toIndentedString(this.campaignIds)).append("\n");
        sb.append("    creationFilterEndTime: ").append(this.toIndentedString(this.creationFilterEndTime)).append("\n");
        sb.append("    creationFilterStartTime: ").append(this.toIndentedString(this.creationFilterStartTime)).append("\n");
        sb.append("    objectiveType: ").append(this.toIndentedString(this.objectiveType)).append("\n");
        sb.append("    primaryStatus: ").append(this.toIndentedString(this.primaryStatus)).append("\n");
        sb.append("    secondaryStatus: ").append(this.toIndentedString(this.secondaryStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

