/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FilteringAdvertiserTransactionGet {
    @JsonProperty(value="end_date")
    private String endDate = null;
    @JsonProperty(value="funds_type")
    private List<String> fundsType = null;
    @JsonProperty(value="keyword")
    private String keyword = null;
    @JsonProperty(value="start_date")
    private String startDate = null;
    @JsonProperty(value="summary_by_account")
    private Boolean summaryByAccount = null;
    @JsonProperty(value="transfer_type")
    private String transferType = null;

    public FilteringAdvertiserTransactionGet endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Schema(description="Transaction record search end time, (UTC+0) format\uff1a`2020-11-12`. The default date is the same day")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public FilteringAdvertiserTransactionGet fundsType(List<String> fundsType) {
        this.fundsType = fundsType;
        return this;
    }

    public FilteringAdvertiserTransactionGet addFundsTypeItem(String fundsTypeItem) {
        if (this.fundsType == null) {
            this.fundsType = new ArrayList<String>();
        }
        this.fundsType.add(fundsTypeItem);
        return this;
    }

    @Schema(description="Fund type. Allowed types- `FUNDS_TYPE_CASH`(cash), `FUNDS_TYPE_GRANT`(coupon/voucher). The default is to select both types.")
    public List<String> getFundsType() {
        return this.fundsType;
    }

    public void setFundsType(List<String> fundsType) {
        this.fundsType = fundsType;
    }

    public FilteringAdvertiserTransactionGet keyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    @Schema(description="Search keywords, you can search for ad account name or ad account ID.")
    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public FilteringAdvertiserTransactionGet startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Transaction record search start time, (UTC+0) format\uff1a`2020-10-12`. The default date is 90 days ago")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public FilteringAdvertiserTransactionGet summaryByAccount(Boolean summaryByAccount) {
        this.summaryByAccount = summaryByAccount;
        return this;
    }

    @Schema(description="Whether to summarize by account. `false` means no summary; `true` means summary. Default value- `false`.")
    public Boolean isSummaryByAccount() {
        return this.summaryByAccount;
    }

    public void setSummaryByAccount(Boolean summaryByAccount) {
        this.summaryByAccount = summaryByAccount;
    }

    public FilteringAdvertiserTransactionGet transferType(String transferType) {
        this.transferType = transferType;
        return this;
    }

    @Schema(description="Billing type. Enum values- `TRANS_TYPE_TRANSFER`(transfer), `TRANS_TYPE_TAX`(tax), `TRANS_TYPE_COST`(consumption), `TRANS_TYPE_PAYMENT` (payment). Default value-  `TRANS_TYPE_TRANSFER`")
    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringAdvertiserTransactionGet filteringAdvertiserTransactionGet = (FilteringAdvertiserTransactionGet)o;
        return Objects.equals(this.endDate, filteringAdvertiserTransactionGet.endDate) && Objects.equals(this.fundsType, filteringAdvertiserTransactionGet.fundsType) && Objects.equals(this.keyword, filteringAdvertiserTransactionGet.keyword) && Objects.equals(this.startDate, filteringAdvertiserTransactionGet.startDate) && Objects.equals(this.summaryByAccount, filteringAdvertiserTransactionGet.summaryByAccount) && Objects.equals(this.transferType, filteringAdvertiserTransactionGet.transferType);
    }

    public int hashCode() {
        return Objects.hash(this.endDate, this.fundsType, this.keyword, this.startDate, this.summaryByAccount, this.transferType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilteringAdvertiserTransactionGet {\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    fundsType: ").append(this.toIndentedString(this.fundsType)).append("\n");
        sb.append("    keyword: ").append(this.toIndentedString(this.keyword)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    summaryByAccount: ").append(this.toIndentedString(this.summaryByAccount)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString(this.transferType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

