/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FilteringCampaignGet {
    @JsonProperty(value="campaign_ids")
    private List<String> campaignIds = null;
    @JsonProperty(value="creation_filter_end_time")
    private String creationFilterEndTime = null;
    @JsonProperty(value="creation_filter_start_time")
    private String creationFilterStartTime = null;
    @JsonProperty(value="objective_type")
    private String objectiveType = null;
    @JsonProperty(value="primary_status")
    private String primaryStatus = null;
    @JsonProperty(value="secondary_status")
    private String secondaryStatus = null;
    @JsonProperty(value="targeting_broaden_required")
    private Boolean targetingBroadenRequired = null;

    public FilteringCampaignGet campaignIds(List<String> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public FilteringCampaignGet addCampaignIdsItem(String campaignIdsItem) {
        if (this.campaignIds == null) {
            this.campaignIds = new ArrayList<String>();
        }
        this.campaignIds.add(campaignIdsItem);
        return this;
    }

    @Schema(description="Filter by campaign IDs. Allowable quantity- `1-100`.")
    public List<String> getCampaignIds() {
        return this.campaignIds;
    }

    public void setCampaignIds(List<String> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public FilteringCampaignGet creationFilterEndTime(String creationFilterEndTime) {
        this.creationFilterEndTime = creationFilterEndTime;
        return this;
    }

    @Schema(description="Filter by higher range of campaign creation time, in the format of `YYYY-MM-DD HH:MM:SS` (UTC time zone). Campaigns created later than this time will be returned.Suggestion- A time range within 6 months is suggested when applying a creation time filter, to ensure that the success and speed of the task won't be affected.")
    public String getCreationFilterEndTime() {
        return this.creationFilterEndTime;
    }

    public void setCreationFilterEndTime(String creationFilterEndTime) {
        this.creationFilterEndTime = creationFilterEndTime;
    }

    public FilteringCampaignGet creationFilterStartTime(String creationFilterStartTime) {
        this.creationFilterStartTime = creationFilterStartTime;
        return this;
    }

    @Schema(description="Filter by lower range of campaign creation time, in the format of `YYYY-MM-DD HH:MM:SS` (UTC time zone). Campaigns created later than this time will be returned. Suggestion- A time range within 6 months is suggested when applying a creation time filter, to ensure that the success and speed of the task won't be affected")
    public String getCreationFilterStartTime() {
        return this.creationFilterStartTime;
    }

    public void setCreationFilterStartTime(String creationFilterStartTime) {
        this.creationFilterStartTime = creationFilterStartTime;
    }

    public FilteringCampaignGet objectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
        return this;
    }

    @Schema(description="Filter by  advertising objectives, see [Enumeration-Advertising Objective](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public String getObjectiveType() {
        return this.objectiveType;
    }

    public void setObjectiveType(String objectiveType) {
        this.objectiveType = objectiveType;
    }

    public FilteringCampaignGet primaryStatus(String primaryStatus) {
        this.primaryStatus = primaryStatus;
        return this;
    }

    @Schema(description="Primary status. For enum values, see [Enumeration-Primary Status](https://ads.tiktok.com/marketing_api/docs?id=1737174886619138).")
    public String getPrimaryStatus() {
        return this.primaryStatus;
    }

    public void setPrimaryStatus(String primaryStatus) {
        this.primaryStatus = primaryStatus;
    }

    public FilteringCampaignGet secondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
        return this;
    }

    @Schema(description="Filter by campaign status\uff08Secondary status).  For enum values, see [Enumeration- Campaign Status - Secondary Status]")
    public String getSecondaryStatus() {
        return this.secondaryStatus;
    }

    public void setSecondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
    }

    public FilteringCampaignGet targetingBroadenRequired(Boolean targetingBroadenRequired) {
        this.targetingBroadenRequired = targetingBroadenRequired;
        return this;
    }

    @Schema(description="")
    public Boolean isTargetingBroadenRequired() {
        return this.targetingBroadenRequired;
    }

    public void setTargetingBroadenRequired(Boolean targetingBroadenRequired) {
        this.targetingBroadenRequired = targetingBroadenRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringCampaignGet filteringCampaignGet = (FilteringCampaignGet)o;
        return Objects.equals(this.campaignIds, filteringCampaignGet.campaignIds) && Objects.equals(this.creationFilterEndTime, filteringCampaignGet.creationFilterEndTime) && Objects.equals(this.creationFilterStartTime, filteringCampaignGet.creationFilterStartTime) && Objects.equals(this.objectiveType, filteringCampaignGet.objectiveType) && Objects.equals(this.primaryStatus, filteringCampaignGet.primaryStatus) && Objects.equals(this.secondaryStatus, filteringCampaignGet.secondaryStatus) && Objects.equals(this.targetingBroadenRequired, filteringCampaignGet.targetingBroadenRequired);
    }

    public int hashCode() {
        return Objects.hash(this.campaignIds, this.creationFilterEndTime, this.creationFilterStartTime, this.objectiveType, this.primaryStatus, this.secondaryStatus, this.targetingBroadenRequired);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilteringCampaignGet {\n");
        sb.append("    campaignIds: ").append(this.toIndentedString(this.campaignIds)).append("\n");
        sb.append("    creationFilterEndTime: ").append(this.toIndentedString(this.creationFilterEndTime)).append("\n");
        sb.append("    creationFilterStartTime: ").append(this.toIndentedString(this.creationFilterStartTime)).append("\n");
        sb.append("    objectiveType: ").append(this.toIndentedString(this.objectiveType)).append("\n");
        sb.append("    primaryStatus: ").append(this.toIndentedString(this.primaryStatus)).append("\n");
        sb.append("    secondaryStatus: ").append(this.toIndentedString(this.secondaryStatus)).append("\n");
        sb.append("    targetingBroadenRequired: ").append(this.toIndentedString(this.targetingBroadenRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

