/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FilteringVideoAdSearch {
    @JsonProperty(value="displayable")
    private Boolean displayable = null;
    @JsonProperty(value="height")
    private Integer height = null;
    @JsonProperty(value="material_ids")
    private List<String> materialIds = null;
    @JsonProperty(value="ratio")
    private List<BigDecimal> ratio = null;
    @JsonProperty(value="video_ids")
    private List<String> videoIds = null;
    @JsonProperty(value="width")
    private Integer width = null;

    public FilteringVideoAdSearch displayable(Boolean displayable) {
        this.displayable = displayable;
        return this;
    }

    @Schema(description="Enum values: \\n False(default value): Search in all materials \\n True: Search in the materials displayed on the platform.")
    public Boolean isDisplayable() {
        return this.displayable;
    }

    public void setDisplayable(Boolean displayable) {
        this.displayable = displayable;
    }

    public FilteringVideoAdSearch height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(description="Video height.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public FilteringVideoAdSearch materialIds(List<String> materialIds) {
        this.materialIds = materialIds;
        return this;
    }

    public FilteringVideoAdSearch addMaterialIdsItem(String materialIdsItem) {
        if (this.materialIds == null) {
            this.materialIds = new ArrayList<String>();
        }
        this.materialIds.add(materialIdsItem);
        return this;
    }

    @Schema(description="A list of material IDs. At most 100 IDs can be included in the list.")
    public List<String> getMaterialIds() {
        return this.materialIds;
    }

    public void setMaterialIds(List<String> materialIds) {
        this.materialIds = materialIds;
    }

    public FilteringVideoAdSearch ratio(List<BigDecimal> ratio) {
        this.ratio = ratio;
        return this;
    }

    public FilteringVideoAdSearch addRatioItem(BigDecimal ratioItem) {
        if (this.ratio == null) {
            this.ratio = new ArrayList<BigDecimal>();
        }
        this.ratio.add(ratioItem);
        return this;
    }

    @Schema(description="Video aspect ratio, e.g.: [1.7, 2.5]. Use 1.7 to search for videos with aspect ratio between 1.65-1.75, i.e. the precision floating point is 0.05.")
    public List<BigDecimal> getRatio() {
        return this.ratio;
    }

    public void setRatio(List<BigDecimal> ratio) {
        this.ratio = ratio;
    }

    public FilteringVideoAdSearch videoIds(List<String> videoIds) {
        this.videoIds = videoIds;
        return this;
    }

    public FilteringVideoAdSearch addVideoIdsItem(String videoIdsItem) {
        if (this.videoIds == null) {
            this.videoIds = new ArrayList<String>();
        }
        this.videoIds.add(videoIdsItem);
        return this;
    }

    @Schema(description="A list of video IDs. At most 100 IDs can be included in the list.")
    public List<String> getVideoIds() {
        return this.videoIds;
    }

    public void setVideoIds(List<String> videoIds) {
        this.videoIds = videoIds;
    }

    public FilteringVideoAdSearch width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(description="Video width.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringVideoAdSearch filteringVideoAdSearch = (FilteringVideoAdSearch)o;
        return Objects.equals(this.displayable, filteringVideoAdSearch.displayable) && Objects.equals(this.height, filteringVideoAdSearch.height) && Objects.equals(this.materialIds, filteringVideoAdSearch.materialIds) && Objects.equals(this.ratio, filteringVideoAdSearch.ratio) && Objects.equals(this.videoIds, filteringVideoAdSearch.videoIds) && Objects.equals(this.width, filteringVideoAdSearch.width);
    }

    public int hashCode() {
        return Objects.hash(this.displayable, this.height, this.materialIds, this.ratio, this.videoIds, this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilteringVideoAdSearch {\n");
        sb.append("    displayable: ").append(this.toIndentedString(this.displayable)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    materialIds: ").append(this.toIndentedString(this.materialIds)).append("\n");
        sb.append("    ratio: ").append(this.toIndentedString(this.ratio)).append("\n");
        sb.append("    videoIds: ").append(this.toIndentedString(this.videoIds)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

