/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class Oauth2AccessTokenBody {
    @JsonProperty(value="app_id")
    private String appId = null;
    @JsonProperty(value="auth_code")
    private String authCode = null;
    @JsonProperty(value="secret")
    private String secret = null;

    public Oauth2AccessTokenBody appId(String appId) {
        this.appId = appId;
        return this;
    }

    @Schema(required=true, description="The App ID applied by the developer. It can be found in the Basic Information section for you app under [My Apps](https://ads.tiktok.com/marketing_api/apps/).")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Oauth2AccessTokenBody authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @Schema(required=true, description="Authorization code provided once the callback is complete.")
    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public Oauth2AccessTokenBody secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Schema(required=true, description="The private key of the developer's App. It can be found in the Basic Information section for your app under [My Apps](https://ads.tiktok.com/marketing_api/apps/).")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Oauth2AccessTokenBody oauth2AccessTokenBody = (Oauth2AccessTokenBody)o;
        return Objects.equals(this.appId, oauth2AccessTokenBody.appId) && Objects.equals(this.authCode, oauth2AccessTokenBody.authCode) && Objects.equals(this.secret, oauth2AccessTokenBody.secret);
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.authCode, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Oauth2AccessTokenBody {\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

