/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Qualification information.  Required when your Business Center type is `AGENCY`. <p><span style=\"color:darkred\"><b>Note</b></span>: Do not specify this object when your Business Center type is `DIRECT`, or an error will occur.")
public class OpenApiv13bcadvertisercreateQualificationInfo {
    @JsonProperty(value="license_image_id")
    private String licenseImageId = null;
    @JsonProperty(value="license_no")
    private String licenseNo = null;
    @JsonProperty(value="promotion_link")
    private String promotionLink = null;
    @JsonProperty(value="qualification_image_ids")
    private List<String> qualificationImageIds = null;

    public OpenApiv13bcadvertisercreateQualificationInfo licenseImageId(String licenseImageId) {
        this.licenseImageId = licenseImageId;
        return this;
    }

    @Schema(description="Qualified Document picture ID, see [Upload a business certificate](https://ads.tiktok.com/marketing_api/docs?id=1739938996913218). Note: This field is required for ad accounts that are registered in the Chinese mainland or Hong Kong")
    public String getLicenseImageId() {
        return this.licenseImageId;
    }

    public void setLicenseImageId(String licenseImageId) {
        this.licenseImageId = licenseImageId;
    }

    public OpenApiv13bcadvertisercreateQualificationInfo licenseNo(String licenseNo) {
        this.licenseNo = licenseNo;
        return this;
    }

    @Schema(description="Business license number. This field is required for ad accounts that are registered in the Chinese mainland, Hong Kong, or in countries Brazil and Mexico")
    public String getLicenseNo() {
        return this.licenseNo;
    }

    public void setLicenseNo(String licenseNo) {
        this.licenseNo = licenseNo;
    }

    public OpenApiv13bcadvertisercreateQualificationInfo promotionLink(String promotionLink) {
        this.promotionLink = promotionLink;
        return this;
    }

    @Schema(description="Promotion link. Required when your Business Center type is `AGENCY`. Length cannot exceed 255 characters")
    public String getPromotionLink() {
        return this.promotionLink;
    }

    public void setPromotionLink(String promotionLink) {
        this.promotionLink = promotionLink;
    }

    public OpenApiv13bcadvertisercreateQualificationInfo qualificationImageIds(List<String> qualificationImageIds) {
        this.qualificationImageIds = qualificationImageIds;
        return this;
    }

    public OpenApiv13bcadvertisercreateQualificationInfo addQualificationImageIdsItem(String qualificationImageIdsItem) {
        if (this.qualificationImageIds == null) {
            this.qualificationImageIds = new ArrayList<String>();
        }
        this.qualificationImageIds.add(qualificationImageIdsItem);
        return this;
    }

    @Schema(description="Other Qualified Documents picture ID. See [Upload a business certificate](https://ads.tiktok.com/marketing_api/docs?id=1739938996913218). Note: This field is required if the ad account or the Business Center is registered in France, Brazil, or Mexico")
    public List<String> getQualificationImageIds() {
        return this.qualificationImageIds;
    }

    public void setQualificationImageIds(List<String> qualificationImageIds) {
        this.qualificationImageIds = qualificationImageIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenApiv13bcadvertisercreateQualificationInfo openApiv13bcadvertisercreateQualificationInfo = (OpenApiv13bcadvertisercreateQualificationInfo)o;
        return Objects.equals(this.licenseImageId, openApiv13bcadvertisercreateQualificationInfo.licenseImageId) && Objects.equals(this.licenseNo, openApiv13bcadvertisercreateQualificationInfo.licenseNo) && Objects.equals(this.promotionLink, openApiv13bcadvertisercreateQualificationInfo.promotionLink) && Objects.equals(this.qualificationImageIds, openApiv13bcadvertisercreateQualificationInfo.qualificationImageIds);
    }

    public int hashCode() {
        return Objects.hash(this.licenseImageId, this.licenseNo, this.promotionLink, this.qualificationImageIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenApiv13bcadvertisercreateQualificationInfo {\n");
        sb.append("    licenseImageId: ").append(this.toIndentedString(this.licenseImageId)).append("\n");
        sb.append("    licenseNo: ").append(this.toIndentedString(this.licenseNo)).append("\n");
        sb.append("    promotionLink: ").append(this.toIndentedString(this.promotionLink)).append("\n");
        sb.append("    qualificationImageIds: ").append(this.toIndentedString(this.qualificationImageIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

