/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Details of the Countdown Sticker you want to create. You can see an example of Countdown Sticker in [Countdown Sticker](https://ads.tiktok.com/help/article?aid=10007423). Note: You can only create one countdown sticker at a time")
public class OpenApiv13creativeportfoliocreateStickerParam {
    @JsonProperty(value="color")
    private String color = null;
    @JsonProperty(value="cutoff_time")
    private String cutoffTime = null;
    @JsonProperty(value="display_angle")
    private Integer displayAngle = null;
    @JsonProperty(value="landing_page_url")
    private String landingPageUrl = null;
    @JsonProperty(value="live_tiktok_user_id")
    private String liveTiktokUserId = null;
    @JsonProperty(value="opacity")
    private String opacity = null;
    @JsonProperty(value="position_x")
    private Integer positionX = null;
    @JsonProperty(value="position_y")
    private Integer positionY = null;
    @JsonProperty(value="reminder_time")
    private String reminderTime = null;
    @JsonProperty(value="size")
    private String size = null;
    @JsonProperty(value="sticker_type")
    private String stickerType = null;
    @JsonProperty(value="title")
    private String title = null;

    public OpenApiv13creativeportfoliocreateStickerParam color(String color) {
        this.color = color;
        return this;
    }

    @Schema(description="Background color of the sticker. Enum values: `ORANGE`(orange), `BLACK`(black), `RED`(red), `BLUE`(blue)")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public OpenApiv13creativeportfoliocreateStickerParam cutoffTime(String cutoffTime) {
        this.cutoffTime = cutoffTime;
        return this;
    }

    @Schema(description="Countdown deadline (when `sticker_type`= `COUNTDOWN` or `REMINDER_COUNTDOWN`) or LIVE start time (when `sticker_type`=`LIVE_REMINDER_COUNTDOWN`) for the Countdown Sticker, in the format of \"2022-10-30 00:00:00\" (UTC+0 Time). Note: The time you pass in via this field is regarded as UTC+0 time by default and you cannot modify the default time zone")
    public String getCutoffTime() {
        return this.cutoffTime;
    }

    public void setCutoffTime(String cutoffTime) {
        this.cutoffTime = cutoffTime;
    }

    public OpenApiv13creativeportfoliocreateStickerParam displayAngle(Integer displayAngle) {
        this.displayAngle = displayAngle;
        return this;
    }

    @Schema(description="Sticker display angle. Value range: `[-180, +180]`. `+90` means to rotate the sticker clockwise by 90 degrees")
    public Integer getDisplayAngle() {
        return this.displayAngle;
    }

    public void setDisplayAngle(Integer displayAngle) {
        this.displayAngle = displayAngle;
    }

    public OpenApiv13creativeportfoliocreateStickerParam landingPageUrl(String landingPageUrl) {
        this.landingPageUrl = landingPageUrl;
        return this;
    }

    @Schema(description="The landing page URL you will be redirected to when you click the reminder after the countdown for an non-LIVE event ends. Required when `sticker_type` is `REMINDER_COUNTDOWN`")
    public String getLandingPageUrl() {
        return this.landingPageUrl;
    }

    public void setLandingPageUrl(String landingPageUrl) {
        this.landingPageUrl = landingPageUrl;
    }

    public OpenApiv13creativeportfoliocreateStickerParam liveTiktokUserId(String liveTiktokUserId) {
        this.liveTiktokUserId = liveTiktokUserId;
        return this;
    }

    @Schema(description="TikTok user ID of the LIVE event host. Required when `sticker_type` is `LIVE_REMINDER_COUNTDOWN`. After specifying this field, you will be redirected to the host LIVE room when you click the reminder for a LIVE event")
    public String getLiveTiktokUserId() {
        return this.liveTiktokUserId;
    }

    public void setLiveTiktokUserId(String liveTiktokUserId) {
        this.liveTiktokUserId = liveTiktokUserId;
    }

    public OpenApiv13creativeportfoliocreateStickerParam opacity(String opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(description="Sticker opacity. Enum values: `0.7`, `0.8`, `0.9`, `1`. The lower the value, the more transparent the sticker will be")
    public String getOpacity() {
        return this.opacity;
    }

    public void setOpacity(String opacity) {
        this.opacity = opacity;
    }

    public OpenApiv13creativeportfoliocreateStickerParam positionX(Integer positionX) {
        this.positionX = positionX;
        return this;
    }

    @Schema(description="The x-axis coordinate relative to the top-left corner of the screen. Value range: 50-109")
    public Integer getPositionX() {
        return this.positionX;
    }

    public void setPositionX(Integer positionX) {
        this.positionX = positionX;
    }

    public OpenApiv13creativeportfoliocreateStickerParam positionY(Integer positionY) {
        this.positionY = positionY;
        return this;
    }

    @Schema(description="The y-axis coordinate relative to the top-left corner of the screen. Value range: 141-506")
    public Integer getPositionY() {
        return this.positionY;
    }

    public void setPositionY(Integer positionY) {
        this.positionY = positionY;
    }

    public OpenApiv13creativeportfoliocreateStickerParam reminderTime(String reminderTime) {
        this.reminderTime = reminderTime;
        return this;
    }

    @Schema(description="The time set for the reminder. Required when `sticker_type`= `REMINDER_COUNTDOWN` or `LIVE_REMINDER_COUNTDOWN`.For non-LIVE stickers (when `sticker_type`= `REMINDER_COUNTDOWN`), the enum values are:`ONE_MINUTE_EARLIER`: send the reminder one minute before the non-LIVE event.`ONE_HOUR_EARLIER `: send the reminder one hour before the non-LIVE event.`ONE_DAY_EARLIER`: send the reminder one day before the non-LIVE event.For LIVE stickers (when `sticker_type`= `LIVE_REMINDER_COUNTDOWN`), the enum values are: `ONE_MINUTE_AFTER`: send the reminder one minute after the LIVE event starts.`FIVE_MINUTES_AFTER`: send the reminder five minutes after the LIVE event starts.`TEN_MINUTES_AFTER`: send the reminder ten minutes after the LIVE event starts. ")
    public String getReminderTime() {
        return this.reminderTime;
    }

    public void setReminderTime(String reminderTime) {
        this.reminderTime = reminderTime;
    }

    public OpenApiv13creativeportfoliocreateStickerParam size(String size) {
        this.size = size;
        return this;
    }

    @Schema(description="")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public OpenApiv13creativeportfoliocreateStickerParam stickerType(String stickerType) {
        this.stickerType = stickerType;
        return this;
    }

    @Schema(description="Sticker type. Default value: `COUNTDOWN`. Enum values: `COUNTDOWN`: A Countdown Sticker with no reminder.`REMINDER_COUNTDOWN`: A Countdown Sticker with reminder for a non-LIVE event.`LIVE_REMINDER_COUNTDOWN`: A Countdown Sticker with reminder for a LIVE event.")
    public String getStickerType() {
        return this.stickerType;
    }

    public void setStickerType(String stickerType) {
        this.stickerType = stickerType;
    }

    public OpenApiv13creativeportfoliocreateStickerParam title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="Sticker title. The maximum length is 54, in UTF-8 bytes (54 English letters or 18 Chinese characters), and the hashtag symbol (#) is not supported")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenApiv13creativeportfoliocreateStickerParam openApiv13creativeportfoliocreateStickerParam = (OpenApiv13creativeportfoliocreateStickerParam)o;
        return Objects.equals(this.color, openApiv13creativeportfoliocreateStickerParam.color) && Objects.equals(this.cutoffTime, openApiv13creativeportfoliocreateStickerParam.cutoffTime) && Objects.equals(this.displayAngle, openApiv13creativeportfoliocreateStickerParam.displayAngle) && Objects.equals(this.landingPageUrl, openApiv13creativeportfoliocreateStickerParam.landingPageUrl) && Objects.equals(this.liveTiktokUserId, openApiv13creativeportfoliocreateStickerParam.liveTiktokUserId) && Objects.equals(this.opacity, openApiv13creativeportfoliocreateStickerParam.opacity) && Objects.equals(this.positionX, openApiv13creativeportfoliocreateStickerParam.positionX) && Objects.equals(this.positionY, openApiv13creativeportfoliocreateStickerParam.positionY) && Objects.equals(this.reminderTime, openApiv13creativeportfoliocreateStickerParam.reminderTime) && Objects.equals(this.size, openApiv13creativeportfoliocreateStickerParam.size) && Objects.equals(this.stickerType, openApiv13creativeportfoliocreateStickerParam.stickerType) && Objects.equals(this.title, openApiv13creativeportfoliocreateStickerParam.title);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.cutoffTime, this.displayAngle, this.landingPageUrl, this.liveTiktokUserId, this.opacity, this.positionX, this.positionY, this.reminderTime, this.size, this.stickerType, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenApiv13creativeportfoliocreateStickerParam {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    cutoffTime: ").append(this.toIndentedString(this.cutoffTime)).append("\n");
        sb.append("    displayAngle: ").append(this.toIndentedString(this.displayAngle)).append("\n");
        sb.append("    landingPageUrl: ").append(this.toIndentedString(this.landingPageUrl)).append("\n");
        sb.append("    liveTiktokUserId: ").append(this.toIndentedString(this.liveTiktokUserId)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    positionX: ").append(this.toIndentedString(this.positionX)).append("\n");
        sb.append("    positionY: ").append(this.toIndentedString(this.positionY)).append("\n");
        sb.append("    reminderTime: ").append(this.toIndentedString(this.reminderTime)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    stickerType: ").append(this.toIndentedString(this.stickerType)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

