/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

public class PixelContent {
    @JsonProperty(value="content_category")
    private String contentCategory = null;
    @JsonProperty(value="content_id")
    private String contentId = null;
    @JsonProperty(value="content_name")
    private String contentName = null;
    @JsonProperty(value="content_type")
    private String contentType = null;
    @JsonProperty(value="price")
    private BigDecimal price = null;
    @JsonProperty(value="quantity")
    private Integer quantity = null;
    @JsonProperty(value="status")
    private String status = null;

    public PixelContent contentCategory(String contentCategory) {
        this.contentCategory = contentCategory;
        return this;
    }

    @Schema(description="Category of the page/product.")
    public String getContentCategory() {
        return this.contentCategory;
    }

    public void setContentCategory(String contentCategory) {
        this.contentCategory = contentCategory;
    }

    public PixelContent contentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    @Schema(description="ID of the product item. Example `1077218`")
    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public PixelContent contentName(String contentName) {
        this.contentName = contentName;
        return this;
    }

    @Schema(description="Name of the page/product.")
    public String getContentName() {
        return this.contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }

    public PixelContent contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Schema(description="The content_type object propertys value must be set to either `product`, or `product_group`, depending on how you will configure your data feed when you set up your product catalog. If you will be tracking events associated with individual products, set the value to `product`. If you are tracking events associated with product groups, set it to `product_group` instead.")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public PixelContent price(BigDecimal price) {
        this.price = price;
        return this;
    }

    @Schema(description="The price of the item. Note: Price is the price for a single item, and value is the total price of the order. For example, if you have two items each sold for $10, the price parameter would pass 10 and the value parameter would pass 20.")
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public PixelContent quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="The number of the item. ")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public PixelContent status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Status of an order, item, or service. Note: Depending on your use of status, Events API may be required in order to share status changes to TikTok.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelContent pixelContent = (PixelContent)o;
        return Objects.equals(this.contentCategory, pixelContent.contentCategory) && Objects.equals(this.contentId, pixelContent.contentId) && Objects.equals(this.contentName, pixelContent.contentName) && Objects.equals(this.contentType, pixelContent.contentType) && Objects.equals(this.price, pixelContent.price) && Objects.equals(this.quantity, pixelContent.quantity) && Objects.equals(this.status, pixelContent.status);
    }

    public int hashCode() {
        return Objects.hash(this.contentCategory, this.contentId, this.contentName, this.contentType, this.price, this.quantity, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PixelContent {\n");
        sb.append("    contentCategory: ").append(this.toIndentedString(this.contentCategory)).append("\n");
        sb.append("    contentId: ").append(this.toIndentedString(this.contentId)).append("\n");
        sb.append("    contentName: ").append(this.toIndentedString(this.contentName)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

