/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import business_api_client.PixelContextAd;
import business_api_client.PixelContextPage;
import business_api_client.PixelContextUser;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Required to attribute events to TikTok campaigns. The context object can be removed for testing event fires")
public class PixelContext {
    @JsonProperty(value="ad")
    private PixelContextAd ad = null;
    @JsonProperty(value="ip")
    private String ip = null;
    @JsonProperty(value="page")
    private PixelContextPage page = null;
    @JsonProperty(value="user")
    private PixelContextUser user = null;
    @JsonProperty(value="user_agent")
    private String userAgent = null;

    public PixelContext ad(PixelContextAd ad) {
        this.ad = ad;
        return this;
    }

    @Schema(description="")
    public PixelContextAd getAd() {
        return this.ad;
    }

    public void setAd(PixelContextAd ad) {
        this.ad = ad;
    }

    public PixelContext ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Schema(description="Non-hashed public IP address of the browser. To increase the probability of matching website visitor events with TikTok ads, we recommend sending both ip and user_agent.")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public PixelContext page(PixelContextPage page) {
        this.page = page;
        return this;
    }

    @Schema(description="")
    public PixelContextPage getPage() {
        return this.page;
    }

    public void setPage(PixelContextPage page) {
        this.page = page;
    }

    public PixelContext user(PixelContextUser user) {
        this.user = user;
        return this;
    }

    @Schema(description="")
    public PixelContextUser getUser() {
        return this.user;
    }

    public void setUser(PixelContextUser user) {
        this.user = user;
    }

    public PixelContext userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Schema(description="Non-hashed user agent from the user\u2019s device. To increase the probability of matching website visitor events with TikTok ads, we recommend sending both ip and user_agent.")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelContext pixelContext = (PixelContext)o;
        return Objects.equals(this.ad, pixelContext.ad) && Objects.equals(this.ip, pixelContext.ip) && Objects.equals(this.page, pixelContext.page) && Objects.equals(this.user, pixelContext.user) && Objects.equals(this.userAgent, pixelContext.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.ad, this.ip, this.page, this.user, this.userAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PixelContext {\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

